/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.taskmanager;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class TaskManagerMetricsInfo {
    public static final String FIELD_NAME_HEAP_USED = "heapUsed";
    public static final String FIELD_NAME_HEAP_COMMITTED = "heapCommitted";
    public static final String FIELD_NAME_HEAP_MAX = "heapMax";
    public static final String FIELD_NAME_NON_HEAP_USED = "nonHeapUsed";
    public static final String FIELD_NAME_NON_HEAP_COMMITTED = "nonHeapCommitted";
    public static final String FIELD_NAME_NON_HEAP_MAX = "nonHeapMax";
    public static final String FIELD_NAME_DIRECT_COUNT = "directCount";
    public static final String FIELD_NAME_DIRECT_USED = "directUsed";
    public static final String FIELD_NAME_DIRECT_MAX = "directMax";
    public static final String FIELD_NAME_MAPPED_COUNT = "mappedCount";
    public static final String FIELD_NAME_MAPPED_USED = "mappedUsed";
    public static final String FIELD_NAME_MAPPED_MAX = "mappedMax";
    @Deprecated
    public static final String FIELD_NAME_NETWORK_MEMORY_SEGMENTS_AVAILABLE = "memorySegmentsAvailable";
    @Deprecated
    public static final String FIELD_NAME_NETWORK_MEMORY_SEGMENTS_TOTAL = "memorySegmentsTotal";
    public static final String FIELD_NAME_SHUFFLE_MEMORY_SEGMENTS_AVAILABLE = "nettyShuffleMemorySegmentsAvailable";
    public static final String FIELD_NAME_SHUFFLE_MEMORY_SEGMENTS_USED = "nettyShuffleMemorySegmentsUsed";
    public static final String FIELD_NAME_SHUFFLE_MEMORY_SEGMENTS_TOTAL = "nettyShuffleMemorySegmentsTotal";
    public static final String FIELD_NAME_SHUFFLE_MEMORY_AVAILABLE = "nettyShuffleMemoryAvailable";
    public static final String FIELD_NAME_SHUFFLE_MEMORY_USED = "nettyShuffleMemoryUsed";
    public static final String FIELD_NAME_SHUFFLE_MEMORY_TOTAL = "nettyShuffleMemoryTotal";
    public static final String FIELD_NAME_GARBAGE_COLLECTORS = "garbageCollectors";
    @JsonProperty(value="heapUsed")
    private final long heapUsed;
    @JsonProperty(value="heapCommitted")
    private final long heapCommitted;
    @JsonProperty(value="heapMax")
    private final long heapMax;
    @JsonProperty(value="nonHeapUsed")
    private final long nonHeapUsed;
    @JsonProperty(value="nonHeapCommitted")
    private final long nonHeapCommitted;
    @JsonProperty(value="nonHeapMax")
    private final long nonHeapMax;
    @JsonProperty(value="directCount")
    private final long directCount;
    @JsonProperty(value="directUsed")
    private final long directUsed;
    @JsonProperty(value="directMax")
    private final long directMax;
    @JsonProperty(value="mappedCount")
    private final long mappedCount;
    @JsonProperty(value="mappedUsed")
    private final long mappedUsed;
    @JsonProperty(value="mappedMax")
    private final long mappedMax;
    @JsonProperty(value="nettyShuffleMemorySegmentsAvailable")
    private final long shuffleMemorySegmentsAvailable;
    @JsonProperty(value="nettyShuffleMemorySegmentsUsed")
    private final long shuffleMemorySegmentsUsed;
    @JsonProperty(value="nettyShuffleMemorySegmentsTotal")
    private final long shuffleMemorySegmentsTotal;
    @JsonProperty(value="nettyShuffleMemoryAvailable")
    private final long shuffleMemoryAvailable;
    @JsonProperty(value="nettyShuffleMemoryUsed")
    private final long shuffleMemoryUsed;
    @JsonProperty(value="nettyShuffleMemoryTotal")
    private final long shuffleMemoryTotal;
    @JsonProperty(value="garbageCollectors")
    private final List<GarbageCollectorInfo> garbageCollectorsInfo;

    public TaskManagerMetricsInfo(long heapUsed, long heapCommitted, long heapMax, long nonHeapUsed, long nonHeapCommitted, long nonHeapMax, long directCount, long directUsed, long directMax, long mappedCount, long mappedUsed, long mappedMax, long shuffleMemorySegmentsAvailable, long shuffleMemorySegmentsUsed, long shuffleMemorySegmentsTotal, long shuffleMemoryAvailable, long shuffleMemoryUsed, long shuffleMemoryTotal, List<GarbageCollectorInfo> garbageCollectorsInfo) {
        this(heapUsed, heapCommitted, heapMax, nonHeapUsed, nonHeapCommitted, nonHeapMax, directCount, directUsed, directMax, mappedCount, mappedUsed, mappedMax, -1L, -1L, shuffleMemorySegmentsAvailable, shuffleMemorySegmentsUsed, shuffleMemorySegmentsTotal, shuffleMemoryAvailable, shuffleMemoryUsed, shuffleMemoryTotal, garbageCollectorsInfo);
    }

    @JsonCreator
    public TaskManagerMetricsInfo(@JsonProperty(value="heapUsed") long heapUsed, @JsonProperty(value="heapCommitted") long heapCommitted, @JsonProperty(value="heapMax") long heapMax, @JsonProperty(value="nonHeapUsed") long nonHeapUsed, @JsonProperty(value="nonHeapCommitted") long nonHeapCommitted, @JsonProperty(value="nonHeapMax") long nonHeapMax, @JsonProperty(value="directCount") long directCount, @JsonProperty(value="directUsed") long directUsed, @JsonProperty(value="directMax") long directMax, @JsonProperty(value="mappedCount") long mappedCount, @JsonProperty(value="mappedUsed") long mappedUsed, @JsonProperty(value="mappedMax") long mappedMax, @JsonProperty(value="memorySegmentsAvailable") long ignoredNetworkMemorySegmentsAvailable, @JsonProperty(value="memorySegmentsTotal") long ignoredNetworkMemorySegmentsTotal, @JsonProperty(value="nettyShuffleMemorySegmentsAvailable") long shuffleMemorySegmentsAvailable, @JsonProperty(value="nettyShuffleMemorySegmentsUsed") long shuffleMemorySegmentsUsed, @JsonProperty(value="nettyShuffleMemorySegmentsTotal") long shuffleMemorySegmentsTotal, @JsonProperty(value="nettyShuffleMemoryAvailable") long shuffleMemoryAvailable, @JsonProperty(value="nettyShuffleMemoryUsed") long shuffleMemoryUsed, @JsonProperty(value="nettyShuffleMemoryTotal") long shuffleMemoryTotal, @JsonProperty(value="garbageCollectors") List<GarbageCollectorInfo> garbageCollectorsInfo) {
        this.heapUsed = heapUsed;
        this.heapCommitted = heapCommitted;
        this.heapMax = heapMax;
        this.nonHeapUsed = nonHeapUsed;
        this.nonHeapCommitted = nonHeapCommitted;
        this.nonHeapMax = nonHeapMax;
        this.directCount = directCount;
        this.directUsed = directUsed;
        this.directMax = directMax;
        this.mappedCount = mappedCount;
        this.mappedUsed = mappedUsed;
        this.mappedMax = mappedMax;
        this.shuffleMemorySegmentsAvailable = shuffleMemorySegmentsAvailable;
        this.shuffleMemorySegmentsUsed = shuffleMemorySegmentsUsed;
        this.shuffleMemorySegmentsTotal = shuffleMemorySegmentsTotal;
        this.shuffleMemoryAvailable = shuffleMemoryAvailable;
        this.shuffleMemoryUsed = shuffleMemoryUsed;
        this.shuffleMemoryTotal = shuffleMemoryTotal;
        this.garbageCollectorsInfo = Preconditions.checkNotNull(garbageCollectorsInfo);
    }

    @Deprecated
    @JsonProperty(value="memorySegmentsAvailable")
    private long getMemorySegmentsAvailable() {
        return this.shuffleMemorySegmentsAvailable;
    }

    @Deprecated
    @JsonProperty(value="memorySegmentsTotal")
    private long getMemorySegmentsTotal() {
        return this.shuffleMemorySegmentsTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskManagerMetricsInfo that = (TaskManagerMetricsInfo)o;
        return this.heapUsed == that.heapUsed && this.heapCommitted == that.heapCommitted && this.heapMax == that.heapMax && this.nonHeapUsed == that.nonHeapUsed && this.nonHeapCommitted == that.nonHeapCommitted && this.nonHeapMax == that.nonHeapMax && this.directCount == that.directCount && this.directUsed == that.directUsed && this.directMax == that.directMax && this.mappedCount == that.mappedCount && this.mappedUsed == that.mappedUsed && this.mappedMax == that.mappedMax && this.shuffleMemorySegmentsAvailable == that.shuffleMemorySegmentsAvailable && this.shuffleMemorySegmentsUsed == that.shuffleMemorySegmentsUsed && this.shuffleMemorySegmentsTotal == that.shuffleMemorySegmentsTotal && this.shuffleMemoryAvailable == that.shuffleMemoryAvailable && this.shuffleMemoryUsed == that.shuffleMemoryUsed && this.shuffleMemoryTotal == that.shuffleMemoryTotal && Objects.equals(this.garbageCollectorsInfo, that.garbageCollectorsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.heapUsed, this.heapCommitted, this.heapMax, this.nonHeapUsed, this.nonHeapCommitted, this.nonHeapMax, this.directCount, this.directUsed, this.directMax, this.mappedCount, this.mappedUsed, this.mappedMax, this.shuffleMemorySegmentsAvailable, this.shuffleMemorySegmentsUsed, this.shuffleMemorySegmentsTotal, this.shuffleMemoryAvailable, this.shuffleMemoryUsed, this.shuffleMemoryTotal, this.garbageCollectorsInfo);
    }

    public static TaskManagerMetricsInfo empty() {
        return new TaskManagerMetricsInfo(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, Collections.emptyList());
    }

    public static class GarbageCollectorInfo {
        public static final String FIELD_NAME_NAME = "name";
        public static final String FIELD_NAME_COUNT = "count";
        public static final String FIELD_NAME_TIME = "time";
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="count")
        private final long count;
        @JsonProperty(value="time")
        private final long time;

        @JsonCreator
        public GarbageCollectorInfo(@JsonProperty(value="name") String name, @JsonProperty(value="count") long count, @JsonProperty(value="time") long time) {
            this.name = Preconditions.checkNotNull(name);
            this.count = count;
            this.time = time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GarbageCollectorInfo that = (GarbageCollectorInfo)o;
            return this.count == that.count && this.time == that.time && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.count, this.time);
        }
    }
}

