/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.time.Duration;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.slotmanager.AnyMatchingSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.LeastUtilizationSlotMatchingStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotMatchingStrategy;
import org.apache.flink.util.ConfigurationException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlotManagerConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SlotManagerConfiguration.class);
    private final Time taskManagerRequestTimeout;
    private final Time slotRequestTimeout;
    private final Time taskManagerTimeout;
    private final Duration requirementCheckDelay;
    private final boolean waitResultConsumedBeforeRelease;
    private final SlotMatchingStrategy slotMatchingStrategy;
    private final WorkerResourceSpec defaultWorkerResourceSpec;
    private final int numSlotsPerWorker;
    private final int maxSlotNum;
    private final CPUResource maxTotalCpu;
    private final MemorySize maxTotalMem;
    private final int redundantTaskManagerNum;

    public SlotManagerConfiguration(Time taskManagerRequestTimeout, Time slotRequestTimeout, Time taskManagerTimeout, Duration requirementCheckDelay, boolean waitResultConsumedBeforeRelease, SlotMatchingStrategy slotMatchingStrategy, WorkerResourceSpec defaultWorkerResourceSpec, int numSlotsPerWorker, int maxSlotNum, CPUResource maxTotalCpu, MemorySize maxTotalMem, int redundantTaskManagerNum) {
        this.taskManagerRequestTimeout = Preconditions.checkNotNull(taskManagerRequestTimeout);
        this.slotRequestTimeout = Preconditions.checkNotNull(slotRequestTimeout);
        this.taskManagerTimeout = Preconditions.checkNotNull(taskManagerTimeout);
        this.requirementCheckDelay = Preconditions.checkNotNull(requirementCheckDelay);
        this.waitResultConsumedBeforeRelease = waitResultConsumedBeforeRelease;
        this.slotMatchingStrategy = Preconditions.checkNotNull(slotMatchingStrategy);
        this.defaultWorkerResourceSpec = Preconditions.checkNotNull(defaultWorkerResourceSpec);
        Preconditions.checkState(numSlotsPerWorker > 0);
        Preconditions.checkState(maxSlotNum > 0);
        this.numSlotsPerWorker = numSlotsPerWorker;
        this.maxSlotNum = maxSlotNum;
        this.maxTotalCpu = Preconditions.checkNotNull(maxTotalCpu);
        this.maxTotalMem = Preconditions.checkNotNull(maxTotalMem);
        Preconditions.checkState(redundantTaskManagerNum >= 0);
        this.redundantTaskManagerNum = redundantTaskManagerNum;
    }

    public Time getTaskManagerRequestTimeout() {
        return this.taskManagerRequestTimeout;
    }

    public Time getSlotRequestTimeout() {
        return this.slotRequestTimeout;
    }

    public Time getTaskManagerTimeout() {
        return this.taskManagerTimeout;
    }

    public Duration getRequirementCheckDelay() {
        return this.requirementCheckDelay;
    }

    public boolean isWaitResultConsumedBeforeRelease() {
        return this.waitResultConsumedBeforeRelease;
    }

    public SlotMatchingStrategy getSlotMatchingStrategy() {
        return this.slotMatchingStrategy;
    }

    public WorkerResourceSpec getDefaultWorkerResourceSpec() {
        return this.defaultWorkerResourceSpec;
    }

    public int getNumSlotsPerWorker() {
        return this.numSlotsPerWorker;
    }

    public int getMaxSlotNum() {
        return this.maxSlotNum;
    }

    public CPUResource getMaxTotalCpu() {
        return this.maxTotalCpu;
    }

    public MemorySize getMaxTotalMem() {
        return this.maxTotalMem;
    }

    public int getRedundantTaskManagerNum() {
        return this.redundantTaskManagerNum;
    }

    public static SlotManagerConfiguration fromConfiguration(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec) throws ConfigurationException {
        Time rpcTimeout = Time.fromDuration(configuration.get(AkkaOptions.ASK_TIMEOUT_DURATION));
        Time slotRequestTimeout = SlotManagerConfiguration.getSlotRequestTimeout(configuration);
        Time taskManagerTimeout = Time.milliseconds(configuration.getLong(ResourceManagerOptions.TASK_MANAGER_TIMEOUT));
        Duration requirementCheckDelay = configuration.get(ResourceManagerOptions.REQUIREMENTS_CHECK_DELAY);
        boolean waitResultConsumedBeforeRelease = configuration.getBoolean(ResourceManagerOptions.TASK_MANAGER_RELEASE_WHEN_RESULT_CONSUMED);
        boolean evenlySpreadOutSlots = configuration.getBoolean(ClusterOptions.EVENLY_SPREAD_OUT_SLOTS_STRATEGY);
        Enum slotMatchingStrategy = evenlySpreadOutSlots ? LeastUtilizationSlotMatchingStrategy.INSTANCE : AnyMatchingSlotMatchingStrategy.INSTANCE;
        int numSlotsPerWorker = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS);
        int maxSlotNum = configuration.getInteger(ResourceManagerOptions.MAX_SLOT_NUM);
        int redundantTaskManagerNum = configuration.getInteger(ResourceManagerOptions.REDUNDANT_TASK_MANAGER_NUM);
        return new SlotManagerConfiguration(rpcTimeout, slotRequestTimeout, taskManagerTimeout, requirementCheckDelay, waitResultConsumedBeforeRelease, (SlotMatchingStrategy)((Object)slotMatchingStrategy), defaultWorkerResourceSpec, numSlotsPerWorker, maxSlotNum, SlotManagerConfiguration.getMaxTotalCpu(configuration, defaultWorkerResourceSpec, maxSlotNum), SlotManagerConfiguration.getMaxTotalMem(configuration, defaultWorkerResourceSpec, maxSlotNum), redundantTaskManagerNum);
    }

    private static Time getSlotRequestTimeout(Configuration configuration) {
        long slotRequestTimeoutMs;
        if (configuration.contains(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT)) {
            LOGGER.warn("Config key {} is deprecated; use {} instead.", ResourceManagerOptions.SLOT_REQUEST_TIMEOUT, JobManagerOptions.SLOT_REQUEST_TIMEOUT);
            slotRequestTimeoutMs = configuration.getLong(ResourceManagerOptions.SLOT_REQUEST_TIMEOUT);
        } else {
            slotRequestTimeoutMs = configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT);
        }
        return Time.milliseconds(slotRequestTimeoutMs);
    }

    private static CPUResource getMaxTotalCpu(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec, int maxSlotNum) {
        return configuration.getOptional(ResourceManagerOptions.MAX_TOTAL_CPU).map(CPUResource::new).orElseGet(() -> maxSlotNum == Integer.MAX_VALUE ? new CPUResource(Double.MAX_VALUE) : (CPUResource)((CPUResource)defaultWorkerResourceSpec.getCpuCores().divide(defaultWorkerResourceSpec.getNumSlots())).multiply(maxSlotNum));
    }

    private static MemorySize getMaxTotalMem(Configuration configuration, WorkerResourceSpec defaultWorkerResourceSpec, int maxSlotNum) {
        return configuration.getOptional(ResourceManagerOptions.MAX_TOTAL_MEM).orElseGet(() -> maxSlotNum == Integer.MAX_VALUE ? MemorySize.MAX_VALUE : defaultWorkerResourceSpec.getTotalMemSize().divide(defaultWorkerResourceSpec.getNumSlots()).multiply(maxSlotNum));
    }
}

