/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.rest.handler.router.RoutedRequest;
import org.apache.flink.runtime.rest.handler.util.HandlerUtils;
import org.apache.flink.runtime.rest.messages.ErrorResponseBody;
import org.apache.flink.runtime.rest.messages.LogUrlResponse;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.shaded.netty4.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.Preconditions;

@ChannelHandler.Sharable
public class GeneratedLogUrlHandler
extends SimpleChannelInboundHandler<RoutedRequest<Object>> {
    private final CompletableFuture<String> patternFuture;

    public GeneratedLogUrlHandler(CompletableFuture<String> patternFuture) {
        this.patternFuture = patternFuture;
    }

    protected void channelRead0(ChannelHandlerContext ctx, RoutedRequest<Object> routedRequest) throws Exception {
        try {
            Map<String, String> pathParams = routedRequest.getRouteResult().pathParams();
            String taskManagerId = pathParams.get("taskmanagerid");
            String jobId = Preconditions.checkNotNull(pathParams.get("jobid"));
            LogUrlResponse response = new LogUrlResponse(GeneratedLogUrlHandler.generateLogUrl(this.patternFuture.get(5L, TimeUnit.MILLISECONDS), jobId, taskManagerId));
            HandlerUtils.sendResponse(ctx, routedRequest.getRequest(), response, HttpResponseStatus.OK, Collections.emptyMap());
        }
        catch (Exception e) {
            HandlerUtils.sendErrorResponse(ctx, routedRequest.getRequest(), new ErrorResponseBody(e.getMessage()), HttpResponseStatus.INTERNAL_SERVER_ERROR, Collections.emptyMap());
        }
    }

    @VisibleForTesting
    static String generateLogUrl(String pattern, String jobId, String taskManagerId) {
        String generatedUrl = pattern.replaceAll("<jobid>", jobId);
        if (null != taskManagerId) {
            generatedUrl = generatedUrl.replaceAll("<tmid>", taskManagerId);
        }
        return generatedUrl;
    }
}

