/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.security.modules;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.security.DynamicConfiguration;
import org.apache.flink.runtime.security.KerberosUtils;
import org.apache.flink.runtime.security.SecurityConfiguration;
import org.apache.flink.runtime.security.modules.SecurityModule;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class JaasModule
implements SecurityModule {
    private static final Logger LOG = LoggerFactory.getLogger(JaasModule.class);
    static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    static final String JAAS_CONF_RESOURCE_NAME = "flink-jaas.conf";
    private final SecurityConfiguration securityConfig;
    private String priorConfigFile;
    private Configuration priorConfig;
    private DynamicConfiguration currentConfig;
    private final String workingDir;

    public JaasModule(SecurityConfiguration securityConfig) {
        this.securityConfig = Preconditions.checkNotNull(securityConfig);
        String[] dirs = ConfigurationUtils.splitPaths(securityConfig.getFlinkConfig().getString(CoreOptions.TMP_DIRS));
        Preconditions.checkState(dirs.length > 0);
        this.workingDir = dirs[0];
    }

    @Override
    public void install() {
        this.priorConfigFile = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, null);
        if (this.priorConfigFile == null) {
            File configFile = JaasModule.generateDefaultConfigFile(this.workingDir);
            System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, configFile.getAbsolutePath());
            LOG.info("Jaas file will be created as {}.", (Object)configFile);
        }
        this.priorConfig = Configuration.getConfiguration();
        this.currentConfig = new DynamicConfiguration(this.priorConfig);
        AppConfigurationEntry[] krb5Entries = JaasModule.getAppConfigurationEntries(this.securityConfig);
        if (krb5Entries != null) {
            for (String app : this.securityConfig.getLoginContextNames()) {
                this.currentConfig.addAppConfigurationEntry(app, krb5Entries);
            }
        }
        Configuration.setConfiguration(this.currentConfig);
    }

    @Override
    public void uninstall() throws SecurityModule.SecurityInstallException {
        if (this.priorConfigFile != null) {
            System.setProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG, this.priorConfigFile);
        } else {
            System.clearProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
        }
        Configuration.setConfiguration(this.priorConfig);
    }

    public DynamicConfiguration getCurrentConfiguration() {
        return this.currentConfig;
    }

    public static AppConfigurationEntry[] getAppConfigurationEntries(SecurityConfiguration securityConfig) {
        AppConfigurationEntry[] appConfigurationEntry;
        AppConfigurationEntry userKerberosAce = null;
        if (securityConfig.useTicketCache()) {
            userKerberosAce = KerberosUtils.ticketCacheEntry();
        }
        AppConfigurationEntry keytabKerberosAce = null;
        if (securityConfig.getKeytab() != null) {
            keytabKerberosAce = KerberosUtils.keytabEntry(securityConfig.getKeytab(), securityConfig.getPrincipal());
        }
        if (userKerberosAce != null && keytabKerberosAce != null) {
            appConfigurationEntry = new AppConfigurationEntry[]{keytabKerberosAce, userKerberosAce};
        } else if (keytabKerberosAce != null) {
            appConfigurationEntry = new AppConfigurationEntry[]{keytabKerberosAce};
        } else if (userKerberosAce != null) {
            appConfigurationEntry = new AppConfigurationEntry[]{userKerberosAce};
        } else {
            return null;
        }
        return appConfigurationEntry;
    }

    private static File generateDefaultConfigFile(String workingDir) {
        File jaasConfFile;
        Preconditions.checkArgument(workingDir != null, "working directory should not be null.");
        try {
            Path path = Paths.get(workingDir, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                Path parent = path.getParent().toRealPath(new LinkOption[0]);
                Path resolvedPath = Paths.get(parent.toString(), path.getFileName().toString());
                path = Files.createDirectories(resolvedPath, new FileAttribute[0]);
            }
            Path jaasConfPath = Files.createTempFile(path, "jaas-", ".conf", new FileAttribute[0]);
            try (InputStream resourceStream = JaasModule.class.getClassLoader().getResourceAsStream(JAAS_CONF_RESOURCE_NAME);){
                Files.copy(resourceStream, jaasConfPath, StandardCopyOption.REPLACE_EXISTING);
            }
            jaasConfFile = new File(workingDir, jaasConfPath.getFileName().toString());
            jaasConfFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException("unable to generate a JAAS configuration file", e);
        }
        return jaasConfFile;
    }
}

