/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.CompiledPlan;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.PlanReference;
import org.apache.flink.table.api.ResultKind;
import org.apache.flink.table.api.SqlParserException;
import org.apache.flink.table.api.StatementSet;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.api.internal.AnalyzeTableUtil;
import org.apache.flink.table.api.internal.CompiledPlanImpl;
import org.apache.flink.table.api.internal.InsertResultProvider;
import org.apache.flink.table.api.internal.ResultProvider;
import org.apache.flink.table.api.internal.ShowCreateUtil;
import org.apache.flink.table.api.internal.StatementSetImpl;
import org.apache.flink.table.api.internal.StaticResultProvider;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.table.api.internal.TableResultImpl;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.CatalogTableImpl;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.QueryOperationCatalogView;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.DatabaseAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotEmptyException;
import org.apache.flink.table.catalog.exceptions.DatabaseNotExistException;
import org.apache.flink.table.catalog.exceptions.FunctionAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.exceptions.TableAlreadyExistException;
import org.apache.flink.table.catalog.exceptions.TableNotExistException;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.ExtendedOperationExecutor;
import org.apache.flink.table.delegation.InternalPlan;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.SqlLikeUtils;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.UserDefinedFunctionHelper;
import org.apache.flink.table.module.Module;
import org.apache.flink.table.module.ModuleEntry;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.CompileAndExecutePlanOperation;
import org.apache.flink.table.operations.CreateTableASOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.LoadModuleOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.NopOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowColumnsOperation;
import org.apache.flink.table.operations.ShowCreateTableOperation;
import org.apache.flink.table.operations.ShowCreateViewOperation;
import org.apache.flink.table.operations.ShowCurrentCatalogOperation;
import org.apache.flink.table.operations.ShowCurrentDatabaseOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowModulesOperation;
import org.apache.flink.table.operations.ShowPartitionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.ShowViewsOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.SourceQueryOperation;
import org.apache.flink.table.operations.StatementSetOperation;
import org.apache.flink.table.operations.TableSourceQueryOperation;
import org.apache.flink.table.operations.UnloadModuleOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.UseModulesOperation;
import org.apache.flink.table.operations.command.AddJarOperation;
import org.apache.flink.table.operations.command.ExecutePlanOperation;
import org.apache.flink.table.operations.command.ShowJarsOperation;
import org.apache.flink.table.operations.ddl.AddPartitionsOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterPartitionPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterTableAddConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableDropConstraintOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.operations.ddl.AlterTableOptionsOperation;
import org.apache.flink.table.operations.ddl.AlterTableRenameOperation;
import org.apache.flink.table.operations.ddl.AlterTableSchemaOperation;
import org.apache.flink.table.operations.ddl.AlterViewAsOperation;
import org.apache.flink.table.operations.ddl.AlterViewOperation;
import org.apache.flink.table.operations.ddl.AlterViewPropertiesOperation;
import org.apache.flink.table.operations.ddl.AlterViewRenameOperation;
import org.apache.flink.table.operations.ddl.AnalyzeTableOperation;
import org.apache.flink.table.operations.ddl.CompilePlanOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropCatalogOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropPartitionsOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.table.resource.ResourceType;
import org.apache.flink.table.resource.ResourceUri;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.table.utils.print.PrintStyle;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;
import org.apache.flink.util.Preconditions;

@Internal
public class TableEnvironmentImpl
implements TableEnvironmentInternal {
    private static final boolean IS_STREAM_TABLE = true;
    private final CatalogManager catalogManager;
    private final ModuleManager moduleManager;
    protected final ResourceManager resourceManager;
    private final OperationTreeBuilder operationTreeBuilder;
    protected final TableConfig tableConfig;
    protected final Executor execEnv;
    protected final FunctionCatalog functionCatalog;
    protected final Planner planner;
    private final boolean isStreamingMode;
    private static final String UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG = "Unsupported SQL query! executeSql() only accepts a single SQL statement of type CREATE TABLE, DROP TABLE, ALTER TABLE, CREATE DATABASE, DROP DATABASE, ALTER DATABASE, CREATE FUNCTION, DROP FUNCTION, ALTER FUNCTION, CREATE CATALOG, DROP CATALOG, USE CATALOG, USE [CATALOG.]DATABASE, SHOW CATALOGS, SHOW DATABASES, SHOW TABLES, SHOW [USER] FUNCTIONS, SHOW PARTITIONSCREATE VIEW, DROP VIEW, SHOW VIEWS, INSERT, DESCRIBE, LOAD MODULE, UNLOAD MODULE, USE MODULES, SHOW [FULL] MODULES.";
    private static final String UNSUPPORTED_QUERY_IN_COMPILE_PLAN_SQL_MSG = "Unsupported SQL query! compilePlanSql() only accepts a single SQL statement of type INSERT";

    protected TableEnvironmentImpl(CatalogManager catalogManager, ModuleManager moduleManager, ResourceManager resourceManager, TableConfig tableConfig, Executor executor, FunctionCatalog functionCatalog, Planner planner, boolean isStreamingMode) {
        this.catalogManager = catalogManager;
        this.moduleManager = moduleManager;
        this.resourceManager = resourceManager;
        this.execEnv = executor;
        this.tableConfig = tableConfig;
        this.functionCatalog = functionCatalog;
        this.planner = planner;
        this.isStreamingMode = isStreamingMode;
        this.operationTreeBuilder = OperationTreeBuilder.create(tableConfig, resourceManager.getUserClassLoader(), functionCatalog.asLookup(this.getParser()::parseIdentifier), catalogManager.getDataTypeFactory(), path -> {
            try {
                UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
                Optional<SourceQueryOperation> catalogQueryOperation = this.scanInternal(unresolvedIdentifier);
                return catalogQueryOperation.map(t -> ApiExpressionUtils.tableRef(path, t));
            }
            catch (SqlParserException ex) {
                return Optional.empty();
            }
        }, this.getParser()::parseSqlExpression, isStreamingMode);
        catalogManager.initSchemaResolver(isStreamingMode, this.operationTreeBuilder.getResolverBuilder(new QueryOperation[0]));
    }

    public static TableEnvironmentImpl create(Configuration configuration) {
        return TableEnvironmentImpl.create(EnvironmentSettings.newInstance().withConfiguration(configuration).build());
    }

    public static TableEnvironmentImpl create(EnvironmentSettings settings) {
        MutableURLClassLoader userClassLoader = FlinkUserCodeClassLoaders.create(new URL[0], settings.getUserClassLoader(), settings.getConfiguration());
        ExecutorFactory executorFactory = FactoryUtil.discoverFactory(userClassLoader, ExecutorFactory.class, "default");
        Executor executor = executorFactory.create(settings.getConfiguration());
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration(executor.getConfiguration());
        tableConfig.addConfiguration(settings.getConfiguration());
        ResourceManager resourceManager = new ResourceManager(settings.getConfiguration(), userClassLoader);
        ModuleManager moduleManager = new ModuleManager();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader(userClassLoader).config(tableConfig).defaultCatalog(settings.getBuiltInCatalogName(), new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).build();
        FunctionCatalog functionCatalog = new FunctionCatalog(tableConfig, resourceManager, catalogManager, moduleManager);
        Planner planner = PlannerFactoryUtil.createPlanner(executor, tableConfig, userClassLoader, moduleManager, catalogManager, functionCatalog);
        return new TableEnvironmentImpl(catalogManager, moduleManager, resourceManager, tableConfig, executor, functionCatalog, planner, settings.isStreamingMode());
    }

    @Override
    public Table fromValues(Object ... values) {
        return this.fromValues(Arrays.asList(values));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Object ... values) {
        return this.fromValues(rowType, Arrays.asList(values));
    }

    @Override
    public Table fromValues(Expression ... values) {
        return this.createTable(this.operationTreeBuilder.values(values));
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Expression ... values) {
        DataType resolvedDataType = this.catalogManager.getDataTypeFactory().createDataType(rowType);
        return this.createTable(this.operationTreeBuilder.values(resolvedDataType, values));
    }

    @Override
    public Table fromValues(Iterable<?> values) {
        Expression[] exprs = (Expression[])StreamSupport.stream(values.spliterator(), false).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new);
        return this.fromValues(exprs);
    }

    @Override
    public Table fromValues(AbstractDataType<?> rowType, Iterable<?> values) {
        Expression[] exprs = (Expression[])StreamSupport.stream(values.spliterator(), false).map(ApiExpressionUtils::objectToExpression).toArray(Expression[]::new);
        return this.fromValues(rowType, exprs);
    }

    @VisibleForTesting
    public Planner getPlanner() {
        return this.planner;
    }

    @Override
    public Table fromTableSource(TableSource<?> source) {
        return this.createTable(new TableSourceQueryOperation(source, false));
    }

    @Override
    public void registerCatalog(String catalogName, Catalog catalog) {
        this.catalogManager.registerCatalog(catalogName, catalog);
    }

    @Override
    public Optional<Catalog> getCatalog(String catalogName) {
        return this.catalogManager.getCatalog(catalogName);
    }

    @Override
    public void loadModule(String moduleName, Module module) {
        this.moduleManager.loadModule(moduleName, module);
    }

    @Override
    public void useModules(String ... moduleNames) {
        this.moduleManager.useModules(moduleNames);
    }

    @Override
    public void unloadModule(String moduleName) {
        this.moduleManager.unloadModule(moduleName);
    }

    @Override
    public void registerFunction(String name, ScalarFunction function) {
        this.functionCatalog.registerTempSystemScalarFunction(name, function);
    }

    @Override
    public void createTemporarySystemFunction(String name, Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        this.createTemporarySystemFunction(name, functionInstance);
    }

    @Override
    public void createTemporarySystemFunction(String name, UserDefinedFunction functionInstance) {
        this.functionCatalog.registerTemporarySystemFunction(name, functionInstance, false);
    }

    @Override
    public boolean dropTemporarySystemFunction(String name) {
        return this.functionCatalog.dropTemporarySystemFunction(name, true);
    }

    @Override
    public void createFunction(String path, Class<? extends UserDefinedFunction> functionClass) {
        this.createFunction(path, functionClass, false);
    }

    @Override
    public void createFunction(String path, Class<? extends UserDefinedFunction> functionClass, boolean ignoreIfExists) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        this.functionCatalog.registerCatalogFunction(unresolvedIdentifier, functionClass, ignoreIfExists);
    }

    @Override
    public boolean dropFunction(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        return this.functionCatalog.dropCatalogFunction(unresolvedIdentifier, true);
    }

    @Override
    public void createTemporaryFunction(String path, Class<? extends UserDefinedFunction> functionClass) {
        UserDefinedFunction functionInstance = UserDefinedFunctionHelper.instantiateFunction(functionClass);
        this.createTemporaryFunction(path, functionInstance);
    }

    @Override
    public void createTemporaryFunction(String path, UserDefinedFunction functionInstance) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        this.functionCatalog.registerTemporaryCatalogFunction(unresolvedIdentifier, functionInstance, false);
    }

    @Override
    public boolean dropTemporaryFunction(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        return this.functionCatalog.dropTemporaryCatalogFunction(unresolvedIdentifier, true);
    }

    private TableResultInternal addJar(AddJarOperation addJarOperation) {
        ResourceUri resourceUri = new ResourceUri(ResourceType.JAR, addJarOperation.getPath());
        try {
            this.resourceManager.registerJarResources(Collections.singletonList(resourceUri));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (IOException e) {
            throw new TableException(String.format("Could not register the specified resource [%s].", resourceUri), e);
        }
    }

    private String[] listJars() {
        return (String[])this.resourceManager.getResources().keySet().stream().map(ResourceUri::getUri).toArray(String[]::new);
    }

    @Override
    public void createTemporaryTable(String path, TableDescriptor descriptor) {
        Preconditions.checkNotNull(path, "Path must not be null.");
        Preconditions.checkNotNull(descriptor, "Table descriptor must not be null.");
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(this.getParser().parseIdentifier(path));
        this.catalogManager.createTemporaryTable(descriptor.toCatalogTable(), tableIdentifier, false);
    }

    @Override
    public void createTable(String path, TableDescriptor descriptor) {
        Preconditions.checkNotNull(path, "Path must not be null.");
        Preconditions.checkNotNull(descriptor, "Table descriptor must not be null.");
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(this.getParser().parseIdentifier(path));
        this.catalogManager.createTable(descriptor.toCatalogTable(), tableIdentifier, false);
    }

    @Override
    public void registerTable(String name, Table table) {
        UnresolvedIdentifier identifier = UnresolvedIdentifier.of(name);
        this.createTemporaryView(identifier, table);
    }

    @Override
    public void createTemporaryView(String path, Table view) {
        Preconditions.checkNotNull(path, "Path must not be null.");
        Preconditions.checkNotNull(view, "Table view must not be null.");
        UnresolvedIdentifier identifier = this.getParser().parseIdentifier(path);
        this.createTemporaryView(identifier, view);
    }

    private void createTemporaryView(UnresolvedIdentifier identifier, Table view) {
        if (((TableImpl)view).getTableEnvironment() != this) {
            throw new TableException("Only table API objects that belong to this TableEnvironment can be registered.");
        }
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        QueryOperation queryOperation = this.qualifyQueryOperation(tableIdentifier, view.getQueryOperation());
        QueryOperationCatalogView tableTable = new QueryOperationCatalogView(queryOperation);
        this.catalogManager.createTemporaryTable(tableTable, tableIdentifier, false);
    }

    @Override
    public Table scan(String ... tablePath) {
        UnresolvedIdentifier unresolvedIdentifier = UnresolvedIdentifier.of(tablePath);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public Table from(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        return this.scanInternal(unresolvedIdentifier).map(this::createTable).orElseThrow(() -> new ValidationException(String.format("Table %s was not found.", unresolvedIdentifier)));
    }

    @Override
    public Table from(TableDescriptor descriptor) {
        Preconditions.checkNotNull(descriptor, "Table descriptor must not be null.");
        ResolvedCatalogTable resolvedCatalogBaseTable = this.catalogManager.resolveCatalogTable(descriptor.toCatalogTable());
        SourceQueryOperation queryOperation = new SourceQueryOperation(ContextResolvedTable.anonymous(resolvedCatalogBaseTable));
        return this.createTable(queryOperation);
    }

    private Optional<SourceQueryOperation> scanInternal(UnresolvedIdentifier identifier) {
        ObjectIdentifier tableIdentifier = this.catalogManager.qualifyIdentifier(identifier);
        return this.catalogManager.getTable(tableIdentifier).map(SourceQueryOperation::new);
    }

    @Override
    public String[] listCatalogs() {
        return (String[])this.catalogManager.listCatalogs().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listModules() {
        return this.moduleManager.listModules().toArray(new String[0]);
    }

    @Override
    public ModuleEntry[] listFullModules() {
        return this.moduleManager.listFullModules().toArray(new ModuleEntry[0]);
    }

    @Override
    public String[] listDatabases() {
        return this.catalogManager.getCatalog(this.catalogManager.getCurrentCatalog()).get().listDatabases().toArray(new String[0]);
    }

    @Override
    public String[] listTables() {
        return (String[])this.catalogManager.listTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTables(String catalog, String databaseName) {
        return (String[])this.catalogManager.listTables(catalog, databaseName).stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listViews() {
        return (String[])this.catalogManager.listViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryTables() {
        return (String[])this.catalogManager.listTemporaryTables().stream().sorted().toArray(String[]::new);
    }

    @Override
    public String[] listTemporaryViews() {
        return (String[])this.catalogManager.listTemporaryViews().stream().sorted().toArray(String[]::new);
    }

    @Override
    public boolean dropTemporaryTable(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        try {
            this.catalogManager.dropTemporaryTable(identifier, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public boolean dropTemporaryView(String path) {
        UnresolvedIdentifier unresolvedIdentifier = this.getParser().parseIdentifier(path);
        ObjectIdentifier identifier = this.catalogManager.qualifyIdentifier(unresolvedIdentifier);
        try {
            this.catalogManager.dropTemporaryView(identifier, false);
            return true;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public String[] listUserDefinedFunctions() {
        Object[] functions = this.functionCatalog.getUserDefinedFunctions();
        Arrays.sort(functions);
        return functions;
    }

    @Override
    public String[] listFunctions() {
        Object[] functions = this.functionCatalog.getFunctions();
        Arrays.sort(functions);
        return functions;
    }

    @Override
    public String explainSql(String statement, ExplainDetail ... extraDetails) {
        List<Operation> operations = this.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException("Unsupported SQL query! explainSql() only accepts a single SQL query.");
        }
        if (operations.get(0) instanceof StatementSetOperation) {
            operations = new ArrayList<ModifyOperation>(((StatementSetOperation)operations.get(0)).getOperations());
        }
        return this.explainInternal(operations, extraDetails);
    }

    @Override
    public String explainInternal(List<Operation> operations, ExplainDetail ... extraDetails) {
        if ((operations = operations.stream().filter(o -> !(o instanceof NopOperation)).collect(Collectors.toList())).isEmpty()) {
            return "";
        }
        return this.planner.explain(operations, extraDetails);
    }

    @Override
    public String[] getCompletionHints(String statement, int position) {
        return this.planner.getParser().getCompletionHints(statement, position);
    }

    @Override
    public Table sqlQuery(String query) {
        List<Operation> operations = this.getParser().parse(query);
        if (operations.size() != 1) {
            throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query.");
        }
        Operation operation = operations.get(0);
        if (operation instanceof QueryOperation && !(operation instanceof ModifyOperation)) {
            return this.createTable((QueryOperation)operation);
        }
        throw new ValidationException("Unsupported SQL query! sqlQuery() only accepts a single SQL query of type SELECT, UNION, INTERSECT, EXCEPT, VALUES, and ORDER_BY.");
    }

    @Override
    public TableResult executeSql(String statement) {
        List<Operation> operations = this.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new TableException(UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG);
        }
        Operation operation = operations.get(0);
        return this.executeInternal(operation);
    }

    @Override
    public StatementSet createStatementSet() {
        return new StatementSetImpl<TableEnvironmentImpl>(this);
    }

    @Override
    public CompiledPlan loadPlan(PlanReference planReference) {
        try {
            return new CompiledPlanImpl(this, this.planner.loadPlan(planReference));
        }
        catch (IOException e) {
            throw new TableException(String.format("Cannot load %s.", planReference), e);
        }
    }

    @Override
    public CompiledPlan compilePlanSql(String stmt) {
        List<Operation> operations = this.getParser().parse(stmt);
        if (operations.size() != 1 || !(operations.get(0) instanceof ModifyOperation) || operations.get(0) instanceof CreateTableASOperation) {
            throw new TableException(UNSUPPORTED_QUERY_IN_COMPILE_PLAN_SQL_MSG);
        }
        return new CompiledPlanImpl(this, this.planner.compilePlan(Collections.singletonList((ModifyOperation)operations.get(0))));
    }

    @Override
    public TableResultInternal executePlan(InternalPlan plan) {
        List<Transformation<?>> transformations = this.planner.translatePlan(plan);
        List<String> sinkIdentifierNames = this.deduplicateSinkIdentifierNames(plan.getSinkIdentifiers());
        return this.executeInternal(transformations, sinkIdentifierNames);
    }

    private CompiledPlan compilePlanAndWrite(String filePath, boolean ifNotExists, Operation operation) {
        CompiledPlan compiledPlan;
        File file = Paths.get(filePath, new String[0]).toFile();
        if (file.exists()) {
            if (ifNotExists) {
                return this.loadPlan(PlanReference.fromFile(filePath));
            }
            if (!this.tableConfig.get(TableConfigOptions.PLAN_FORCE_RECOMPILE).booleanValue()) {
                throw new TableException(String.format("Cannot overwrite the plan file '%s'. Either manually remove the file or, if you're debugging your job, set the option '%s' to true.", filePath, TableConfigOptions.PLAN_FORCE_RECOMPILE.key()));
            }
        }
        if (operation instanceof StatementSetOperation) {
            compiledPlan = this.compilePlan(((StatementSetOperation)operation).getOperations());
        } else if (operation instanceof ModifyOperation) {
            compiledPlan = this.compilePlan(Collections.singletonList((ModifyOperation)operation));
        } else {
            throw new TableException("Unsupported operation to compile: " + operation.getClass() + ". This is a bug, please file an issue.");
        }
        compiledPlan.writeToFile(file, false);
        return compiledPlan;
    }

    @Override
    public CompiledPlan compilePlan(List<ModifyOperation> operations) {
        return new CompiledPlanImpl(this, this.planner.compilePlan(operations));
    }

    @Override
    public TableResultInternal executeInternal(List<ModifyOperation> operations) {
        ArrayList<ModifyOperation> mapOperations = new ArrayList<ModifyOperation>();
        for (ModifyOperation modify : operations) {
            if (modify instanceof CreateTableASOperation) {
                CreateTableASOperation ctasOperation = (CreateTableASOperation)modify;
                this.executeInternal(ctasOperation.getCreateTableOperation());
                mapOperations.add(ctasOperation.toSinkModifyOperation(this.catalogManager));
                continue;
            }
            mapOperations.add(modify);
        }
        List<Transformation<?>> transformations = this.translate(mapOperations);
        List<String> sinkIdentifierNames = this.extractSinkIdentifierNames(mapOperations);
        TableResultInternal result = this.executeInternal(transformations, sinkIdentifierNames);
        if (this.tableConfig.get(TableConfigOptions.TABLE_DML_SYNC).booleanValue()) {
            try {
                result.await();
            }
            catch (InterruptedException | ExecutionException e) {
                result.getJobClient().ifPresent(JobClient::cancel);
                throw new TableException("Fail to wait execution finish.", e);
            }
        }
        return result;
    }

    private TableResultInternal executeInternal(List<Transformation<?>> transformations, List<String> sinkIdentifierNames) {
        String defaultJobName = "insert-into_" + String.join((CharSequence)",", sinkIdentifierNames);
        this.resourceManager.addJarConfiguration(this.tableConfig);
        Pipeline pipeline = this.execEnv.createPipeline(transformations, this.tableConfig.getConfiguration(), defaultJobName);
        try {
            JobClient jobClient = this.execEnv.executeAsync(pipeline);
            ArrayList<Column> columns = new ArrayList<Column>();
            Long[] affectedRowCounts = new Long[transformations.size()];
            for (int i = 0; i < transformations.size(); ++i) {
                columns.add(Column.physical(sinkIdentifierNames.get(i), DataTypes.BIGINT()));
                affectedRowCounts[i] = -1L;
            }
            return TableResultImpl.builder().jobClient(jobClient).resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of(columns)).resultProvider(new InsertResultProvider(affectedRowCounts).setJobClient(jobClient)).build();
        }
        catch (Exception e) {
            throw new TableException("Failed to execute sql", e);
        }
    }

    private TableResultInternal executeQueryOperation(QueryOperation operation) {
        CollectModifyOperation sinkOperation = new CollectModifyOperation(operation);
        List<Transformation<?>> transformations = this.translate(Collections.singletonList(sinkOperation));
        String defaultJobName = "collect";
        this.resourceManager.addJarConfiguration(this.tableConfig);
        Pipeline pipeline = this.execEnv.createPipeline(transformations, this.tableConfig.getConfiguration(), "collect");
        try {
            JobClient jobClient = this.execEnv.executeAsync(pipeline);
            ResultProvider resultProvider = sinkOperation.getSelectResultProvider();
            resultProvider.setJobClient(jobClient);
            return TableResultImpl.builder().jobClient(jobClient).resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(operation.getResolvedSchema()).resultProvider(resultProvider).setPrintStyle(PrintStyle.tableauWithTypeInferredColumnWidths(DataTypeUtils.expandCompositeTypeToSchema(sinkOperation.getConsumedDataType()), resultProvider.getRowDataStringConverter(), 30, false, this.isStreamingMode)).build();
        }
        catch (Exception e) {
            throw new TableException("Failed to execute sql", e);
        }
    }

    @Override
    public TableResultInternal executeInternal(Operation operation) {
        Optional<TableResultInternal> tableResult = this.getExtendedOperationExecutor().executeOperation(operation);
        if (tableResult.isPresent()) {
            return tableResult.get();
        }
        if (operation instanceof ModifyOperation) {
            return this.executeInternal(Collections.singletonList((ModifyOperation)operation));
        }
        if (operation instanceof StatementSetOperation) {
            return this.executeInternal(((StatementSetOperation)operation).getOperations());
        }
        if (operation instanceof CreateTableOperation) {
            CreateTableOperation createTableOperation = (CreateTableOperation)operation;
            if (createTableOperation.isTemporary()) {
                this.catalogManager.createTemporaryTable(createTableOperation.getCatalogTable(), createTableOperation.getTableIdentifier(), createTableOperation.isIgnoreIfExists());
            } else {
                this.catalogManager.createTable(createTableOperation.getCatalogTable(), createTableOperation.getTableIdentifier(), createTableOperation.isIgnoreIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof DropTableOperation) {
            DropTableOperation dropTableOperation = (DropTableOperation)operation;
            if (dropTableOperation.isTemporary()) {
                this.catalogManager.dropTemporaryTable(dropTableOperation.getTableIdentifier(), dropTableOperation.isIfExists());
            } else {
                this.catalogManager.dropTable(dropTableOperation.getTableIdentifier(), dropTableOperation.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof AlterTableOperation) {
            AlterTableOperation alterTableOperation = (AlterTableOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterTableOperation.getTableIdentifier().getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterTableOperation.asSummaryString());
            try {
                if (alterTableOperation instanceof AlterTableRenameOperation) {
                    AlterTableRenameOperation alterTableRenameOp = (AlterTableRenameOperation)operation;
                    catalog.renameTable(alterTableRenameOp.getTableIdentifier().toObjectPath(), alterTableRenameOp.getNewTableIdentifier().getObjectName(), false);
                } else if (alterTableOperation instanceof AlterTableOptionsOperation) {
                    AlterTableOptionsOperation alterTablePropertiesOp = (AlterTableOptionsOperation)operation;
                    this.catalogManager.alterTable(alterTablePropertiesOp.getCatalogTable(), alterTablePropertiesOp.getTableIdentifier(), false);
                } else if (alterTableOperation instanceof AlterTableAddConstraintOperation) {
                    AlterTableAddConstraintOperation addConstraintOP = (AlterTableAddConstraintOperation)operation;
                    CatalogTable oriTable = (CatalogTable)this.catalogManager.getTable(addConstraintOP.getTableIdentifier()).get().getTable();
                    TableSchema.Builder builder = TableSchemaUtils.builderWithGivenSchema(oriTable.getSchema());
                    if (addConstraintOP.getConstraintName().isPresent()) {
                        builder.primaryKey(addConstraintOP.getConstraintName().get(), addConstraintOP.getColumnNames());
                    } else {
                        builder.primaryKey(addConstraintOP.getColumnNames());
                    }
                    CatalogTableImpl newTable = new CatalogTableImpl(builder.build(), oriTable.getPartitionKeys(), oriTable.getOptions(), oriTable.getComment());
                    this.catalogManager.alterTable(newTable, addConstraintOP.getTableIdentifier(), false);
                } else if (alterTableOperation instanceof AlterTableDropConstraintOperation) {
                    AlterTableDropConstraintOperation dropConstraintOperation = (AlterTableDropConstraintOperation)operation;
                    CatalogTable oriTable = (CatalogTable)this.catalogManager.getTable(dropConstraintOperation.getTableIdentifier()).get().getTable();
                    CatalogTableImpl newTable = new CatalogTableImpl(TableSchemaUtils.dropConstraint(oriTable.getSchema(), dropConstraintOperation.getConstraintName()), oriTable.getPartitionKeys(), oriTable.getOptions(), oriTable.getComment());
                    this.catalogManager.alterTable(newTable, dropConstraintOperation.getTableIdentifier(), false);
                } else if (alterTableOperation instanceof AlterPartitionPropertiesOperation) {
                    AlterPartitionPropertiesOperation alterPartPropsOp = (AlterPartitionPropertiesOperation)operation;
                    catalog.alterPartition(alterPartPropsOp.getTableIdentifier().toObjectPath(), alterPartPropsOp.getPartitionSpec(), alterPartPropsOp.getCatalogPartition(), false);
                } else if (alterTableOperation instanceof AlterTableSchemaOperation) {
                    AlterTableSchemaOperation alterTableSchemaOperation = (AlterTableSchemaOperation)alterTableOperation;
                    this.catalogManager.alterTable(alterTableSchemaOperation.getCatalogTable(), alterTableSchemaOperation.getTableIdentifier(), false);
                } else if (alterTableOperation instanceof AddPartitionsOperation) {
                    AddPartitionsOperation addPartitionsOperation = (AddPartitionsOperation)alterTableOperation;
                    List<CatalogPartitionSpec> specs = addPartitionsOperation.getPartitionSpecs();
                    List<CatalogPartition> partitions = addPartitionsOperation.getCatalogPartitions();
                    boolean ifNotExists = addPartitionsOperation.ifNotExists();
                    ObjectPath tablePath = addPartitionsOperation.getTableIdentifier().toObjectPath();
                    for (int i = 0; i < specs.size(); ++i) {
                        catalog.createPartition(tablePath, specs.get(i), partitions.get(i), ifNotExists);
                    }
                } else if (alterTableOperation instanceof DropPartitionsOperation) {
                    DropPartitionsOperation dropPartitionsOperation = (DropPartitionsOperation)alterTableOperation;
                    ObjectPath tablePath = dropPartitionsOperation.getTableIdentifier().toObjectPath();
                    boolean ifExists = dropPartitionsOperation.ifExists();
                    for (CatalogPartitionSpec spec : dropPartitionsOperation.getPartitionSpecs()) {
                        catalog.dropPartition(tablePath, spec, ifExists);
                    }
                }
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (TableAlreadyExistException | TableNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, e);
            }
        }
        if (operation instanceof CreateViewOperation) {
            CreateViewOperation createViewOperation = (CreateViewOperation)operation;
            if (createViewOperation.isTemporary()) {
                this.catalogManager.createTemporaryTable(createViewOperation.getCatalogView(), createViewOperation.getViewIdentifier(), createViewOperation.isIgnoreIfExists());
            } else {
                this.catalogManager.createTable(createViewOperation.getCatalogView(), createViewOperation.getViewIdentifier(), createViewOperation.isIgnoreIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof DropViewOperation) {
            DropViewOperation dropViewOperation = (DropViewOperation)operation;
            if (dropViewOperation.isTemporary()) {
                this.catalogManager.dropTemporaryView(dropViewOperation.getViewIdentifier(), dropViewOperation.isIfExists());
            } else {
                this.catalogManager.dropView(dropViewOperation.getViewIdentifier(), dropViewOperation.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof AlterViewOperation) {
            AlterViewOperation alterViewOperation = (AlterViewOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterViewOperation.getViewIdentifier().getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterViewOperation.asSummaryString());
            try {
                if (alterViewOperation instanceof AlterViewRenameOperation) {
                    AlterViewRenameOperation alterTableRenameOp = (AlterViewRenameOperation)operation;
                    catalog.renameTable(alterTableRenameOp.getViewIdentifier().toObjectPath(), alterTableRenameOp.getNewViewIdentifier().getObjectName(), false);
                } else if (alterViewOperation instanceof AlterViewPropertiesOperation) {
                    AlterViewPropertiesOperation alterTablePropertiesOp = (AlterViewPropertiesOperation)operation;
                    this.catalogManager.alterTable(alterTablePropertiesOp.getCatalogView(), alterTablePropertiesOp.getViewIdentifier(), false);
                } else if (alterViewOperation instanceof AlterViewAsOperation) {
                    AlterViewAsOperation alterViewAsOperation = (AlterViewAsOperation)alterViewOperation;
                    this.catalogManager.alterTable(alterViewAsOperation.getNewView(), alterViewAsOperation.getViewIdentifier(), false);
                }
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (TableAlreadyExistException | TableNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, e);
            }
        }
        if (operation instanceof CreateDatabaseOperation) {
            CreateDatabaseOperation createDatabaseOperation = (CreateDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(createDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(createDatabaseOperation.asSummaryString());
            try {
                catalog.createDatabase(createDatabaseOperation.getDatabaseName(), createDatabaseOperation.getCatalogDatabase(), createDatabaseOperation.isIgnoreIfExists());
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (DatabaseAlreadyExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, e);
            }
        }
        if (operation instanceof DropDatabaseOperation) {
            DropDatabaseOperation dropDatabaseOperation = (DropDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(dropDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(dropDatabaseOperation.asSummaryString());
            try {
                catalog.dropDatabase(dropDatabaseOperation.getDatabaseName(), dropDatabaseOperation.isIfExists(), dropDatabaseOperation.isCascade());
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (DatabaseNotEmptyException | DatabaseNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, e);
            }
        }
        if (operation instanceof AlterDatabaseOperation) {
            AlterDatabaseOperation alterDatabaseOperation = (AlterDatabaseOperation)operation;
            Catalog catalog = this.getCatalogOrThrowException(alterDatabaseOperation.getCatalogName());
            String exMsg = this.getDDLOpExecuteErrorMsg(alterDatabaseOperation.asSummaryString());
            try {
                catalog.alterDatabase(alterDatabaseOperation.getDatabaseName(), alterDatabaseOperation.getCatalogDatabase(), false);
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (DatabaseNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, e);
            }
        }
        if (operation instanceof CreateCatalogFunctionOperation) {
            return this.createCatalogFunction((CreateCatalogFunctionOperation)operation);
        }
        if (operation instanceof CreateTempSystemFunctionOperation) {
            return this.createSystemFunction((CreateTempSystemFunctionOperation)operation);
        }
        if (operation instanceof DropCatalogFunctionOperation) {
            return this.dropCatalogFunction((DropCatalogFunctionOperation)operation);
        }
        if (operation instanceof DropTempSystemFunctionOperation) {
            return this.dropSystemFunction((DropTempSystemFunctionOperation)operation);
        }
        if (operation instanceof AlterCatalogFunctionOperation) {
            return this.alterCatalogFunction((AlterCatalogFunctionOperation)operation);
        }
        if (operation instanceof AddJarOperation) {
            return this.addJar((AddJarOperation)operation);
        }
        if (operation instanceof ShowJarsOperation) {
            return this.buildShowResult("jars", this.listJars());
        }
        if (operation instanceof CreateCatalogOperation) {
            return this.createCatalog((CreateCatalogOperation)operation);
        }
        if (operation instanceof DropCatalogOperation) {
            DropCatalogOperation dropCatalogOperation = (DropCatalogOperation)operation;
            String exMsg = this.getDDLOpExecuteErrorMsg(dropCatalogOperation.asSummaryString());
            try {
                this.catalogManager.unregisterCatalog(dropCatalogOperation.getCatalogName(), dropCatalogOperation.isIfExists());
                return TableResultImpl.TABLE_RESULT_OK;
            }
            catch (CatalogException e) {
                throw new ValidationException(exMsg, e);
            }
        }
        if (operation instanceof LoadModuleOperation) {
            return this.loadModule((LoadModuleOperation)operation);
        }
        if (operation instanceof UnloadModuleOperation) {
            return this.unloadModule((UnloadModuleOperation)operation);
        }
        if (operation instanceof UseModulesOperation) {
            return this.useModules((UseModulesOperation)operation);
        }
        if (operation instanceof UseCatalogOperation) {
            UseCatalogOperation useCatalogOperation = (UseCatalogOperation)operation;
            this.catalogManager.setCurrentCatalog(useCatalogOperation.getCatalogName());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof UseDatabaseOperation) {
            UseDatabaseOperation useDatabaseOperation = (UseDatabaseOperation)operation;
            this.catalogManager.setCurrentCatalog(useDatabaseOperation.getCatalogName());
            this.catalogManager.setCurrentDatabase(useDatabaseOperation.getDatabaseName());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof ShowCatalogsOperation) {
            return this.buildShowResult("catalog name", this.listCatalogs());
        }
        if (operation instanceof ShowCreateTableOperation) {
            ShowCreateTableOperation showCreateTableOperation = (ShowCreateTableOperation)operation;
            ContextResolvedTable table = this.catalogManager.getTable(showCreateTableOperation.getTableIdentifier()).orElseThrow(() -> new ValidationException(String.format("Could not execute SHOW CREATE TABLE. Table with identifier %s does not exist.", showCreateTableOperation.getTableIdentifier().asSerializableString())));
            return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of(Column.physical("result", DataTypes.STRING()))).data(Collections.singletonList(Row.of(ShowCreateUtil.buildShowCreateTableRow(table.getResolvedTable(), showCreateTableOperation.getTableIdentifier(), table.isTemporary())))).build();
        }
        if (operation instanceof ShowCreateViewOperation) {
            ShowCreateViewOperation showCreateViewOperation = (ShowCreateViewOperation)operation;
            ContextResolvedTable table = this.catalogManager.getTable(showCreateViewOperation.getViewIdentifier()).orElseThrow(() -> new ValidationException(String.format("Could not execute SHOW CREATE VIEW. View with identifier %s does not exist.", showCreateViewOperation.getViewIdentifier().asSerializableString())));
            return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of(Column.physical("result", DataTypes.STRING()))).data(Collections.singletonList(Row.of(ShowCreateUtil.buildShowCreateViewRow(table.getResolvedTable(), showCreateViewOperation.getViewIdentifier(), table.isTemporary())))).build();
        }
        if (operation instanceof ShowCurrentCatalogOperation) {
            return this.buildShowResult("current catalog name", new String[]{this.catalogManager.getCurrentCatalog()});
        }
        if (operation instanceof ShowDatabasesOperation) {
            return this.buildShowResult("database name", this.listDatabases());
        }
        if (operation instanceof ShowCurrentDatabaseOperation) {
            return this.buildShowResult("current database name", new String[]{this.catalogManager.getCurrentDatabase()});
        }
        if (operation instanceof ShowModulesOperation) {
            ShowModulesOperation showModulesOperation = (ShowModulesOperation)operation;
            if (showModulesOperation.requireFull()) {
                return this.buildShowFullModulesResult(this.listFullModules());
            }
            return this.buildShowResult("module name", this.listModules());
        }
        if (operation instanceof ShowTablesOperation) {
            ShowTablesOperation showTablesOperation = (ShowTablesOperation)operation;
            if (showTablesOperation.getPreposition() == null) {
                return this.buildShowTablesResult(this.listTables(), showTablesOperation);
            }
            String catalogName = showTablesOperation.getCatalogName();
            String databaseName = showTablesOperation.getDatabaseName();
            Catalog catalog = this.getCatalogOrThrowException(catalogName);
            if (catalog.databaseExists(databaseName)) {
                return this.buildShowTablesResult(this.listTables(catalogName, databaseName), showTablesOperation);
            }
            throw new ValidationException(String.format("Database '%s'.'%s' doesn't exist.", catalogName, databaseName));
        }
        if (operation instanceof ShowFunctionsOperation) {
            ShowFunctionsOperation showFunctionsOperation = (ShowFunctionsOperation)operation;
            String[] functionNames = null;
            ShowFunctionsOperation.FunctionScope functionScope = showFunctionsOperation.getFunctionScope();
            switch (functionScope) {
                case USER: {
                    functionNames = this.listUserDefinedFunctions();
                    break;
                }
                case ALL: {
                    functionNames = this.listFunctions();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("SHOW FUNCTIONS with %s scope is not supported.", new Object[]{functionScope}));
                }
            }
            return this.buildShowResult("function name", functionNames);
        }
        if (operation instanceof ShowViewsOperation) {
            return this.buildShowResult("view name", this.listViews());
        }
        if (operation instanceof ShowColumnsOperation) {
            ShowColumnsOperation showColumnsOperation = (ShowColumnsOperation)operation;
            Optional<ContextResolvedTable> result = this.catalogManager.getTable(showColumnsOperation.getTableIdentifier());
            if (result.isPresent()) {
                return this.buildShowColumnsResult(result.get().getResolvedSchema(), showColumnsOperation);
            }
            throw new ValidationException(String.format("Tables or views with the identifier '%s' doesn't exist.", showColumnsOperation.getTableIdentifier().asSummaryString()));
        }
        if (operation instanceof ShowPartitionsOperation) {
            String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
            try {
                ShowPartitionsOperation showPartitionsOperation = (ShowPartitionsOperation)operation;
                Catalog catalog = this.getCatalogOrThrowException(showPartitionsOperation.getTableIdentifier().getCatalogName());
                ObjectPath tablePath = showPartitionsOperation.getTableIdentifier().toObjectPath();
                CatalogPartitionSpec partitionSpec = showPartitionsOperation.getPartitionSpec();
                List<CatalogPartitionSpec> partitionSpecs = partitionSpec == null ? catalog.listPartitions(tablePath) : catalog.listPartitions(tablePath, partitionSpec);
                ArrayList<String> partitionNames = new ArrayList<String>(partitionSpecs.size());
                for (CatalogPartitionSpec spec : partitionSpecs) {
                    ArrayList<String> partitionKVs = new ArrayList<String>(spec.getPartitionSpec().size());
                    for (Map.Entry<String, String> partitionKV : spec.getPartitionSpec().entrySet()) {
                        String partitionValue = partitionKV.getValue() == null ? showPartitionsOperation.getDefaultPartitionName() : partitionKV.getValue();
                        partitionKVs.add(partitionKV.getKey() + "=" + partitionValue);
                    }
                    partitionNames.add(String.join((CharSequence)"/", partitionKVs));
                }
                return this.buildShowResult("partition name", partitionNames.toArray(new String[0]));
            }
            catch (TableNotExistException e) {
                throw new ValidationException(exMsg, e);
            }
            catch (Exception e) {
                throw new TableException(exMsg, e);
            }
        }
        if (operation instanceof ExplainOperation) {
            ExplainOperation explainOperation = (ExplainOperation)operation;
            ExplainDetail[] explainDetails = (ExplainDetail[])explainOperation.getExplainDetails().stream().map(ExplainDetail::valueOf).toArray(ExplainDetail[]::new);
            Operation child = ((ExplainOperation)operation).getChild();
            List<Operation> operations = child instanceof StatementSetOperation ? new ArrayList<ModifyOperation>(((StatementSetOperation)child).getOperations()) : Collections.singletonList(child);
            String explanation = this.explainInternal(operations, explainDetails);
            return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.of(Column.physical("result", DataTypes.STRING()))).data(Collections.singletonList(Row.of(explanation))).build();
        }
        if (operation instanceof DescribeTableOperation) {
            DescribeTableOperation describeTableOperation = (DescribeTableOperation)operation;
            Optional<ContextResolvedTable> result = this.catalogManager.getTable(describeTableOperation.getSqlIdentifier());
            if (result.isPresent()) {
                return this.buildDescribeResult(result.get().getResolvedSchema());
            }
            throw new ValidationException(String.format("Tables or views with the identifier '%s' doesn't exist", describeTableOperation.getSqlIdentifier().asSummaryString()));
        }
        if (operation instanceof QueryOperation) {
            return this.executeQueryOperation((QueryOperation)operation);
        }
        if (operation instanceof ExecutePlanOperation) {
            ExecutePlanOperation executePlanOperation = (ExecutePlanOperation)operation;
            return (TableResultInternal)this.executePlan(PlanReference.fromFile(executePlanOperation.getFilePath()));
        }
        if (operation instanceof CompilePlanOperation) {
            CompilePlanOperation compilePlanOperation = (CompilePlanOperation)operation;
            this.compilePlanAndWrite(compilePlanOperation.getFilePath(), compilePlanOperation.isIfNotExists(), compilePlanOperation.getOperation());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        if (operation instanceof CompileAndExecutePlanOperation) {
            CompileAndExecutePlanOperation compileAndExecutePlanOperation = (CompileAndExecutePlanOperation)operation;
            CompiledPlan compiledPlan = this.compilePlanAndWrite(compileAndExecutePlanOperation.getFilePath(), true, compileAndExecutePlanOperation.getOperation());
            return (TableResultInternal)compiledPlan.execute();
        }
        if (operation instanceof AnalyzeTableOperation) {
            if (this.isStreamingMode) {
                throw new TableException("ANALYZE TABLE is not supported for streaming mode now");
            }
            try {
                return AnalyzeTableUtil.analyzeTable(this, (AnalyzeTableOperation)operation);
            }
            catch (Exception e) {
                throw new TableException("Failed to execute ANALYZE TABLE command", e);
            }
        }
        if (operation instanceof NopOperation) {
            return TableResultImpl.TABLE_RESULT_OK;
        }
        throw new TableException(UNSUPPORTED_QUERY_IN_EXECUTE_SQL_MSG);
    }

    private TableResultInternal createCatalog(CreateCatalogOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            String catalogName = operation.getCatalogName();
            Map<String, String> properties = operation.getProperties();
            Catalog catalog = FactoryUtil.createCatalog(catalogName, properties, this.tableConfig, this.resourceManager.getUserClassLoader());
            this.catalogManager.registerCatalog(catalogName, catalog);
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (CatalogException e) {
            throw new ValidationException(exMsg, e);
        }
    }

    private TableResultInternal loadModule(LoadModuleOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            Module module = FactoryUtil.createModule(operation.getModuleName(), operation.getOptions(), this.tableConfig, this.resourceManager.getUserClassLoader());
            this.moduleManager.loadModule(operation.getModuleName(), module);
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("%s. %s", exMsg, e.getMessage()), e);
        }
        catch (Exception e) {
            throw new TableException(String.format("%s. %s", exMsg, e.getMessage()), e);
        }
    }

    private TableResultInternal unloadModule(UnloadModuleOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            this.moduleManager.unloadModule(operation.getModuleName());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("%s. %s", exMsg, e.getMessage()), e);
        }
    }

    private TableResultInternal useModules(UseModulesOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            this.moduleManager.useModules(operation.getModuleNames().toArray(new String[0]));
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw new ValidationException(String.format("%s. %s", exMsg, e.getMessage()), e);
        }
    }

    /*
     * Exception decompiling
     */
    private TableResultInternal buildShowResult(String columnName, String[] objects) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private TableResultInternal buildDescribeResult(ResolvedSchema schema) {
        Object[][] rows = this.buildTableColumns(schema);
        return this.buildResult(this.generateTableColumnsNames(), this.generateTableColumnsDataTypes(), rows);
    }

    private DataType[] generateTableColumnsDataTypes() {
        return new DataType[]{DataTypes.STRING(), DataTypes.STRING(), DataTypes.BOOLEAN(), DataTypes.STRING(), DataTypes.STRING(), DataTypes.STRING()};
    }

    private String[] generateTableColumnsNames() {
        return new String[]{"name", "type", "null", "key", "extras", "watermark"};
    }

    private TableResultInternal buildShowTablesResult(String[] tableList, ShowTablesOperation showTablesOp) {
        String[] rows = (String[])tableList.clone();
        if (showTablesOp.isUseLike()) {
            rows = (String[])Arrays.stream(tableList).filter(row -> showTablesOp.isNotLike() != SqlLikeUtils.like(row, showTablesOp.getLikePattern(), "\\")).toArray(String[]::new);
        }
        return this.buildShowResult("table name", rows);
    }

    private TableResultInternal buildShowColumnsResult(ResolvedSchema schema, ShowColumnsOperation showColumnsOp) {
        Object[][] rows = this.buildTableColumns(schema);
        if (showColumnsOp.isUseLike()) {
            rows = (Object[][])Arrays.stream(rows).filter(row -> showColumnsOp.isNotLike() != SqlLikeUtils.like(row[0].toString(), showColumnsOp.getLikePattern(), "\\")).toArray(x$0 -> new Object[x$0][]);
        }
        return this.buildResult(this.generateTableColumnsNames(), this.generateTableColumnsDataTypes(), rows);
    }

    /*
     * Exception decompiling
     */
    private TableResultInternal buildShowFullModulesResult(ModuleEntry[] moduleEntries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object[][] buildTableColumns(ResolvedSchema schema) {
        Map<String, String> fieldToWatermark = schema.getWatermarkSpecs().stream().collect(Collectors.toMap(WatermarkSpec::getRowtimeAttribute, spec -> spec.getWatermarkExpression().asSummaryString()));
        HashMap fieldToPrimaryKey = new HashMap();
        schema.getPrimaryKey().ifPresent(p -> {
            List<String> columns = p.getColumns();
            columns.forEach(c -> fieldToPrimaryKey.put(c, String.format("PRI(%s)", String.join((CharSequence)", ", columns))));
        });
        return (Object[][])schema.getColumns().stream().map(c -> {
            LogicalType logicalType = c.getDataType().getLogicalType();
            return new Object[]{c.getName(), logicalType.copy(true).asSummaryString(), logicalType.isNullable(), fieldToPrimaryKey.getOrDefault(c.getName(), null), c.explainExtras().orElse(null), fieldToWatermark.getOrDefault(c.getName(), null)};
        }).toArray(x$0 -> new Object[x$0][]);
    }

    private TableResultInternal buildResult(String[] headers, DataType[] types, Object[][] rows) {
        ResolvedSchema schema = ResolvedSchema.physical(headers, types);
        StaticResultProvider provider = new StaticResultProvider(Arrays.stream(rows).map(Row::of).collect(Collectors.toList()));
        return TableResultImpl.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).schema(ResolvedSchema.physical(headers, types)).resultProvider(provider).setPrintStyle(PrintStyle.tableauWithDataInferredColumnWidths(schema, provider.getRowDataStringConverter(), Integer.MAX_VALUE, true, false)).build();
    }

    private List<String> extractSinkIdentifierNames(List<ModifyOperation> operations) {
        ArrayList<String> tableNames = new ArrayList<String>(operations.size());
        for (ModifyOperation operation : operations) {
            if (operation instanceof SinkModifyOperation) {
                String fullName = ((SinkModifyOperation)operation).getContextResolvedTable().getIdentifier().asSummaryString();
                tableNames.add(fullName);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported operation: " + operation);
        }
        return this.deduplicateSinkIdentifierNames(tableNames);
    }

    private List<String> deduplicateSinkIdentifierNames(List<String> tableNames) {
        HashMap<String, Integer> tableNameToCount = new HashMap<String, Integer>();
        for (String fullName : tableNames) {
            tableNameToCount.put(fullName, tableNameToCount.getOrDefault(fullName, 0) + 1);
        }
        HashMap tableNameToIndex = new HashMap();
        return tableNames.stream().map(tableName -> {
            if ((Integer)tableNameToCount.get(tableName) == 1) {
                return tableName;
            }
            Integer index = tableNameToIndex.getOrDefault(tableName, 0) + 1;
            tableNameToIndex.put(tableName, index);
            return tableName + "_" + index;
        }).collect(Collectors.toList());
    }

    private Catalog getCatalogOrThrowException(String catalogName) {
        return this.getCatalog(catalogName).orElseThrow(() -> new ValidationException(String.format("Catalog %s does not exist", catalogName)));
    }

    private String getDDLOpExecuteErrorMsg(String action) {
        return String.format("Could not execute %s", action);
    }

    @Override
    public String getCurrentCatalog() {
        return this.catalogManager.getCurrentCatalog();
    }

    @Override
    public void useCatalog(String catalogName) {
        this.catalogManager.setCurrentCatalog(catalogName);
    }

    @Override
    public String getCurrentDatabase() {
        return this.catalogManager.getCurrentDatabase();
    }

    @Override
    public void useDatabase(String databaseName) {
        this.catalogManager.setCurrentDatabase(databaseName);
    }

    @Override
    public TableConfig getConfig() {
        return this.tableConfig;
    }

    @Override
    public Parser getParser() {
        return this.getPlanner().getParser();
    }

    public ExtendedOperationExecutor getExtendedOperationExecutor() {
        return this.getPlanner().getExtendedOperationExecutor();
    }

    @Override
    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    @Override
    public OperationTreeBuilder getOperationTreeBuilder() {
        return this.operationTreeBuilder;
    }

    protected QueryOperation qualifyQueryOperation(ObjectIdentifier identifier, QueryOperation queryOperation) {
        return queryOperation;
    }

    protected void validateTableSource(TableSource<?> tableSource) {
        TableSourceValidation.validateTableSource(tableSource, tableSource.getTableSchema());
    }

    protected List<Transformation<?>> translate(List<ModifyOperation> modifyOperations) {
        return this.planner.translate(modifyOperations);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerTableSourceInternal(String name, TableSource<?> tableSource) {
        this.validateTableSource(tableSource);
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of(name));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSource().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(tableSource, sourceSinkTable.getTableSink().get(), false);
            this.catalogManager.dropTemporaryTable(objectIdentifier, false);
            this.catalogManager.createTemporaryTable(sourceAndSink, objectIdentifier, false);
            return;
        } else {
            ConnectorCatalogTable<?, ?> source = ConnectorCatalogTable.source(tableSource, false);
            this.catalogManager.createTemporaryTable(source, objectIdentifier, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerTableSinkInternal(String name, TableSink<?> tableSink) {
        ObjectIdentifier objectIdentifier = this.catalogManager.qualifyIdentifier(UnresolvedIdentifier.of(name));
        Optional<CatalogBaseTable> table = this.getTemporaryTable(objectIdentifier);
        if (table.isPresent()) {
            if (!(table.get() instanceof ConnectorCatalogTable)) throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            ConnectorCatalogTable sourceSinkTable = (ConnectorCatalogTable)table.get();
            if (sourceSinkTable.getTableSink().isPresent()) {
                throw new ValidationException(String.format("Table '%s' already exists. Please choose a different name.", name));
            }
            ConnectorCatalogTable sourceAndSink = ConnectorCatalogTable.sourceAndSink(sourceSinkTable.getTableSource().get(), tableSink, false);
            this.catalogManager.dropTemporaryTable(objectIdentifier, false);
            this.catalogManager.createTemporaryTable(sourceAndSink, objectIdentifier, false);
            return;
        } else {
            ConnectorCatalogTable<?, ?> sink = ConnectorCatalogTable.sink(tableSink, false);
            this.catalogManager.createTemporaryTable(sink, objectIdentifier, false);
        }
    }

    private Optional<CatalogBaseTable> getTemporaryTable(ObjectIdentifier identifier) {
        return this.catalogManager.getTable(identifier).filter(ContextResolvedTable::isTemporary).map(ContextResolvedTable::getTable);
    }

    private TableResultInternal createCatalogFunction(CreateCatalogFunctionOperation createCatalogFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(createCatalogFunctionOperation.asSummaryString());
        try {
            if (createCatalogFunctionOperation.isTemporary()) {
                this.functionCatalog.registerTemporaryCatalogFunction(UnresolvedIdentifier.of(createCatalogFunctionOperation.getFunctionIdentifier().toList()), createCatalogFunctionOperation.getCatalogFunction(), createCatalogFunctionOperation.isIgnoreIfExists());
            } else {
                Catalog catalog = this.getCatalogOrThrowException(createCatalogFunctionOperation.getFunctionIdentifier().getCatalogName());
                catalog.createFunction(createCatalogFunctionOperation.getFunctionIdentifier().toObjectPath(), createCatalogFunctionOperation.getCatalogFunction(), createCatalogFunctionOperation.isIgnoreIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionAlreadyExistException e) {
            throw new ValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, e);
        }
    }

    private TableResultInternal alterCatalogFunction(AlterCatalogFunctionOperation alterCatalogFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(alterCatalogFunctionOperation.asSummaryString());
        try {
            CatalogFunction function = alterCatalogFunctionOperation.getCatalogFunction();
            if (alterCatalogFunctionOperation.isTemporary()) {
                throw new ValidationException("Alter temporary catalog function is not supported");
            }
            Catalog catalog = this.getCatalogOrThrowException(alterCatalogFunctionOperation.getFunctionIdentifier().getCatalogName());
            catalog.alterFunction(alterCatalogFunctionOperation.getFunctionIdentifier().toObjectPath(), function, alterCatalogFunctionOperation.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, e);
        }
    }

    private TableResultInternal dropCatalogFunction(DropCatalogFunctionOperation dropCatalogFunctionOperation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(dropCatalogFunctionOperation.asSummaryString());
        try {
            if (dropCatalogFunctionOperation.isTemporary()) {
                this.functionCatalog.dropTempCatalogFunction(dropCatalogFunctionOperation.getFunctionIdentifier(), dropCatalogFunctionOperation.isIfExists());
            } else {
                Catalog catalog = this.getCatalogOrThrowException(dropCatalogFunctionOperation.getFunctionIdentifier().getCatalogName());
                catalog.dropFunction(dropCatalogFunctionOperation.getFunctionIdentifier().toObjectPath(), dropCatalogFunctionOperation.isIfExists());
            }
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (FunctionNotExistException e) {
            throw new ValidationException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new TableException(exMsg, e);
        }
    }

    private TableResultInternal createSystemFunction(CreateTempSystemFunctionOperation operation) {
        String exMsg = this.getDDLOpExecuteErrorMsg(operation.asSummaryString());
        try {
            this.functionCatalog.registerTemporarySystemFunction(operation.getFunctionName(), operation.getCatalogFunction(), operation.isIgnoreIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(exMsg, e);
        }
    }

    private TableResultInternal dropSystemFunction(DropTempSystemFunctionOperation operation) {
        try {
            this.functionCatalog.dropTemporarySystemFunction(operation.getFunctionName(), operation.isIfExists());
            return TableResultImpl.TABLE_RESULT_OK;
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TableException(this.getDDLOpExecuteErrorMsg(operation.asSummaryString()), e);
        }
    }

    @VisibleForTesting
    public TableImpl createTable(QueryOperation tableOperation) {
        return TableImpl.createTable(this, tableOperation, this.operationTreeBuilder, this.functionCatalog.asLookup(this.getParser()::parseIdentifier));
    }

    @Override
    public String explainPlan(InternalPlan compiledPlan, ExplainDetail ... extraDetails) {
        return this.planner.explainPlan(compiledPlan, extraDetails);
    }

    private static /* synthetic */ Object[][] lambda$buildShowFullModulesResult$24(int x$0) {
        return new Object[x$0][];
    }

    private static /* synthetic */ String[][] lambda$buildShowResult$18(int x$0) {
        return new String[x$0][];
    }
}

