/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.sink;

import java.util.stream.IntStream;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.codegen.CodeGenUtils;
import org.apache.flink.table.store.codegen.Projection;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;

public class BucketComputer {
    private final int numBucket;
    private final Projection rowProjection;
    private final Projection bucketProjection;
    private final Projection pkProjection;

    public BucketComputer(TableSchema tableSchema) {
        this(new CoreOptions(tableSchema.options()).bucket(), tableSchema.logicalRowType(), tableSchema.projection(tableSchema.originalBucketKeys()), tableSchema.projection(tableSchema.trimmedPrimaryKeys()));
    }

    private BucketComputer(int numBucket, RowType rowType, int[] bucketKeys, int[] primaryKeys) {
        this.numBucket = numBucket;
        this.rowProjection = CodeGenUtils.newProjection(rowType, IntStream.range(0, rowType.getFieldCount()).toArray());
        this.bucketProjection = CodeGenUtils.newProjection(rowType, bucketKeys);
        this.pkProjection = CodeGenUtils.newProjection(rowType, primaryKeys);
    }

    private int hashRow(RowData row) {
        if (row instanceof BinaryRowData) {
            RowKind rowKind = row.getRowKind();
            row.setRowKind(RowKind.INSERT);
            int hash = BucketComputer.hashcode((BinaryRowData)row);
            row.setRowKind(rowKind);
            return hash;
        }
        return BucketComputer.hashcode(this.rowProjection.apply(row));
    }

    public int bucket(RowData row) {
        int hashcode = this.hashBucketKey(row);
        return BucketComputer.bucket(hashcode, this.numBucket);
    }

    public int bucket(RowData row, BinaryRowData pk) {
        int hashcode = this.hashBucketKey(row, pk);
        return BucketComputer.bucket(hashcode, this.numBucket);
    }

    private int hashBucketKey(RowData row) {
        BinaryRowData bucketKey = this.bucketProjection.apply(row);
        if (bucketKey.getArity() == 0) {
            bucketKey = this.pkProjection.apply(row);
        }
        if (bucketKey.getArity() == 0) {
            return this.hashRow(row);
        }
        return bucketKey.hashCode();
    }

    private int hashBucketKey(RowData row, BinaryRowData pk) {
        BinaryRowData bucketKey = this.bucketProjection.apply(row);
        if (bucketKey.getArity() == 0) {
            bucketKey = pk;
        }
        if (bucketKey.getArity() == 0) {
            return this.hashRow(row);
        }
        return bucketKey.hashCode();
    }

    public static int hashcode(BinaryRowData rowData) {
        assert (rowData.getRowKind() == RowKind.INSERT);
        return rowData.hashCode();
    }

    public static int bucket(int hashcode, int numBucket) {
        return Math.abs(hashcode % numBucket);
    }
}

