/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal.index;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.query.AmbiguousNameException;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.IndexStatistics;
import org.apache.geode.cache.query.IndexType;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.CompiledIteratorDef;
import org.apache.geode.cache.query.internal.CompiledPath;
import org.apache.geode.cache.query.internal.CompiledSortCriterion;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.DefaultQuery;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.IndexInfo;
import org.apache.geode.cache.query.internal.QRegion;
import org.apache.geode.cache.query.internal.QueryMonitor;
import org.apache.geode.cache.query.internal.QueryObserver;
import org.apache.geode.cache.query.internal.QueryObserverHolder;
import org.apache.geode.cache.query.internal.QueryUtils;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.cache.query.internal.index.AbstractIndex;
import org.apache.geode.cache.query.internal.index.CompactRangeIndex;
import org.apache.geode.cache.query.internal.index.DummyQRegion;
import org.apache.geode.cache.query.internal.index.FunctionalIndexCreationHelper;
import org.apache.geode.cache.query.internal.index.HashIndexSet;
import org.apache.geode.cache.query.internal.index.IMQException;
import org.apache.geode.cache.query.internal.index.IndexCreationHelper;
import org.apache.geode.cache.query.internal.index.IndexManager;
import org.apache.geode.cache.query.internal.index.IndexProtocol;
import org.apache.geode.cache.query.internal.index.IndexStats;
import org.apache.geode.cache.query.internal.index.IndexStore;
import org.apache.geode.cache.query.internal.index.IndexedExpressionEvaluator;
import org.apache.geode.cache.query.internal.index.RangeIndex;
import org.apache.geode.cache.query.internal.types.StructTypeImpl;
import org.apache.geode.cache.query.internal.types.TypeUtils;
import org.apache.geode.cache.query.types.ObjectType;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.persistence.query.CloseableIterator;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Deprecated
public class HashIndex
extends AbstractIndex {
    private static final Logger logger = LogService.getLogger();
    protected ThreadLocal<Object2ObjectOpenHashMap> entryToOldKeysMap;
    final HashIndexSet entriesSet;
    private ConcurrentMap<Object, Object> entryToValuesMap = null;
    private boolean indexOnRegionKeys = false;
    private boolean indexOnValues = false;
    private IMQEvaluator.HashIndexComparator comparator;

    public HashIndex(InternalCache cache, String indexName, Region region, String fromClause, String indexedExpression, String projectionAttributes, String origFromClause, String origIndexExpr, String[] definitions, IndexStatistics stats) {
        super(cache, indexName, region, fromClause, indexedExpression, projectionAttributes, origFromClause, origIndexExpr, definitions, stats);
        RegionAttributes ra = region.getAttributes();
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap = new ConcurrentHashMap<Object, Object>(ra.getInitialCapacity(), ra.getLoadFactor(), ra.getConcurrencyLevel());
        } else if (this.entryToOldKeysMap == null) {
            this.entryToOldKeysMap = new ThreadLocal();
        }
        this.entriesSet = new HashIndexSet();
    }

    @Override
    public IndexType getType() {
        return IndexType.HASH;
    }

    @Override
    protected boolean isCompactRangeIndex() {
        return false;
    }

    @Override
    public void initializeIndex(boolean loadEntries) throws IMQException {
        long startTime = System.nanoTime();
        this.evaluator.initializeIndex(loadEntries);
        this.internalIndexStats.incNumUpdates(((IMQEvaluator)this.evaluator).getTotalEntriesUpdated());
        long endTime = System.nanoTime();
        this.internalIndexStats.incUpdateTime(endTime - startTime);
    }

    @Override
    void addMapping(RegionEntry entry) throws IMQException {
        this.evaluator.evaluate(entry, true);
        this.internalIndexStats.incNumUpdates();
    }

    private void basicAddMapping(Object key, RegionEntry entry) throws IMQException {
        try {
            Object targetObject;
            Object newKey;
            if (DefaultQuery.testHook != null) {
                DefaultQuery.testHook.doTestHook(DefaultQuery.TestHook.SPOTS.BEFORE_ADD_OR_UPDATE_MAPPING_OR_DESERIALIZING_NTH_STREAMINGOPERATION, null, null);
            }
            if ((newKey = TypeUtils.indexKeyFor(key)).equals(QueryService.UNDEFINED) && Token.isInvalidOrRemoved(targetObject = this.getTargetObjectForUpdate(entry))) {
                Map oldKeyMap;
                Object oldKey = null;
                if (IndexManager.isObjectModificationInplace() && this.entryToValuesMap.containsKey(entry)) {
                    oldKey = this.entryToValuesMap.get(entry);
                } else if (!IndexManager.isObjectModificationInplace() && this.entryToOldKeysMap != null && (oldKeyMap = (Map)this.entryToOldKeysMap.get()) != null) {
                    oldKey = TypeUtils.indexKeyFor(oldKeyMap.get(entry));
                }
                if (oldKey != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("A removed or invalid token was being added, and we had an old mapping.");
                    }
                    this.removeFromEntriesSet(oldKey, entry, true);
                }
                return;
            }
            Object oldKey = this.getOldKey(entry);
            int indexSlot = this.entriesSet.add(newKey, entry);
            if (indexSlot >= 0) {
                if (IndexManager.isObjectModificationInplace()) {
                    this.entryToValuesMap.put(entry, newKey);
                }
                if (newKey != null && oldKey != null) {
                    this.removeFromEntriesSet(oldKey, entry, false, indexSlot);
                }
                this.internalIndexStats.incNumValues(1);
            }
        }
        catch (TypeMismatchException ex) {
            throw new IMQException("Could not add object of type " + key.getClass().getName(), ex);
        }
    }

    private Object getOldKey(RegionEntry entry) throws TypeMismatchException {
        Map oldKeyMap;
        Object oldKey = null;
        if (IndexManager.isObjectModificationInplace() && this.entryToValuesMap.containsKey(entry)) {
            oldKey = this.entryToValuesMap.get(entry);
        } else if (!IndexManager.isObjectModificationInplace() && this.entryToOldKeysMap != null && (oldKeyMap = (Map)this.entryToOldKeysMap.get()) != null) {
            oldKey = TypeUtils.indexKeyFor(oldKeyMap.get(entry));
        }
        return oldKey;
    }

    @Override
    void removeMapping(RegionEntry entry, int opCode) throws IMQException {
        if (opCode == 1) {
            if (!IndexManager.isObjectModificationInplace()) {
                this.entryToOldKeysMap.set(new Object2ObjectOpenHashMap(1));
                this.evaluator.evaluate(entry, false);
            }
        } else if (opCode == 3) {
            if (this.entryToOldKeysMap != null) {
                this.basicRemoveMapping(this.entryToOldKeysMap.get().get((Object)entry), entry, true);
            }
        } else if (opCode == 4) {
            if (this.entryToOldKeysMap != null) {
                this.entryToOldKeysMap.remove();
            }
        } else {
            if (this.entryToOldKeysMap != null) {
                this.entryToOldKeysMap.remove();
            }
            this.evaluator.evaluate(entry, false);
            this.internalIndexStats.incNumUpdates();
        }
    }

    private void basicRemoveMapping(Object key, RegionEntry entry, boolean updateReverseMap) throws IMQException {
        try {
            Object newKey = TypeUtils.indexKeyFor(key);
            this.removeFromEntriesSet(newKey, entry, updateReverseMap);
        }
        catch (TypeMismatchException ex) {
            throw new IMQException("Could not add object of type " + key.getClass().getName(), ex);
        }
    }

    private void removeFromEntriesSet(Object newKey, RegionEntry entry, boolean updateReverseMap) {
        this.removeFromEntriesSet(newKey, entry, updateReverseMap, -1);
    }

    private void removeFromEntriesSet(Object newKey, RegionEntry entry, boolean updateReverseMap, int ignoreThisSlot) {
        if (this.entriesSet.remove(newKey, entry, ignoreThisSlot)) {
            if (updateReverseMap && IndexManager.isObjectModificationInplace()) {
                this.entryToValuesMap.remove(entry);
            }
            this.internalIndexStats.incNumValues(-1);
        }
    }

    @Override
    public boolean clear() throws QueryException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List queryEquijoinCondition(IndexProtocol indx, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        ArrayList arrayList;
        long start = this.updateIndexUseStats();
        ((AbstractIndex)indx).updateIndexUseStats();
        ArrayList data = new ArrayList();
        Iterator<Object> inner = null;
        try {
            Iterator outer = this.entriesSet.iterator();
            inner = indx instanceof CompactRangeIndex ? ((CompactRangeIndex)indx).getIndexStorage().iterator(null) : ((RangeIndex)indx).getValueToEntriesMap().entrySet().iterator();
            Map.Entry outerEntry = null;
            Object innerEntry = null;
            Object outerKey = null;
            Object innerKey = null;
            boolean incrementInner = true;
            block2: while (outer.hasNext()) {
                outerEntry = (Map.Entry)outer.next();
                outerKey = outerEntry.getKey();
                while (!incrementInner || inner.hasNext()) {
                    int compare;
                    if (incrementInner) {
                        innerEntry = inner.next();
                        innerKey = innerEntry instanceof IndexStore.IndexStoreEntry ? ((IndexStore.IndexStoreEntry)innerEntry).getDeserializedKey() : ((Map.Entry)innerEntry).getKey();
                    }
                    if ((compare = ((Comparable)outerKey).compareTo(innerKey)) == 0) {
                        CloseableIterator<IndexStore.IndexStoreEntry> innerValue = null;
                        innerValue = innerEntry instanceof IndexStore.IndexStoreEntry ? ((CompactRangeIndex)indx).getIndexStorage().get(outerKey) : (CloseableIterator<IndexStore.IndexStoreEntry>)((Map.Entry)innerEntry).getValue();
                        this.populateListForEquiJoin(data, outerEntry.getValue(), innerValue, context, innerKey);
                        incrementInner = true;
                        continue block2;
                    }
                    if (compare < 0) {
                        incrementInner = false;
                        continue block2;
                    }
                    incrementInner = true;
                }
                break block2;
            }
            arrayList = data;
            ((AbstractIndex)indx).updateIndexUseEndStats(start);
        }
        catch (Throwable throwable) {
            ((AbstractIndex)indx).updateIndexUseEndStats(start);
            this.updateIndexUseEndStats(start);
            if (inner != null && indx instanceof CompactRangeIndex) {
                inner.close();
            }
            throw throwable;
        }
        this.updateIndexUseEndStats(start);
        if (inner != null && indx instanceof CompactRangeIndex) {
            ((CloseableIterator)inner).close();
        }
        return arrayList;
    }

    private boolean verifyInnerAndOuterEntryValues(RegionEntry entry, ExecutionContext context, IndexInfo indexInfo, Object keyVal) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompactRangeIndex index = (CompactRangeIndex)indexInfo._getIndex();
        RuntimeIterator runtimeItr = index.getRuntimeIteratorForThisIndex(context, indexInfo);
        if (runtimeItr != null) {
            runtimeItr.setCurrent(this.getTargetObject(entry));
        }
        return this.evaluateEntry(indexInfo, context, keyVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getSizeEstimate(Object key, int operator, int matchLevel) throws TypeMismatchException {
        int size = 0;
        long start = this.updateIndexUseStats(false);
        try {
            switch (operator) {
                case 13: {
                    key = TypeUtils.indexKeyFor(key);
                    size = this.entriesSet.size(key);
                    return size;
                }
                case 20: 
                case 21: {
                    size = this.region.size();
                    key = TypeUtils.indexKeyFor(key);
                    size = this.entriesSet.size(key);
                    return size;
                }
            }
            return size;
        }
        finally {
            this.updateIndexUseEndStats(start, false);
        }
    }

    private Collection regionEntryCollection(Object regionEntries) {
        if (regionEntries == null) {
            return null;
        }
        if (regionEntries instanceof RegionEntry) {
            return Collections.singleton(regionEntries);
        }
        return (Collection)regionEntries;
    }

    private void lockedQueryPrivate(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, Set keysToRemove, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        if (keysToRemove == null) {
            keysToRemove = new HashSet(0);
        }
        int limit = -1;
        Boolean applyLimit = (Boolean)context.cacheGet("can_apply_limit_at_index");
        if (applyLimit != null && applyLimit.booleanValue()) {
            limit = (Integer)context.cacheGet("limit");
        }
        Boolean orderByClause = (Boolean)context.cacheGet("can_apply_orderby_at_index");
        boolean applyOrderBy = false;
        List orderByAttrs = null;
        if (orderByClause != null && orderByClause.booleanValue()) {
            orderByAttrs = (List)context.cacheGet("orderby");
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttrs.get(0);
            applyOrderBy = true;
        }
        this.evaluate(key, operator, results, iterOps, runtimeItr, context, keysToRemove, projAttrib, intermediateResults, isIntersection, limit, applyOrderBy, orderByAttrs);
    }

    @Override
    void lockedQuery(Object lowerBoundKey, int lowerBoundOperator, Object upperBoundKey, int upperBoundOperator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        throw new UnsupportedOperationException("Range grouping for HashIndex condition is not supported");
    }

    private void evaluate(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, Set keysToRemove, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit, boolean applyOrderBy, List orderByAttribs) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        boolean multiColOrderBy = false;
        if (keysToRemove == null) {
            keysToRemove = new HashSet<Object>(0);
        }
        if ((key = TypeUtils.indexKeyFor(key)) == null) {
            key = IndexManager.NULL;
        }
        boolean asc = true;
        if (applyOrderBy) {
            CompiledSortCriterion csc = (CompiledSortCriterion)orderByAttribs.get(0);
            asc = !csc.getCriterion();
            multiColOrderBy = orderByAttribs.size() > 1;
        }
        try {
            long iteratorCreationTime = this.cache.cacheTimeMillis();
            switch (operator) {
                case 13: {
                    assert (keysToRemove.isEmpty());
                    this.addToResultsFromEntries(this.entriesSet.get(key), results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit, keysToRemove, applyOrderBy, asc, iteratorCreationTime);
                    break;
                }
                case 20: 
                case 21: {
                    keysToRemove.add(key);
                    this.addToResultsFromEntries(this.entriesSet.getAllNotMatching(keysToRemove), results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit, keysToRemove, applyOrderBy, asc, iteratorCreationTime);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Operator = " + operator));
                }
            }
        }
        catch (ClassCastException ex) {
            if (operator == 13) {
                return;
            }
            if (operator == 20 || operator == 21) {
                keysToRemove.add(key);
                long iteratorCreationTime = this.cache.cacheTimeMillis();
                this.addToResultsFromEntries(this.entriesSet.getAllNotMatching(keysToRemove), results, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, multiColOrderBy ? -1 : limit, keysToRemove, applyOrderBy, asc, iteratorCreationTime);
            }
            throw new TypeMismatchException("", ex);
        }
    }

    @Override
    void instantiateEvaluator(IndexCreationHelper indexCreationHelper) {
        this.evaluator = new IMQEvaluator(indexCreationHelper);
        this.entriesSet.setEvaluator((IMQEvaluator)this.evaluator);
        this.comparator = ((IMQEvaluator)this.evaluator).comparator;
    }

    @Override
    public ObjectType getResultSetType() {
        return this.evaluator.getIndexResultSetType();
    }

    private void addToResultsFromEntries(Iterator entriesIter, Collection result, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit, Set keysToRemove, boolean applyOrderBy, boolean asc, long iteratorCreationTime) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        QueryObserver observer = QueryObserverHolder.getInstance();
        if (result == null || limit != -1 && result.size() == limit) {
            return;
        }
        ArrayList<Object[]> orderedKeys = null;
        ArrayList orderedResults = null;
        if (applyOrderBy) {
            orderedKeys = new ArrayList<Object[]>();
            orderedResults = new ArrayList();
        }
        int i = 0;
        while (entriesIter.hasNext()) {
            QueryMonitor.throwExceptionIfQueryOnCurrentThreadIsCanceled();
            if (IndexManager.testHook != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("IndexManager TestHook is set in addToResultsFromEntries.");
                }
                IndexManager.testHook.hook(11);
            }
            Object obj = entriesIter.next();
            Object key = null;
            if (obj == null || obj == HashIndexSet.REMOVED) continue;
            RegionEntry re = (RegionEntry)obj;
            if (applyOrderBy) {
                key = ((IMQEvaluator)this.evaluator).evaluateKey(obj);
                orderedKeys.add(new Object[]{key, i++});
                this.addValueToResultSet(re, orderedResults, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit, observer, iteratorCreationTime);
                continue;
            }
            this.addValueToResultSet(re, result, iterOps, runtimeItr, context, projAttrib, intermediateResults, isIntersection, limit, observer, iteratorCreationTime);
        }
        if (applyOrderBy) {
            Collections.sort(orderedKeys, this.comparator);
            if (!asc) {
                Collections.reverse(orderedKeys);
            }
            Object[] temp = orderedResults.toArray();
            ArrayList<Object> tempResults = new ArrayList<Object>(temp.length);
            for (Object e : orderedKeys) {
                int index = (Integer)((Object[])e)[1];
                tempResults.add(temp[index]);
            }
            result.addAll(tempResults);
        }
    }

    private void addValueToResultSet(RegionEntry re, Collection result, CompiledValue iterOps, RuntimeIterator runtimeItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection, int limit, QueryObserver observer, long iteratorCreationTime) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Object value = this.getTargetObject(re);
        if (value != null) {
            boolean ok = true;
            if (re.isUpdateInProgress() || IndexManager.needsRecalculation(iteratorCreationTime, re.getLastModified())) {
                IndexInfo indexInfo = (IndexInfo)context.cacheGet("index_info");
                if (runtimeItr == null && (runtimeItr = this.getRuntimeIteratorForThisIndex(context, indexInfo)) == null) {
                    throw new QueryInvocationTargetException("Query alias's must be used consistently");
                }
                runtimeItr.setCurrent(value);
                ok = this.evaluateEntry(indexInfo, context, null);
            }
            if (runtimeItr != null) {
                runtimeItr.setCurrent(value);
            }
            if (ok && runtimeItr != null && iterOps != null) {
                ok = QueryUtils.applyCondition(iterOps, context);
            }
            if (ok) {
                this.applyCqOrProjection(projAttrib, context, result, value, intermediateResults, isIntersection, re.getKey());
                if (limit != -1 && result.size() == limit) {
                    observer.limitAppliedAtIndexLevel(this, limit, result);
                    return;
                }
            }
        }
    }

    private boolean evaluateEntry(IndexInfo indexInfo, ExecutionContext context, Object keyVal) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        CompiledValue path = indexInfo._path();
        Object left = path.evaluate(context);
        CompiledValue key = indexInfo._key();
        Object right = null;
        if (keyVal == null && key == null) {
            return left == QueryService.UNDEFINED;
        }
        right = key != null ? key.evaluate(context) : keyVal;
        int operator = indexInfo._operator();
        if (left == null && right == null) {
            return Boolean.TRUE;
        }
        return (Boolean)TypeUtils.compare(left, right, operator);
    }

    private Object getTargetObject(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o = entry.getValue((LocalRegion)this.getRegion());
            try {
                if (o == Token.INVALID) {
                    return null;
                }
                if (o instanceof CachedDeserializable) {
                    return ((CachedDeserializable)o).getDeserializedForReading();
                }
            }
            catch (EntryDestroyedException ignored) {
                return null;
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new NonTXEntry((LocalRegion)this.getRegion(), entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getTargetObjectForUpdate(RegionEntry entry) {
        if (this.indexOnValues) {
            Object o;
            block9: {
                o = entry.getValueOffHeapOrDiskWithoutFaultIn((LocalRegion)this.getRegion());
                try {
                    if (o instanceof StoredObject) {
                        StoredObject ohval = (StoredObject)o;
                        try {
                            o = ohval.getDeserializedForReading();
                            break block9;
                        }
                        finally {
                            ohval.release();
                        }
                    }
                    if (o instanceof CachedDeserializable) {
                        o = ((CachedDeserializable)o).getDeserializedForReading();
                    }
                }
                catch (EntryDestroyedException ignored) {
                    return Token.INVALID;
                }
            }
            return o;
        }
        if (this.indexOnRegionKeys) {
            return entry.getKey();
        }
        return new NonTXEntry((LocalRegion)this.getRegion(), entry);
    }

    @Override
    void recreateIndexData() throws IMQException {
        int updates;
        int numValues;
        int numKeys;
        this.entriesSet.clear();
        if (IndexManager.isObjectModificationInplace()) {
            this.entryToValuesMap.clear();
        }
        if ((numKeys = (int)this.internalIndexStats.getNumberOfKeys()) > 0) {
            this.internalIndexStats.incNumKeys(-numKeys);
        }
        if ((numValues = (int)this.internalIndexStats.getNumberOfValues()) > 0) {
            this.internalIndexStats.incNumValues(-numValues);
        }
        if ((updates = (int)this.internalIndexStats.getNumUpdates()) > 0) {
            this.internalIndexStats.incNumUpdates(updates);
        }
        this.initializeIndex(true);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder(this.toString()).append(" {").append(SystemUtils.getLineSeparator());
        sb.append(" -----------------------------------------------").append(SystemUtils.getLineSeparator());
        for (Object anEntriesSet : this.entriesSet) {
            Map.Entry indexEntry = (Map.Entry)anEntriesSet;
            sb.append(" Key = ").append(indexEntry.getKey()).append(SystemUtils.getLineSeparator());
            sb.append(" Value Type = ").append(' ').append(indexEntry.getValue().getClass().getName()).append(SystemUtils.getLineSeparator());
            if (indexEntry.getValue() instanceof Collection) {
                sb.append(" Value Size = ").append(' ').append(((Collection)indexEntry.getValue()).size()).append(SystemUtils.getLineSeparator());
            } else if (indexEntry.getValue() instanceof RegionEntry) {
                sb.append(" Value Size = ").append(" 1").append(SystemUtils.getLineSeparator());
            } else {
                throw new AssertionError((Object)("value instance of " + indexEntry.getValue().getClass().getName()));
            }
            Collection entrySet = this.regionEntryCollection(indexEntry.getValue());
            for (Object anEntrySet : entrySet) {
                RegionEntry e = (RegionEntry)anEntrySet;
                Object value = this.getTargetObject(e);
                sb.append("  RegionEntry.key = ").append(e.getKey());
                sb.append("  Value.type = ").append(value.getClass().getName());
                if (value instanceof Collection) {
                    sb.append("  Value.size = ").append(((Collection)value).size());
                }
                sb.append(SystemUtils.getLineSeparator());
            }
            sb.append(" -----------------------------------------------").append(SystemUtils.getLineSeparator());
        }
        sb.append("}// Index ").append(this.getName()).append(" end");
        return sb.toString();
    }

    @Override
    protected AbstractIndex.InternalIndexStatistics createStats(String indexName) {
        return new RangeIndexStatistics(indexName);
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, CompiledValue iterOps, RuntimeIterator indpndntItr, ExecutionContext context, List projAttrib, SelectResults intermediateResults, boolean isIntersection) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        this.lockedQueryPrivate(key, operator, results, iterOps, indpndntItr, context, null, projAttrib, intermediateResults, isIntersection);
    }

    @Override
    void lockedQuery(Object key, int operator, Collection results, Set keysToRemove, ExecutionContext context) throws TypeMismatchException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException {
        this.lockedQueryPrivate(key, operator, results, null, null, context, keysToRemove, null, null, true);
    }

    @Override
    void addMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    void saveMapping(Object key, Object value, RegionEntry entry) throws IMQException {
    }

    @Override
    public boolean isEmpty() {
        return this.entriesSet.isEmpty();
    }

    class IMQEvaluator
    implements IndexedExpressionEvaluator {
        private final InternalCache cache;
        private List fromIterators = null;
        private CompiledValue indexedExpr = null;
        private final String[] canonicalIterNames;
        private ObjectType indexResultSetType = null;
        private Region rgn = null;
        private Map dependencyGraph = null;
        final HashIndexComparator comparator = new HashIndexComparator();
        private boolean isFirstItrOnEntry = false;
        private List indexInitIterators = null;
        private CompiledValue additionalProj = null;
        private CompiledValue modifiedIndexExpr = null;
        private ObjectType addnlProjType = null;
        private int initEntriesUpdated = 0;
        private boolean hasInitOccurredOnce = false;
        private boolean hasIndxUpdateOccurredOnce = false;
        private ExecutionContext initContext = null;
        private int iteratorSize = -1;

        IMQEvaluator(IndexCreationHelper helper) {
            this.cache = helper.getCache();
            this.fromIterators = helper.getIterators();
            this.indexedExpr = helper.getCompiledIndexedExpression();
            this.canonicalIterNames = ((FunctionalIndexCreationHelper)helper).canonicalizedIteratorNames;
            this.rgn = helper.getRegion();
            this.isFirstItrOnEntry = ((FunctionalIndexCreationHelper)helper).isFirstIteratorRegionEntry;
            this.additionalProj = ((FunctionalIndexCreationHelper)helper).additionalProj;
            Object[] params1 = new Object[]{new QRegion(this.rgn, false)};
            this.initContext = new ExecutionContext(params1, this.cache);
            if (this.isFirstItrOnEntry) {
                this.indexInitIterators = this.fromIterators;
            } else {
                this.indexInitIterators = ((FunctionalIndexCreationHelper)helper).indexInitIterators;
                this.modifiedIndexExpr = ((FunctionalIndexCreationHelper)helper).modifiedIndexExpr;
                this.addnlProjType = ((FunctionalIndexCreationHelper)helper).addnlProjType;
            }
            this.iteratorSize = this.indexInitIterators.size();
            if (this.additionalProj instanceof CompiledPath) {
                String tailId = ((CompiledPath)this.additionalProj).getTailID();
                if (tailId.equals("key")) {
                    HashIndex.this.indexOnRegionKeys = true;
                } else if (!this.isFirstItrOnEntry) {
                    HashIndex.this.indexOnValues = true;
                }
            }
        }

        @Override
        public String getIndexedExpression() {
            return HashIndex.this.getCanonicalizedIndexedExpression();
        }

        @Override
        public String getProjectionAttributes() {
            return HashIndex.this.getCanonicalizedProjectionAttributes();
        }

        @Override
        public String getFromClause() {
            return HashIndex.this.getCanonicalizedFromClause();
        }

        @Override
        public void expansion(List expandedResults, Object lowerBoundKey, Object upperBoundKey, int lowerBoundOperator, int upperBoundOperator, Object value) throws IMQException {
        }

        @Override
        public void evaluate(RegionEntry target, boolean add) throws IMQException {
            block11: {
                assert (!target.isInvalid()) : "value in RegionEntry should not be INVALID";
                ExecutionContext context = null;
                try {
                    context = this.createExecutionContext(target);
                    this.doNestedIterations(0, add, context);
                }
                catch (TypeMismatchException tme) {
                    if (tme.getRootCause() instanceof EntryDestroyedException) {
                        HashIndex.this.entriesSet.remove(QueryService.UNDEFINED, target, -1);
                        break block11;
                    }
                    throw new IMQException(tme);
                }
                catch (IMQException imqe) {
                    throw imqe;
                }
                catch (Exception e) {
                    throw new IMQException(e);
                }
                finally {
                    if (context != null) {
                        context.popScope();
                    }
                }
            }
        }

        @Override
        public void initializeIndex(boolean loadEntries) throws IMQException {
            this.initEntriesUpdated = 0;
            try {
                this.initContext.newScope(1);
                for (int i = 0; i < this.iteratorSize; ++i) {
                    CompiledIteratorDef iterDef = (CompiledIteratorDef)this.indexInitIterators.get(i);
                    RuntimeIterator rIter = null;
                    if (!this.hasInitOccurredOnce) {
                        iterDef.computeDependencies(this.initContext);
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                        this.initContext.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                    }
                    if (rIter == null) {
                        rIter = iterDef.getRuntimeIterator(this.initContext);
                    }
                    this.initContext.bindIterator(rIter);
                }
                this.hasInitOccurredOnce = true;
                if (this.indexResultSetType == null) {
                    this.indexResultSetType = this.createIndexResultSetType();
                }
                if (loadEntries) {
                    this.doNestedIterationsForIndexInit(0, this.initContext.getCurrentIterators());
                }
            }
            catch (IMQException imqe) {
                throw imqe;
            }
            catch (Exception e) {
                throw new IMQException(e);
            }
            finally {
                this.initContext.popScope();
            }
        }

        private void doNestedIterationsForIndexInit(int level, List runtimeIterators) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            if (level == 1) {
                ++this.initEntriesUpdated;
            }
            if (level == this.iteratorSize) {
                this.applyProjectionForIndexInit(runtimeIterators);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)runtimeIterators.get(level);
                SelectResults c = rIter.evaluateCollection(this.initContext);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedIterationsForIndexInit(level + 1, runtimeIterators);
                }
            }
        }

        private void applyProjectionForIndexInit(List currentRuntimeIters) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            if (QueryMonitor.isLowMemory()) {
                throw new IMQException("Index creation canceled due to low memory");
            }
            Object indexKey = null;
            RegionEntry re = null;
            Object object = indexKey = this.isFirstItrOnEntry ? this.indexedExpr.evaluate(this.initContext) : this.modifiedIndexExpr.evaluate(this.initContext);
            if (indexKey == null) {
                indexKey = IndexManager.NULL;
            }
            NonTXEntry temp = null;
            temp = this.isFirstItrOnEntry && this.additionalProj != null ? (NonTXEntry)this.additionalProj.evaluate(this.initContext) : (NonTXEntry)((RuntimeIterator)currentRuntimeIters.get(0)).evaluate(this.initContext);
            re = temp.getRegionEntry();
            HashIndex.this.basicAddMapping(indexKey, re);
        }

        private void doNestedIterations(int level, boolean add, ExecutionContext context) throws TypeMismatchException, AmbiguousNameException, FunctionDomainException, NameResolutionException, QueryInvocationTargetException, IMQException {
            List iterList = context.getCurrentIterators();
            if (level == this.iteratorSize) {
                this.applyProjection(add, context);
            } else {
                RuntimeIterator rIter = (RuntimeIterator)iterList.get(level);
                SelectResults c = rIter.evaluateCollection(context);
                if (c == null) {
                    return;
                }
                Iterator cIter = c.iterator();
                while (cIter.hasNext()) {
                    rIter.setCurrent(cIter.next());
                    this.doNestedIterations(level + 1, add, context);
                }
            }
        }

        private void applyProjection(boolean add, ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException, IMQException {
            Object indexKey = this.indexedExpr.evaluate(context);
            if (indexKey == null) {
                indexKey = IndexManager.NULL;
            }
            RegionEntry entry = ((DummyQRegion)context.getBindArgument(1)).getEntry();
            if (add) {
                HashIndex.this.basicAddMapping(indexKey, entry);
                if (HashIndex.this.entryToOldKeysMap != null) {
                    HashIndex.this.entryToOldKeysMap.remove();
                }
            } else if (HashIndex.this.entryToOldKeysMap != null) {
                Map oldKeyMap = (Map)HashIndex.this.entryToOldKeysMap.get();
                if (oldKeyMap != null) {
                    oldKeyMap.put(entry, indexKey);
                } else {
                    HashIndex.this.basicRemoveMapping(indexKey, entry, true);
                }
            } else {
                HashIndex.this.basicRemoveMapping(indexKey, entry, true);
            }
        }

        private ObjectType createIndexResultSetType() {
            int start;
            List currentIterators = this.initContext.getCurrentIterators();
            int len = currentIterators.size();
            ObjectType type = null;
            ObjectType[] fieldTypes = new ObjectType[len];
            int n = start = this.isFirstItrOnEntry ? 0 : 1;
            while (start < len) {
                RuntimeIterator iter = (RuntimeIterator)currentIterators.get(start);
                fieldTypes[start] = iter.getElementType();
                ++start;
            }
            if (!this.isFirstItrOnEntry) {
                fieldTypes[0] = this.addnlProjType;
            }
            type = len == 1 ? fieldTypes[0] : new StructTypeImpl(this.canonicalIterNames, fieldTypes);
            return type;
        }

        int getTotalEntriesUpdated() {
            return this.initEntriesUpdated;
        }

        @Override
        public ObjectType getIndexResultSetType() {
            return this.indexResultSetType;
        }

        @Override
        public List getAllDependentIterators() {
            return this.fromIterators;
        }

        private ExecutionContext createExecutionContext(RegionEntry target) throws NameResolutionException, TypeMismatchException {
            DummyQRegion dQRegion = new DummyQRegion(this.rgn);
            dQRegion.setEntry(target);
            Object[] params = new Object[]{dQRegion};
            ExecutionContext context = new ExecutionContext(params, this.cache);
            context.newScope(-2);
            if (this.dependencyGraph != null) {
                context.setDependencyGraph(this.dependencyGraph);
            }
            for (int i = 0; i < this.iteratorSize; ++i) {
                CompiledIteratorDef iterDef = (CompiledIteratorDef)this.fromIterators.get(i);
                if (this.dependencyGraph == null) {
                    iterDef.computeDependencies(context);
                }
                RuntimeIterator rIter = iterDef.getRuntimeIterator(context);
                context.addToIndependentRuntimeItrMapForIndexCreation(iterDef);
                context.bindIterator(rIter);
            }
            if (this.dependencyGraph == null) {
                this.dependencyGraph = context.getDependencyGraph();
            }
            Support.Assert(this.indexResultSetType != null, "IMQEvaluator::evaluate:The StructType should have been initialized during index creation");
            return context;
        }

        public Object evaluateKey(Object object) {
            Object value = object;
            ExecutionContext newContext = null;
            Object key = null;
            try {
                if (object instanceof RegionEntry) {
                    RegionEntry regionEntry = (RegionEntry)object;
                    newContext = this.createExecutionContext(regionEntry);
                    value = HashIndex.this.getTargetObjectForUpdate(regionEntry);
                }
                List iterators = newContext.getCurrentIterators();
                RuntimeIterator itr = (RuntimeIterator)iterators.get(0);
                itr.setCurrent(value);
                key = this.indexedExpr.evaluate(newContext);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Could not reevaluate key for hash index");
                }
                throw new Error("Could not reevaluate key for hash index", e);
            }
            if (key == null) {
                key = IndexManager.NULL;
            }
            return key;
        }

        class HashIndexComparator
        implements Comparator {
            HashIndexComparator() {
            }

            public int compare(Object arg0, Object arg1) {
                Object key0 = ((Object[])arg0)[0];
                Object key1 = ((Object[])arg1)[0];
                Comparable comp0 = (Comparable)key0;
                Comparable comp1 = (Comparable)key1;
                return comp0.compareTo(comp1);
            }
        }
    }

    class RangeIndexStatistics
    extends AbstractIndex.InternalIndexStatistics {
        private IndexStats vsdStats;

        public RangeIndexStatistics(String indexName) {
            this.vsdStats = new IndexStats(HashIndex.this.getRegion().getCache().getDistributedSystem(), indexName);
        }

        @Override
        public long getNumUpdates() {
            return this.vsdStats.getNumUpdates();
        }

        @Override
        public void incNumValues(int delta) {
            this.vsdStats.incNumValues(delta);
        }

        @Override
        public void incNumUpdates() {
            this.vsdStats.incNumUpdates();
        }

        @Override
        public void incNumUpdates(int delta) {
            this.vsdStats.incNumUpdates(delta);
        }

        @Override
        public void updateNumKeys(long numKeys) {
            this.vsdStats.updateNumKeys(numKeys);
        }

        @Override
        public void incNumKeys(long numKeys) {
            this.vsdStats.incNumKeys(numKeys);
        }

        @Override
        public void incUpdateTime(long delta) {
            this.vsdStats.incUpdateTime(delta);
        }

        @Override
        public void incUpdatesInProgress(int delta) {
            this.vsdStats.incUpdatesInProgress(delta);
        }

        @Override
        public void incNumUses() {
            this.vsdStats.incNumUses();
        }

        @Override
        public void incUseTime(long delta) {
            this.vsdStats.incUseTime(delta);
        }

        @Override
        public void incUsesInProgress(int delta) {
            this.vsdStats.incUsesInProgress(delta);
        }

        @Override
        public void incReadLockCount(int delta) {
            this.vsdStats.incReadLockCount(delta);
        }

        @Override
        public long getTotalUpdateTime() {
            return this.vsdStats.getTotalUpdateTime();
        }

        @Override
        public long getTotalUses() {
            return this.vsdStats.getTotalUses();
        }

        @Override
        public long getNumberOfKeys() {
            return this.vsdStats.getNumberOfKeys();
        }

        @Override
        public long getNumberOfValues() {
            return this.vsdStats.getNumberOfValues();
        }

        @Override
        public long getNumberOfValues(Object key) {
            Iterator rgnEntries = HashIndex.this.entriesSet.get(key);
            if (rgnEntries == null) {
                return 0L;
            }
            if (rgnEntries instanceof RegionEntry) {
                return 1L;
            }
            return ((Collection)((Object)rgnEntries)).size();
        }

        @Override
        public int getReadLockCount() {
            return this.vsdStats.getReadLockCount();
        }

        @Override
        public void close() {
            this.vsdStats.close();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("No Keys = ").append(this.getNumberOfKeys()).append(SystemUtils.getLineSeparator());
            sb.append("No Values = ").append(this.getNumberOfValues()).append(SystemUtils.getLineSeparator());
            sb.append("No Uses = ").append(this.getTotalUses()).append(SystemUtils.getLineSeparator());
            sb.append("No Updates = ").append(this.getNumUpdates()).append(SystemUtils.getLineSeparator());
            sb.append("Total Update time = ").append(this.getTotalUpdateTime()).append(SystemUtils.getLineSeparator());
            return sb.toString();
        }
    }
}

