/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal.locks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.locks.DLockToken;
import org.apache.geode.distributed.internal.locks.RemoteThread;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.internal.serialization.Version;

public class DLockRemoteToken
implements DataSerializableFixedID {
    private final Object name;
    private final int leaseId;
    private final long leaseExpireTime;
    private final RemoteThread lesseeThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DLockRemoteToken createFromDLockToken(DLockToken token) {
        DLockToken dLockToken = token;
        synchronized (dLockToken) {
            return new DLockRemoteToken(token.getName(), token.getLesseeThread(), token.getLeaseId(), token.getLeaseExpireTime());
        }
    }

    public static DLockRemoteToken createFromDataInput(DataInput in) throws IOException, ClassNotFoundException {
        Object name = DataSerializer.readObject(in);
        RemoteThread lesseeThread = null;
        InternalDistributedMember lessee = (InternalDistributedMember)DataSerializer.readObject(in);
        lesseeThread = new RemoteThread(lessee, in.readInt());
        int leaseId = in.readInt();
        long leaseExpireTime = in.readLong();
        return new DLockRemoteToken(name, lesseeThread, leaseId, leaseExpireTime);
    }

    public static DLockRemoteToken create(Object name, RemoteThread lesseeThread, int leaseId, long leaseExpireTime) {
        return new DLockRemoteToken(name, lesseeThread, leaseId, leaseExpireTime);
    }

    public DLockRemoteToken() {
        throw new UnsupportedOperationException("Use DLockRemoteToken#createFromDataInput(DataInput) instead.");
    }

    private DLockRemoteToken(Object name, RemoteThread lesseeThread, int leaseId, long leaseExpireTime) {
        this.name = name;
        this.lesseeThread = lesseeThread;
        this.leaseId = leaseId;
        this.leaseExpireTime = leaseExpireTime;
    }

    public Object getName() {
        return this.name;
    }

    public RemoteThread getLesseeThread() {
        return this.lesseeThread;
    }

    public DistributedMember getLessee() {
        if (this.lesseeThread == null) {
            return null;
        }
        return this.lesseeThread.getDistributedMember();
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public long getLeaseExpireTime() {
        return this.leaseExpireTime;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DLockRemoteToken@");
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append(", name: ").append(this.name);
        sb.append(", lesseeThread: ").append(this.lesseeThread);
        sb.append(", leaseId: ").append(this.leaseId);
        sb.append(", leaseExpireTime: ").append(this.leaseExpireTime);
        return sb.toString();
    }

    public int getDSFID() {
        return 117;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        context.getSerializer().writeObject(this.name, out);
        context.getSerializer().writeObject((Object)this.lesseeThread.getDistributedMember(), out);
        out.writeInt(this.lesseeThread.getThreadId());
        out.writeInt(this.leaseId);
        out.writeLong(this.leaseExpireTime);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("Use DLockRemoteToken#createFromDataInput(DataInput) instead.");
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

