/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ServerLocation;

public class BucketServerLocation
extends ServerLocation {
    private byte version;
    private int bucketId;
    private boolean isPrimary;

    public BucketServerLocation() {
    }

    public BucketServerLocation(int bucketId, int port, String host, boolean isPrimary, byte version) {
        super(host, port);
        this.bucketId = bucketId;
        this.isPrimary = isPrimary;
        this.version = version;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.bucketId = DataSerializer.readInteger(in);
        this.isPrimary = DataSerializer.readBoolean(in);
        this.version = DataSerializer.readByte(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeInteger(this.bucketId, out);
        DataSerializer.writeBoolean(this.isPrimary, out);
        DataSerializer.writeByte(this.version, out);
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public byte getVersion() {
        return this.version;
    }

    public int getBucketId() {
        return this.bucketId;
    }
}

