/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionExecutor;
import org.apache.geode.internal.cache.execute.DistributedRegionFunctionResultSender;
import org.apache.geode.internal.cache.execute.FunctionStreamingResultCollector;
import org.apache.geode.internal.cache.execute.MemberFunctionResultSender;
import org.apache.geode.internal.cache.execute.MultiRegionFunctionExecutor;

public abstract class StreamingFunctionOperation {
    protected final InternalDistributedSystem sys;
    protected Set recipients = null;
    protected ResultCollector rc;
    protected Function functionObject;
    protected HashMap<InternalDistributedMember, Object> memberArgs;
    protected ResultSender resultSender = null;
    protected ResultCollector reply;
    protected int totalLastMsgReceived = 0;

    public StreamingFunctionOperation(InternalDistributedSystem sys, ResultCollector rc, Function function, HashMap<InternalDistributedMember, Object> memberArgs, Set recipients, ResultSender resultSender) {
        this.sys = sys;
        this.rc = rc;
        this.functionObject = function;
        this.memberArgs = memberArgs;
        this.recipients = recipients;
        this.resultSender = resultSender;
    }

    public StreamingFunctionOperation(InternalDistributedSystem sys, ResultCollector rc, Function function, ResultSender resultSender) {
        this.sys = sys;
        this.rc = rc;
        this.functionObject = function;
        this.resultSender = resultSender;
    }

    public void processData(Object result, boolean lastMsg, DistributedMember memberID) {
        boolean completelyDone = false;
        if (lastMsg) {
            ++this.totalLastMsgReceived;
        }
        if (this.totalLastMsgReceived == this.recipients.size()) {
            completelyDone = true;
        }
        if (this.resultSender instanceof MemberFunctionResultSender) {
            MemberFunctionResultSender rs = (MemberFunctionResultSender)this.resultSender;
            rs.lastResult(result, completelyDone, this.reply, memberID);
        } else if (completelyDone) {
            ((DistributedRegionFunctionResultSender)this.resultSender).lastResult(result, memberID);
        } else {
            ((DistributedRegionFunctionResultSender)this.resultSender).sendResult(result, memberID);
        }
    }

    public ResultCollector getFunctionResultFrom(Set recipients, Function function, AbstractExecution execution) {
        if (recipients.isEmpty()) {
            return this.rc;
        }
        FunctionStreamingResultCollector processor = new FunctionStreamingResultCollector(this, this.sys, recipients, this.rc, function, execution);
        this.reply = processor;
        for (InternalDistributedMember recip : this.memberArgs.keySet()) {
            DistributionMessage m = null;
            m = execution instanceof DistributedRegionFunctionExecutor || execution instanceof MultiRegionFunctionExecutor ? this.createRequestMessage(Collections.singleton(recip), processor, execution.isReExecute(), execution.isFnSerializationReqd()) : this.createRequestMessage(Collections.singleton(recip), processor, false, execution.isFnSerializationReqd());
            this.sys.getDistributionManager().putOutgoing(m);
        }
        return processor;
    }

    protected abstract DistributionMessage createRequestMessage(Set<InternalDistributedMember> var1, FunctionStreamingResultCollector var2, boolean var3, boolean var4);
}

