/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.concurrent;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.geode.CancelCriterion;
import org.apache.geode.internal.Assert;

public class StoppableReentrantReadWriteLock
implements Serializable {
    private static final long serialVersionUID = -1185707921434766946L;
    private final transient StoppableReadLock readLock;
    private final transient StoppableWriteLock writeLock;
    private static final long RETRY_TIME = 15000L;

    public StoppableReentrantReadWriteLock(CancelCriterion stopper) {
        this(new ReentrantReadWriteLock(), stopper);
    }

    protected StoppableReentrantReadWriteLock(ReadWriteLock lock, CancelCriterion stopper) {
        Assert.assertTrue(stopper != null);
        this.readLock = new StoppableReadLock(lock, stopper);
        this.writeLock = new StoppableWriteLock(lock, stopper);
    }

    public StoppableReadLock readLock() {
        return this.readLock;
    }

    public StoppableWriteLock writeLock() {
        return this.writeLock;
    }

    public static class StoppableWriteLock {
        private final Lock lock;
        private final CancelCriterion stopper;

        public StoppableWriteLock(ReadWriteLock lock, CancelCriterion stopper) {
            this.lock = lock.writeLock();
            this.stopper = stopper;
        }

        public void lock() {
            boolean interrupted = Thread.interrupted();
            try {
                while (true) {
                    try {
                        this.lockInterruptibly();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            do {
                this.stopper.checkCancelInProgress(null);
            } while (!this.lock.tryLock(15000L, TimeUnit.MILLISECONDS));
        }

        public boolean tryLock() {
            this.stopper.checkCancelInProgress(null);
            return this.lock.tryLock();
        }

        public boolean tryLock(long timeout) throws InterruptedException {
            this.stopper.checkCancelInProgress(null);
            return this.lock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }

        public void unlock() {
            this.lock.unlock();
        }
    }

    public static class StoppableReadLock {
        private final Lock lock;
        private final CancelCriterion stopper;

        StoppableReadLock(ReadWriteLock lock, CancelCriterion stopper) {
            this.lock = lock.readLock();
            this.stopper = stopper;
        }

        public void lock() {
            boolean interrupted = Thread.interrupted();
            try {
                while (true) {
                    try {
                        this.lockInterruptibly();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void lockInterruptibly() throws InterruptedException {
            do {
                this.stopper.checkCancelInProgress(null);
            } while (!this.lock.tryLock(15000L, TimeUnit.MILLISECONDS));
        }

        public boolean tryLock() {
            this.stopper.checkCancelInProgress(null);
            return this.lock.tryLock();
        }

        public boolean tryLock(long timeout) throws InterruptedException {
            this.stopper.checkCancelInProgress(null);
            return this.lock.tryLock(timeout, TimeUnit.MILLISECONDS);
        }

        public void unlock() {
            this.lock.unlock();
        }
    }
}

