/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.mutators;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.geode.distributed.internal.InternalConfigurationPersistenceService;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.internal.configuration.domain.Configuration;
import org.apache.geode.management.internal.configuration.mutators.ConfigurationManager;

public class DeploymentManager
implements ConfigurationManager<Deployment> {
    private final InternalConfigurationPersistenceService persistenceService;

    public DeploymentManager(InternalConfigurationPersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public void add(Deployment config, String groupName) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void delete(Deployment config, String groupName) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void update(Deployment config, String groupName) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public List<Deployment> list(Deployment filter, String groupName) {
        Configuration configuration = this.persistenceService.getConfiguration(groupName);
        if (configuration == null) {
            return Collections.emptyList();
        }
        return configuration.getDeployments().stream().filter(DeploymentManager.deploymentsForJarName(filter.getJarFileName())).collect(Collectors.toList());
    }

    private static Predicate<Deployment> deploymentsForJarName(String jarFileName) {
        return jarFileName == null ? d -> true : d -> d.getJarFileName().equals(jarFileName);
    }
}

