/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.messages;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.persistence.PersistentID;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.remote.AdminMultipleReplyProcessor;
import org.apache.geode.internal.admin.remote.AdminRequest;
import org.apache.geode.internal.admin.remote.AdminResponse;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.messages.CompactResponse;
import org.apache.logging.log4j.Logger;

public class CompactRequest
extends AdminRequest {
    private static final Logger logger = LogService.getLogger();
    private String diskStoreName;
    @MakeNotStatic
    private static String notExecutedMembers;

    public static Map<DistributedMember, PersistentID> send(DistributionManager dm, String diskStoreName, Set<? extends DistributedMember> recipients) {
        Map<DistributedMember, PersistentID> results = Collections.emptyMap();
        if (recipients != null && !recipients.isEmpty()) {
            CompactRequest request = new CompactRequest();
            request.setRecipients(recipients);
            CompactReplyProcessor replyProcessor = new CompactReplyProcessor(dm, recipients);
            request.msgId = replyProcessor.getProcessorId();
            request.diskStoreName = diskStoreName;
            request.setSender(dm.getDistributionManagerId());
            Set<InternalDistributedMember> putOutgoing = dm.putOutgoing(request);
            if (putOutgoing != null && !putOutgoing.isEmpty()) {
                notExecutedMembers = putOutgoing.toString();
            }
            try {
                replyProcessor.waitForReplies();
            }
            catch (ReplyException e) {
                if (!(e.getCause() instanceof CancelException)) {
                    throw e;
                }
            }
            catch (InterruptedException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            results = replyProcessor.results;
        }
        return results;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        super.process(dm);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        PersistentID compactedDiskStore = CompactRequest.compactDiskStore(this.diskStoreName);
        return new CompactResponse(this.getSender(), compactedDiskStore);
    }

    public static PersistentID compactDiskStore(String diskStoreName) {
        DiskStoreImpl diskStore;
        PersistentID persistentID = null;
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed() && (diskStore = (DiskStoreImpl)cache.findDiskStore(diskStoreName)) != null && diskStore.forceCompaction()) {
            persistentID = diskStore.getPersistentID();
        }
        return persistentID;
    }

    public static String getNotExecutedMembers() {
        return notExecutedMembers;
    }

    public int getDSFID() {
        return 2152;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.diskStoreName = DataSerializer.readString(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeString(this.diskStoreName, out);
    }

    @Override
    public String toString() {
        return "Compact request sent to " + this.getRecipientsDescription() + " from " + this.getSender() + " for " + this.diskStoreName;
    }

    private static class CompactReplyProcessor
    extends AdminMultipleReplyProcessor {
        Map<DistributedMember, PersistentID> results = Collections.synchronizedMap(new HashMap());

        public CompactReplyProcessor(DistributionManager dm, Collection<?> initMembers) {
            super(dm, initMembers);
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        @Override
        protected boolean allowReplyFromSender() {
            return true;
        }

        @Override
        protected void process(DistributionMessage message, boolean warn) {
            PersistentID persistentId;
            if (message instanceof CompactResponse && (persistentId = ((CompactResponse)message).getPersistentId()) != null) {
                this.results.put(message.getSender(), persistentId);
            }
            super.process(message, warn);
        }
    }
}

