/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.EncodingAware;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.geronimo.mail.util.ASCIIUtil;
import org.apache.geronimo.mail.util.SessionUtil;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static final String MIME_DECODEFILENAME = "mail.mime.decodefilename";
    private static final String MIME_ENCODEFILENAME = "mail.mime.encodefilename";
    private static final String MIME_SETDEFAULTTEXTCHARSET = "mail.mime.setdefaulttextcharset";
    private static final String MIME_SETCONTENTTYPEFILENAME = "mail.mime.setcontenttypefilename";
    static final boolean cacheMultipart = SessionUtil.getBooleanProperty("mail.mime.cachemultipart", true);
    protected DataHandler dh;
    protected Object cachedContent;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream in) throws MessagingException {
        this.headers = new InternetHeaders(in);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int count;
            while ((count = in.read(buffer, 0, 1024)) > 0) {
                baos.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new MessagingException(e.toString(), e);
        }
        this.content = baos.toByteArray();
    }

    public MimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        this.headers = headers;
        this.content = content;
    }

    @Override
    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int size = this.contentStream.available();
                if (size > 0) {
                    return size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public int getLineCount() throws MessagingException {
        return -1;
    }

    @Override
    public String getContentType() throws MessagingException {
        String value = this.getSingleHeader("Content-Type");
        if (value == null) {
            value = "text/plain";
        }
        return value;
    }

    @Override
    public boolean isMimeType(String type) throws MessagingException {
        return new ContentType(this.getContentType()).match(type);
    }

    @Override
    public String getDisposition() throws MessagingException {
        String disp = this.getSingleHeader("Content-Disposition");
        if (disp != null) {
            return new ContentDisposition(disp).getDisposition();
        }
        return null;
    }

    @Override
    public void setDisposition(String disposition) throws MessagingException {
        if (disposition == null) {
            this.removeHeader("Content-Disposition");
        } else {
            String currentHeader = this.getSingleHeader("Content-Disposition");
            if (currentHeader != null) {
                ContentDisposition content = new ContentDisposition(currentHeader);
                content.setDisposition(disposition);
                this.setHeader("Content-Disposition", content.toString());
            } else {
                this.setHeader("Content-Disposition", disposition);
            }
        }
    }

    @Override
    public String getEncoding() throws MessagingException {
        String encoding = this.getSingleHeader("Content-Transfer-Encoding");
        if (encoding != null) {
            HeaderTokenizer tokenizer = new HeaderTokenizer(encoding, "()<>@,;:\\\"\t []/?=");
            HeaderTokenizer.Token token = tokenizer.next();
            while (token.getType() != -4) {
                if (token.getType() != -1) continue;
                return token.getValue();
            }
            return encoding;
        }
        return null;
    }

    @Override
    public String getContentID() throws MessagingException {
        return this.getSingleHeader("Content-ID");
    }

    public void setContentID(String cid) throws MessagingException {
        this.setOrRemoveHeader("Content-ID", cid);
    }

    @Override
    public String getContentMD5() throws MessagingException {
        return this.getSingleHeader("Content-MD5");
    }

    @Override
    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    @Override
    public String[] getContentLanguage() throws MessagingException {
        return this.getHeader("Content-Language");
    }

    @Override
    public void setContentLanguage(String[] languages) throws MessagingException {
        if (languages == null) {
            this.removeHeader("Content-Language");
        } else if (languages.length == 1) {
            this.setHeader("Content-Language", languages[0]);
        } else {
            StringBuffer buf = new StringBuffer(languages.length * 20);
            buf.append(languages[0]);
            for (int i = 1; i < languages.length; ++i) {
                buf.append(',').append(languages[i]);
            }
            this.setHeader("Content-Language", buf.toString());
        }
    }

    @Override
    public String getDescription() throws MessagingException {
        String description = this.getSingleHeader("Content-Description");
        if (description != null) {
            try {
                return MimeUtility.decodeText(MimeUtility.unfold(description));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return description;
    }

    @Override
    public void setDescription(String description) throws MessagingException {
        this.setDescription(description, null);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        if (description == null) {
            this.removeHeader("Content-Description");
        } else {
            try {
                this.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(description, charset, null)));
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException(e.getMessage(), e);
            }
        }
    }

    @Override
    public String getFileName() throws MessagingException {
        String type;
        String disposition = this.getSingleHeader("Content-Disposition");
        String filename = null;
        if (disposition != null) {
            filename = new ContentDisposition(disposition).getParameter("filename");
        }
        if (filename == null && (type = this.getSingleHeader("Content-Type")) != null) {
            try {
                filename = new ContentType(type).getParameter("name");
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (filename != null && SessionUtil.getBooleanProperty(MIME_DECODEFILENAME, false)) {
            try {
                filename = MimeUtility.decodeText(filename);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unable to decode filename", e);
            }
        }
        return filename;
    }

    @Override
    public void setFileName(String name) throws MessagingException {
        String disposition;
        if (name != null && SessionUtil.getBooleanProperty(MIME_ENCODEFILENAME, false)) {
            try {
                name = MimeUtility.encodeText(name);
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("Unable to encode filename", e);
            }
        }
        if ((disposition = this.getDisposition()) == null) {
            disposition = "attachment";
        }
        ContentDisposition contentDisposition = new ContentDisposition(disposition);
        contentDisposition.setParameter("filename", name);
        this.setHeader("Content-Disposition", contentDisposition.toString());
        if (SessionUtil.getBooleanProperty(MIME_SETCONTENTTYPEFILENAME, true)) {
            ContentType type = new ContentType(this.getContentType());
            type.setParameter("name", name);
            this.setHeader("Content-Type", type.toString());
        }
    }

    @Override
    public InputStream getInputStream() throws MessagingException, IOException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    @Override
    public synchronized DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler((DataSource)new MimePartDataSource(this));
        }
        return this.dh;
    }

    @Override
    public Object getContent() throws MessagingException, IOException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        Object c = this.getDataHandler().getContent();
        if (cacheMultipart && (c instanceof Multipart || c instanceof Message) && (this.content != null || this.contentStream != null)) {
            this.cachedContent = c;
            if (c instanceof MimeMultipart) {
                ((MimeMultipart)c).parse();
            }
        }
        return c;
    }

    @Override
    public void setDataHandler(DataHandler handler) throws MessagingException {
        this.dh = handler;
        this.removeHeader("Content-Type");
        this.removeHeader("Content-Transfer-Encoding");
        this.cachedContent = null;
    }

    @Override
    public void setContent(Object content, String type) throws MessagingException {
        if (content instanceof Multipart) {
            this.setContent((Multipart)content);
        } else {
            this.setDataHandler(new DataHandler(content, type));
        }
    }

    @Override
    public void setText(String text) throws MessagingException {
        this.setText(text, null);
    }

    @Override
    public void setText(String text, String charset) throws MessagingException {
        this.setText(text, charset, "plain");
    }

    @Override
    public void setText(String text, String charset, String subtype) throws MessagingException {
        String actualSubtype;
        if (charset == null) {
            charset = !ASCIIUtil.isAscii(text) ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        if ((actualSubtype = subtype) == null || actualSubtype.isEmpty()) {
            actualSubtype = "plain";
        }
        this.setContent(text, "text/" + actualSubtype + "; charset=" + MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
    }

    @Override
    public void setContent(Multipart part) throws MessagingException {
        this.setDataHandler(new DataHandler((Object)part, part.getContentType()));
        part.setParent(this);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException, MessagingException {
        this.headers.writeTo(out, null);
        out.write(13);
        out.write(10);
        OutputStream encodingStream = MimeUtility.encode(out, this.getEncoding());
        this.getDataHandler().writeTo(encodingStream);
        encodingStream.flush();
    }

    @Override
    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    @Override
    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    @Override
    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    private void setOrRemoveHeader(String name, String value) throws MessagingException {
        if (value == null) {
            this.headers.removeHeader(name);
        } else {
            this.headers.setHeader(name, value);
        }
    }

    @Override
    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    @Override
    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    @Override
    public Enumeration<Header> getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    @Override
    public Enumeration<Header> getMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getMatchingHeaders(name);
    }

    @Override
    public Enumeration<Header> getNonMatchingHeaders(String[] name) throws MessagingException {
        return this.headers.getNonMatchingHeaders(name);
    }

    @Override
    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    @Override
    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    @Override
    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    @Override
    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    protected void updateHeaders() throws MessagingException {
        block16: {
            DataHandler handler = this.getDataHandler();
            try {
                String type = this.dh.getContentType();
                ContentType contentType = new ContentType(type);
                String explicitType = this.getSingleHeader("Content-Type");
                if (contentType.match("multipart/*")) {
                    try {
                        MimeMultipart part = (MimeMultipart)handler.getContent();
                        part.updateHeaders();
                    }
                    catch (ClassCastException e) {
                        throw new MessagingException("Message content is not MimeMultipart", e);
                    }
                } else if (!contentType.match("message/rfc822")) {
                    if (this.getSingleHeader("Content-Transfer-Encoding") == null) {
                        this.setHeader("Content-Transfer-Encoding", MimeUtility.getEncoding(handler));
                    }
                    if (explicitType == null && SessionUtil.getBooleanProperty(MIME_SETDEFAULTTEXTCHARSET, true) && contentType.match("text/*") && contentType.getParameter("charset") == null) {
                        String encoding = this.getEncoding();
                        if (encoding != null && encoding.equalsIgnoreCase("7bit")) {
                            contentType.setParameter("charset", "us-ascii");
                        } else {
                            contentType.setParameter("charset", MimeUtility.getDefaultMIMECharset());
                        }
                        type = contentType.toString();
                    }
                }
                if (explicitType == null) {
                    ContentDisposition disposition;
                    String filename;
                    String disp = this.getHeader("Content-Disposition", null);
                    if (disp != null && (filename = (disposition = new ContentDisposition(disp)).getParameter("filename")) != null) {
                        contentType.setParameter("name", filename);
                        type = contentType.toString();
                    }
                    this.setHeader("Content-Type", type);
                }
                if (this.cachedContent == null) break block16;
                this.dh = new DataHandler(this.cachedContent, this.getContentType());
                this.cachedContent = null;
                this.content = null;
                if (this.contentStream != null) {
                    try {
                        this.contentStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.contentStream = null;
            }
            catch (IOException e) {
                throw new MessagingException("Error updating message headers", e);
            }
        }
    }

    private String getSingleHeader(String name) throws MessagingException {
        String[] values = this.getHeader(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void attachFile(File file) throws IOException, MessagingException {
        FileDataSource dataSource = new FileDataSource(file);
        this.setDataHandler(new DataHandler((DataSource)dataSource));
        this.setFileName(dataSource.getName());
        this.setDisposition("attachment");
    }

    public void attachFile(String file) throws IOException, MessagingException {
        this.attachFile(new File(file));
    }

    public void attachFile(File file, String contentType, String encoding) throws IOException, MessagingException {
        EncodingAwareFileDataSource dataSource = new EncodingAwareFileDataSource(file, contentType, encoding);
        this.setDataHandler(new DataHandler((DataSource)dataSource));
        this.setFileName(dataSource.getName());
        this.setDisposition("attachment");
    }

    public void attachFile(String file, String contentType, String encoding) throws IOException, MessagingException {
        this.attachFile(new File(file), contentType, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) throws IOException, MessagingException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        InputStream in = this.getInputStream();
        try {
            int length;
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
    }

    public void saveFile(String file) throws IOException, MessagingException {
        this.saveFile(new File(file));
    }

    private static class EncodingAwareFileDataSource
    extends FileDataSource
    implements EncodingAware {
        private final String contentType;
        private final String encoding;

        public EncodingAwareFileDataSource(File file, String contentType, String encoding) {
            super(file);
            this.contentType = contentType;
            this.encoding = encoding;
        }

        public String getContentType() {
            return this.contentType == null ? super.getContentType() : this.contentType;
        }

        @Override
        public String getEncoding() {
            return this.encoding;
        }
    }
}

