/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.internal;

import java.util.List;
import java.util.Set;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public final class XmlSuiteUtils {
    private XmlSuiteUtils() {
    }

    public static void validateIfSuitesContainDuplicateTests(List<XmlSuite> suites) {
        for (XmlSuite suite : suites) {
            XmlSuiteUtils.ensureNoDuplicateTestsArePresent(suite);
            XmlSuiteUtils.validateIfSuitesContainDuplicateTests(suite.getChildSuites());
        }
    }

    public static void adjustSuiteNamesToEnsureUniqueness(List<XmlSuite> suites) {
        XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(suites, Sets.newHashSet());
    }

    public static XmlSuite newXmlSuiteUsing(List<String> classes) {
        XmlSuite xmlSuite = new XmlSuite();
        xmlSuite.setVerbose(0);
        xmlSuite.setName("Jar suite");
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setXmlClasses(XmlSuiteUtils.constructXmlClassesUsing(classes));
        return xmlSuite;
    }

    static void ensureNoDuplicateTestsArePresent(XmlSuite xmlSuite) {
        Set testNames = Sets.newHashSet();
        for (XmlTest test : xmlSuite.getTests()) {
            if (testNames.add(test.getName())) continue;
            throw new TestNGException("Two tests in the same suite [" + xmlSuite.getName() + "] cannot have the same name: " + test.getName());
        }
    }

    private static List<XmlClass> constructXmlClassesUsing(List<String> classes) {
        List<XmlClass> xmlClasses = Lists.newLinkedList();
        for (String cls : classes) {
            XmlClass xmlClass = new XmlClass(cls);
            xmlClasses.add(xmlClass);
        }
        return xmlClasses;
    }

    private static void adjustSuiteNamesToEnsureUniqueness(List<XmlSuite> suites, Set<String> names) {
        for (XmlSuite suite : suites) {
            String name = suite.getName();
            int count = 0;
            String tmpName = name;
            while (names.contains(tmpName)) {
                tmpName = name + " (" + count++ + ")";
            }
            if (count > 0) {
                suite.setName(tmpName);
                names.add(tmpName);
            } else {
                names.add(name);
            }
            XmlSuiteUtils.adjustSuiteNamesToEnsureUniqueness(suite.getChildSuites(), names);
        }
    }
}

