/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git.model;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hop.git.model.UIGit;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.MessageBox;

public abstract class VCS {
    protected static final Class<?> PKG = UIGit.class;
    public static final String WORKINGTREE = "WORKINGTREE";
    public static final String INDEX = "INDEX";
    public static final String TYPE_TAG = "tag";
    public static final String TYPE_BRANCH = "branch";
    public static final String TYPE_COMMIT = "commit";
    protected String directory;

    @VisibleForTesting
    void showMessageBox(String title, String message) {
        MessageBox messageBox = new MessageBox(HopGui.getInstance().getShell(), 32);
        messageBox.setText(title);
        messageBox.setMessage(message == null ? "" : message);
        messageBox.open();
    }

    protected boolean promptUsernamePassword() {
        EnterStringDialog userDialog = new EnterStringDialog(HopGui.getInstance().getShell(), "", "Username?", "Enter the git username to use");
        String username = userDialog.open();
        if (username == null) {
            return false;
        }
        EnterStringDialog passDialog = new EnterStringDialog(HopGui.getInstance().getShell(), "", "Password?", "Enter the git password to use");
        passDialog.setEchoChar('*');
        String password = passDialog.open();
        if (password == null) {
            return false;
        }
        this.setCredential(username, password);
        return true;
    }

    public abstract void setCredential(String var1, String var2);
}

