/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.StateSnapshotContext;
import org.apache.flink.streaming.api.operators.util.SimpleVersionedListState;
import org.apache.flink.streaming.runtime.operators.sink.AbstractCommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterState;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterStateSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractStreamingCommitterHandler<InputT, CommT>
extends AbstractCommitterHandler<InputT, CommT, CommT> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStreamingCommitterHandler.class);
    private static final ListStateDescriptor<byte[]> STREAMING_COMMITTER_RAW_STATES_DESC = new ListStateDescriptor("streaming_committer_raw_states", (TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
    private final NavigableMap<Long, List<CommT>> committablesPerCheckpoint;
    private final StreamingCommitterStateSerializer<CommT> streamingCommitterStateSerializer;
    private ListState<StreamingCommitterState<CommT>> streamingCommitterState;

    abstract List<CommT> prepareCommit(List<InputT> var1) throws IOException;

    abstract List<CommT> commit(List<CommT> var1) throws IOException, InterruptedException;

    AbstractStreamingCommitterHandler(SimpleVersionedSerializer<CommT> committableSerializer) {
        this.streamingCommitterStateSerializer = new StreamingCommitterStateSerializer<CommT>(committableSerializer);
        this.committablesPerCheckpoint = new TreeMap<Long, List<CommT>>();
    }

    @Override
    protected void retry(List<CommT> recoveredCommittables) throws IOException, InterruptedException {
        this.recoveredCommittables(this.commit(recoveredCommittables));
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.streamingCommitterState = new SimpleVersionedListState<CommT>((ListState<byte[]>)context.getOperatorStateStore().getListState(STREAMING_COMMITTER_RAW_STATES_DESC), this.streamingCommitterStateSerializer);
        ArrayList restored = new ArrayList();
        ((Iterable)this.streamingCommitterState.get()).forEach(s -> restored.addAll(s.getCommittables()));
        this.recoveredCommittables(restored);
    }

    @Override
    public void snapshotState(StateSnapshotContext context) throws Exception {
        super.snapshotState(context);
        this.committablesPerCheckpoint.put(context.getCheckpointId(), this.prepareCommit(this.pollCommittables()));
        this.streamingCommitterState.update(Collections.singletonList(new StreamingCommitterState<CommT>(this.committablesPerCheckpoint)));
    }

    protected List<CommT> commitUpTo(long checkpointId) throws IOException, InterruptedException {
        List<Object> readyCommittables;
        NavigableMap<Long, List<CommT>> headMap = this.committablesPerCheckpoint.headMap(checkpointId, true);
        if (headMap.size() == 1) {
            readyCommittables = headMap.pollFirstEntry().getValue();
        } else {
            readyCommittables = new ArrayList();
            Iterator it = headMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                List committables = (List)entry.getValue();
                readyCommittables.addAll(committables);
                it.remove();
            }
        }
        LOG.info("Committing the state for checkpoint {}", (Object)checkpointId);
        this.recoveredCommittables(this.commit(readyCommittables));
        return readyCommittables;
    }

    @Override
    public void close() throws Exception {
        this.committablesPerCheckpoint.clear();
        super.close();
    }
}

