/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseFactory;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.database.SqlScriptStatement;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

public abstract class BaseDatabaseMeta
implements Cloneable,
IDatabase {
    public static final String ATTRIBUTE_SQL_CONNECT = "SQL_CONNECT";
    public static final String ATTRIBUTE_PREFIX_EXTRA_OPTION = "EXTRA_OPTION_";
    public static final String ATTRIBUTE_USE_RESULT_STREAMING = "STREAM_RESULTS";
    public static final String ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR = "MSSQL_DOUBLE_DECIMAL_SEPARATOR";
    public static final String ATTRIBUTE_QUOTE_ALL_FIELDS = "QUOTE_ALL_FIELDS";
    public static final String ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE = "FORCE_IDENTIFIERS_TO_LOWERCASE";
    public static final String ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE = "FORCE_IDENTIFIERS_TO_UPPERCASE";
    public static final String ATTRIBUTE_PREFERRED_SCHEMA_NAME = "PREFERRED_SCHEMA_NAME";
    public static final String ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE = "SUPPORTS_BOOLEAN_DATA_TYPE";
    public static final String ATTRIBUTE_SUPPORTS_TIMESTAMP_DATA_TYPE = "SUPPORTS_TIMESTAMP_DATA_TYPE";
    public static final String ATTRIBUTE_PRESERVE_RESERVED_WORD_CASE = "PRESERVE_RESERVED_WORD_CASE";
    public static final String SEQUENCE_FOR_BATCH_ID = "SEQUENCE_FOR_BATCH_ID";
    public static final String AUTOINCREMENT_SQL_FOR_BATCH_ID = "AUTOINCREMENT_SQL_FOR_BATCH_ID";
    public static final String ID_USERNAME_LABEL = "username-label";
    public static final String ID_USERNAME_WIDGET = "username-widget";
    public static final String ID_PASSWORD_LABEL = "password-label";
    public static final String ID_PASSWORD_WIDGET = "password-widget";
    protected boolean releaseSavepoint = true;
    public static final String SELECT_COUNT_STATEMENT = "select count(*) FROM";
    private static final String FIELDNAME_PROTECTOR = "_";
    @HopMetadataProperty
    protected int accessType;
    @HopMetadataProperty
    @GuiWidgetElement(id="hostname", order="01", label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.ServerHostname", type=GuiElementType.TEXT, variables=true, parentId="DatabaseMeta-PluginSpecific-Options")
    protected String hostname;
    @HopMetadataProperty
    @GuiWidgetElement(id="port", order="02", label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.PortNumber", type=GuiElementType.TEXT, variables=true, parentId="DatabaseMeta-PluginSpecific-Options")
    protected String port;
    @HopMetadataProperty
    @GuiWidgetElement(id="databaseName", order="03", label="i18n:org.apache.hop.ui.core.database:DatabaseDialog.label.DatabaseName", type=GuiElementType.TEXT, variables=true, parentId="DatabaseMeta-PluginSpecific-Options")
    protected String databaseName;
    @HopMetadataProperty
    protected String username;
    @HopMetadataProperty(password=true)
    protected String password;
    @HopMetadataProperty
    protected String manualUrl;
    @HopMetadataProperty
    protected String servername;
    @HopMetadataProperty
    protected String dataTablespace;
    @HopMetadataProperty
    protected String indexTablespace;
    private boolean changed = false;
    @HopMetadataProperty
    protected Map<String, String> attributes = Collections.synchronizedMap(new HashMap());
    @HopMetadataProperty
    protected String pluginId;
    @HopMetadataProperty
    protected String pluginName;

    public BaseDatabaseMeta() {
        if (this.getAccessTypeList() != null && this.getAccessTypeList().length > 0) {
            this.accessType = this.getAccessTypeList()[0];
        }
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Override
    public abstract int[] getAccessTypeList();

    @Override
    public int getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(int accessType) {
        this.accessType = accessType;
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public void setPort(String port) {
        this.port = port;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getServername() {
        return this.servername;
    }

    @Override
    public void setServername(String servername) {
        this.servername = servername;
    }

    @Override
    public String getDataTablespace() {
        return this.dataTablespace;
    }

    @Override
    public void setDataTablespace(String dataTablespace) {
        this.dataTablespace = dataTablespace;
    }

    @Override
    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    @Override
    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getManualUrl() {
        return this.manualUrl;
    }

    @Override
    public void setManualUrl(String manualUrl) {
        this.manualUrl = manualUrl;
    }

    @Override
    public Object clone() {
        BaseDatabaseMeta retval = null;
        try {
            retval = (BaseDatabaseMeta)super.clone();
            retval.attributes = Collections.synchronizedMap(new HashMap());
            for (String key : this.attributes.keySet()) {
                retval.attributes.put(key, this.attributes.get(key));
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    @Override
    public int getDefaultDatabasePort() {
        return -1;
    }

    @Override
    public Map<String, String> getDefaultOptions() {
        return Collections.emptyMap();
    }

    @Override
    public boolean isSupportsSetCharacterStream() {
        return true;
    }

    @Override
    public boolean isSupportsAutoInc() {
        return true;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return "";
    }

    @Override
    public int getNotFoundTK(boolean useAutoIncrement) {
        return 0;
    }

    @Override
    public String getSqlNextSequenceValue(String sequenceName) {
        return "";
    }

    @Override
    public String getSqlCurrentSequenceValue(String sequenceName) {
        return "";
    }

    @Override
    public String getSqlSequenceExists(String sequenceName) {
        return "";
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    @Override
    public boolean isNeedsPlaceHolder() {
        return false;
    }

    @Override
    public boolean isSupportsSchemas() {
        return true;
    }

    @Override
    public boolean isSupportsCatalogs() {
        return true;
    }

    @Override
    public boolean isSupportsEmptyTransactions() {
        return true;
    }

    @Override
    public String getFunctionSum() {
        return "SUM";
    }

    @Override
    public String getFunctionAverage() {
        return "AVG";
    }

    @Override
    public String getFunctionMinimum() {
        return "MIN";
    }

    @Override
    public String getFunctionMaximum() {
        return "MAX";
    }

    @Override
    public String getFunctionCount() {
        return "COUNT";
    }

    @Override
    public String getSchemaTableCombination(String schemaName, String tablePart) {
        return schemaName + "." + tablePart;
    }

    @Override
    public int getMaxTextFieldLength() {
        return 9999999;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 9999999;
    }

    @Override
    public boolean isSupportsTransactions() {
        return true;
    }

    @Override
    public boolean isSupportsSequences() {
        return false;
    }

    @Override
    public boolean isSupportsBitmapIndex() {
        return true;
    }

    @Override
    public boolean isSupportsSetLong() {
        return true;
    }

    @Override
    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoIncrement, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP " + v.getName() + Const.CR;
    }

    @Override
    public String[] getReservedWords() {
        return new String[0];
    }

    @Override
    public boolean isQuoteReservedWords() {
        return true;
    }

    @Override
    public String getStartQuote() {
        return "\"";
    }

    @Override
    public String getEndQuote() {
        return "\"";
    }

    @Override
    public String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    @Override
    public String[] getViewTypes() {
        return new String[]{"VIEW"};
    }

    @Override
    public String[] getSynonymTypes() {
        return new String[]{"SYNONYM"};
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return false;
    }

    @Override
    public boolean isSupportsViews() {
        return true;
    }

    @Override
    public boolean isSupportsSynonyms() {
        return false;
    }

    @Override
    public String getSqlListOfProcedures() {
        return null;
    }

    @Override
    public String getSqlListOfSequences() {
        return null;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    @Override
    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName;
    }

    @Override
    public boolean isSupportsFloatRoundingOnUpdate() {
        return true;
    }

    @Override
    public String getSqlLockTables(String[] tableNames) {
        return null;
    }

    @Override
    public String getSqlUnlockTables(String[] tableNames) {
        return null;
    }

    @Override
    public boolean isSupportsTimeStampToDateConversion() {
        return true;
    }

    @Override
    public boolean isSupportsBatchUpdates() {
        return true;
    }

    public String getAttributeProperty(String key, String defaultValue) {
        String value = this.attributes.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getAttributeProperty(String key) {
        return this.attributes.get(key);
    }

    @Override
    public boolean isSupportsBooleanDataType() {
        String supportsBooleanString = this.getAttributeProperty(ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE, "N");
        return "Y".equalsIgnoreCase(supportsBooleanString);
    }

    @Override
    public void setSupportsBooleanDataType(boolean b) {
        this.attributes.put(ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE, b ? "Y" : "N");
    }

    @Override
    public boolean isSupportsTimestampDataType() {
        String supportsTimestamp = this.getAttributeProperty(ATTRIBUTE_SUPPORTS_TIMESTAMP_DATA_TYPE, "N");
        return "Y".equalsIgnoreCase(supportsTimestamp);
    }

    @Override
    public void setSupportsTimestampDataType(boolean b) {
        this.attributes.put(ATTRIBUTE_SUPPORTS_TIMESTAMP_DATA_TYPE, b ? "Y" : "N");
    }

    @Override
    public boolean isPreserveReservedCase() {
        String usePool = this.getAttributeProperty(ATTRIBUTE_PRESERVE_RESERVED_WORD_CASE, "Y");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setPreserveReservedCase(boolean b) {
        this.attributes.put(ATTRIBUTE_PRESERVE_RESERVED_WORD_CASE, b ? "Y" : "N");
    }

    @Override
    public boolean isDefaultingToUppercase() {
        return true;
    }

    @Override
    public Map<String, String> getExtraOptions() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (String attribute : this.attributes.keySet()) {
            if (!attribute.startsWith(ATTRIBUTE_PREFIX_EXTRA_OPTION)) continue;
            String value = this.getAttributeProperty(attribute, "");
            map.put(attribute.substring(ATTRIBUTE_PREFIX_EXTRA_OPTION.length()), value);
        }
        return map;
    }

    @Override
    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.attributes.put(ATTRIBUTE_PREFIX_EXTRA_OPTION + databaseTypeCode + "." + option, value);
    }

    @Override
    public String getExtraOptionSeparator() {
        return ";";
    }

    @Override
    public String getExtraOptionValueSeparator() {
        return "=";
    }

    @Override
    public String getExtraOptionIndicator() {
        return ";";
    }

    @Override
    public boolean isSupportsOptionsInURL() {
        return true;
    }

    @Override
    public String getExtraOptionsHelpText() {
        return null;
    }

    @Override
    public boolean isSupportsGetBlob() {
        return true;
    }

    @Override
    public String getConnectSql() {
        return this.getAttributeProperty(ATTRIBUTE_SQL_CONNECT);
    }

    @Override
    public void setConnectSql(String sql) {
        this.attributes.put(ATTRIBUTE_SQL_CONNECT, sql);
    }

    @Override
    public boolean isSupportsSetMaxRows() {
        return true;
    }

    @Override
    public String getSqlTableExists(String tableName) {
        return "SELECT 1 FROM " + tableName;
    }

    @Override
    public String getSqlColumnExists(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName;
    }

    @Override
    public boolean isStreamingResults() {
        String usePool = this.getAttributeProperty(ATTRIBUTE_USE_RESULT_STREAMING, "Y");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setStreamingResults(boolean useStreaming) {
        this.attributes.put(ATTRIBUTE_USE_RESULT_STREAMING, useStreaming ? "Y" : "N");
    }

    @Override
    public boolean isQuoteAllFields() {
        String quoteAllFields = this.getAttributeProperty(ATTRIBUTE_QUOTE_ALL_FIELDS, "N");
        return "Y".equalsIgnoreCase(quoteAllFields);
    }

    @Override
    public void setQuoteAllFields(boolean quoteAllFields) {
        this.attributes.put(ATTRIBUTE_QUOTE_ALL_FIELDS, quoteAllFields ? "Y" : "N");
    }

    @Override
    public boolean isForcingIdentifiersToLowerCase() {
        String forceLowerCase = this.getAttributeProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE, "N");
        return "Y".equalsIgnoreCase(forceLowerCase);
    }

    @Override
    public void setForcingIdentifiersToLowerCase(boolean forceLowerCase) {
        this.attributes.put(ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE, forceLowerCase ? "Y" : "N");
    }

    @Override
    public boolean isForcingIdentifiersToUpperCase() {
        String forceUpperCase = this.getAttributeProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE, "N");
        return "Y".equalsIgnoreCase(forceUpperCase);
    }

    @Override
    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        this.attributes.put(ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE, forceUpperCase ? "Y" : "N");
    }

    @Override
    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        String usePool = this.getAttributeProperty(ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR, "N");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        this.attributes.put(ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR, useDoubleDecimalSeparator ? "Y" : "N");
    }

    @Override
    public boolean isRequiringTransactionsOnQueries() {
        return true;
    }

    @Override
    public boolean isStrictBigNumberInterpretation() {
        return false;
    }

    @Override
    public String getDatabaseFactoryName() {
        return DatabaseFactory.class.getName();
    }

    @Override
    public String getPreferredSchemaName() {
        return this.getAttributeProperty(ATTRIBUTE_PREFERRED_SCHEMA_NAME);
    }

    @Override
    public void setPreferredSchemaName(String preferredSchemaName) {
        this.attributes.put(ATTRIBUTE_PREFERRED_SCHEMA_NAME, preferredSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIndex(Database database, String schemaName, String tableName, String[] idxFields) throws HopDatabaseException {
        String schemaTable = database.getDatabaseMeta().getQuotedSchemaTableCombination(database, schemaName, tableName);
        boolean[] exists = new boolean[idxFields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            try (ResultSet indexList = null;){
                indexList = database.getDatabaseMetaData().getIndexInfo(null, null, schemaTable, false, true);
                while (indexList.next()) {
                    String column = indexList.getString("COLUMN_NAME");
                    int idx = Const.indexOfString(column, idxFields);
                    if (idx < 0) continue;
                    exists[idx] = true;
                }
            }
            boolean all = true;
            for (int i = 0; i < exists.length && all; ++i) {
                if (exists[i]) continue;
                all = false;
            }
            return all;
        }
        catch (Exception e) {
            throw new HopDatabaseException("Unable to determine if indexes exists on table [" + schemaTable + "]", e);
        }
    }

    @Override
    public boolean isSupportsSequenceNoMaxValueOption() {
        return false;
    }

    @Override
    public boolean isRequiresCreateTablePrimaryKeyAppend() {
        return false;
    }

    @Override
    public boolean isRequiresCastToVariousForIsNull() {
        return false;
    }

    @Override
    public boolean isDisplaySizeTwiceThePrecision() {
        return false;
    }

    @Override
    public boolean isSupportsPreparedStatementMetadataRetrieval() {
        return true;
    }

    @Override
    public boolean isSupportsResultSetMetadataRetrievalOnly() {
        return false;
    }

    @Override
    public boolean isSystemTable(String tableName) {
        return false;
    }

    @Override
    public boolean isSupportsNewLinesInSql() {
        return true;
    }

    @Override
    public String getSqlListOfSchemas() {
        return null;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public boolean IsSupportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    @Override
    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (0, 1)";
    }

    @Override
    public boolean isExplorable() {
        return true;
    }

    @Override
    public String quoteSqlString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "\\\\n");
        string = string.replaceAll("\\r", "\\\\r");
        return "'" + string + "'";
    }

    @Override
    public String getSelectCountStatement(String tableName) {
        return "select count(*) FROM " + tableName;
    }

    @Override
    public String generateColumnAlias(int columnIndex, String suggestedName) {
        return "COL" + Integer.toString(columnIndex);
    }

    @Override
    public List<String> parseStatements(String sqlScript) {
        List<SqlScriptStatement> scriptStatements = this.getSqlScriptStatements(sqlScript);
        ArrayList<String> statements = new ArrayList<String>();
        for (SqlScriptStatement scriptStatement : scriptStatements) {
            statements.add(scriptStatement.getStatement());
        }
        return statements;
    }

    @Override
    public List<SqlScriptStatement> getSqlScriptStatements(String sqlScript) {
        ArrayList<SqlScriptStatement> statements = new ArrayList<SqlScriptStatement>();
        String all = sqlScript;
        int from = 0;
        int to = 0;
        int length = all.length();
        while (to < length) {
            int nextBacktickIndex;
            int nextDQuoteIndex;
            char c = all.charAt(to);
            while (all.substring(from).startsWith("--")) {
                int nextLineIndex = all.indexOf(Const.CR, from);
                from = nextLineIndex + Const.CR.length();
                if (to >= length) break;
                c = all.charAt(c);
            }
            if (to >= length) break;
            if (c == '\"' && (nextDQuoteIndex = all.indexOf(34, to + 1)) >= 0) {
                to = nextDQuoteIndex + 1;
            }
            if (c == '`' && (nextBacktickIndex = all.indexOf(96, to + 1)) >= 0) {
                to = nextBacktickIndex + 1;
            }
            if ((c = all.charAt(to)) == '\'') {
                char prevChar;
                boolean skip = true;
                if (to > 0 && ((prevChar = all.charAt(to - 1)) == '\\' || prevChar == '\'')) {
                    skip = false;
                }
                while (skip) {
                    char prevChar2;
                    char nextChar;
                    int nextQuoteIndex = all.indexOf(39, to + 1);
                    if (nextQuoteIndex < 0) continue;
                    to = nextQuoteIndex + 1;
                    skip = false;
                    if (to < all.length() && (nextChar = all.charAt(to)) == '\'') {
                        skip = true;
                        ++to;
                    }
                    if (to <= 0 || (prevChar2 = all.charAt(to - 2)) != '\\') continue;
                    skip = true;
                    ++to;
                }
            }
            if ((c = all.charAt(to)) == ';' || to >= length - 1) {
                String stat;
                if (to >= length - 1) {
                    ++to;
                }
                if (!this.onlySpaces(stat = all.substring(from, to))) {
                    String s;
                    statements.add(new SqlScriptStatement(s, from, to, (s = Const.trim(stat)).toUpperCase().startsWith("SELECT") || s.toLowerCase().startsWith("show")));
                }
                from = ++to;
                continue;
            }
            ++to;
        }
        return statements;
    }

    protected boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMySqlVariant() {
        return false;
    }

    @Override
    public boolean isPostgresVariant() {
        return false;
    }

    @Override
    public boolean isTeradataVariant() {
        return false;
    }

    @Override
    public boolean isSybaseVariant() {
        return false;
    }

    @Override
    public boolean isSybaseIQVariant() {
        return false;
    }

    @Override
    public boolean isNeoviewVariant() {
        return false;
    }

    @Override
    public boolean isExasolVariant() {
        return false;
    }

    @Override
    public boolean isInformixVariant() {
        return false;
    }

    @Override
    public boolean isMsSqlServerNativeVariant() {
        return false;
    }

    @Override
    public boolean isMsSqlServerVariant() {
        return false;
    }

    @Override
    public boolean isOracleVariant() {
        return false;
    }

    @Override
    public boolean isNetezzaVariant() {
        return false;
    }

    @Override
    public boolean isSqliteVariant() {
        return false;
    }

    public boolean canTest() {
        return true;
    }

    @Override
    public boolean isRequiresName() {
        return true;
    }

    @Override
    public boolean isReleaseSavepoint() {
        return this.releaseSavepoint;
    }

    @Override
    public String getDataTablespaceDDL(IVariables variables, DatabaseMeta databaseMeta) {
        return this.getTablespaceDDL(variables, databaseMeta, databaseMeta.getIDatabase().getDataTablespace());
    }

    @Override
    public String getIndexTablespaceDDL(IVariables variables, DatabaseMeta databaseMeta) {
        return this.getTablespaceDDL(variables, databaseMeta, databaseMeta.getIDatabase().getIndexTablespace());
    }

    public String getTablespaceDDL(IVariables variables, DatabaseMeta databaseMeta, String tablespaceName) {
        return "";
    }

    @Override
    public Object getValueFromResultSet(ResultSet rs, IValueMeta val, int i) throws HopDatabaseException {
        return val.getValueFromResultSet(this, rs, i);
    }

    @Override
    public boolean isUseSafePoints() {
        return false;
    }

    @Override
    public boolean isSupportsErrorHandling() {
        return true;
    }

    @Override
    public String getSqlValue(IValueMeta valueMeta, Object valueData, String dateFormat) throws HopValueException {
        StringBuilder ins = new StringBuilder();
        if (valueMeta.isNull(valueData)) {
            ins.append("null");
        } else {
            switch (valueMeta.getType()) {
                case 2: 
                case 4: {
                    String string = valueMeta.getString(valueData);
                    string = this.quoteSqlString(string);
                    ins.append(string);
                    break;
                }
                case 3: {
                    Date date = valueMeta.getDate(valueData);
                    if (Utils.isEmpty(dateFormat)) {
                        ins.append("'" + valueMeta.getString(valueData) + "'");
                        break;
                    }
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                        ins.append("'" + formatter.format(date) + "'");
                        break;
                    }
                    catch (Exception e) {
                        throw new HopValueException("Error : ", e);
                    }
                }
                default: {
                    ins.append(valueMeta.getString(valueData));
                }
            }
        }
        return ins.toString();
    }

    protected String getFieldnameProtector() {
        return FIELDNAME_PROTECTOR;
    }

    @Override
    public String getSafeFieldname(String fieldname) {
        StringBuilder newName = new StringBuilder(((String)fieldname).length());
        char[] protectors = this.getFieldnameProtector().toCharArray();
        for (int idx = 0; idx < ((String)fieldname).length(); ++idx) {
            char c = ((String)fieldname).charAt(idx);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') {
                newName.append(c);
                continue;
            }
            if (c == ' ') {
                newName.append('_');
                continue;
            }
            for (char protector : protectors) {
                if (c != protector) continue;
                newName.append(c);
            }
        }
        fieldname = newName.toString();
        for (String reservedWord : this.getReservedWords()) {
            if (!((String)fieldname).equalsIgnoreCase(reservedWord)) continue;
            fieldname = (String)fieldname + this.getFieldnameProtector();
        }
        if (((String)(fieldname = ((String)fieldname).replace(" ", this.getFieldnameProtector()))).matches("^[0-9].*")) {
            fieldname = this.getFieldnameProtector() + (String)fieldname;
        }
        return fieldname;
    }

    @Override
    public String getSequenceNoMaxValueOption() {
        return "NOMAXVALUE";
    }

    @Override
    public boolean isSupportsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public IValueMeta customizeValueFromSqlType(IValueMeta v, ResultSetMetaData rm, int index) throws SQLException {
        return null;
    }

    @Override
    public String getCreateTableStatement() {
        return "CREATE TABLE ";
    }

    @Override
    public String getDropTableIfExistsStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    public boolean isFullExceptionLog(Exception e) {
        return true;
    }

    @Override
    public void addDefaultOptions() {
    }

    @Override
    public void addAttribute(String attributeId, String value) {
        this.attributes.put(attributeId, value);
    }

    @Override
    public String getAttribute(String attributeId, String defaultValue) {
        return this.getAttributeProperty(attributeId, defaultValue);
    }
}

