/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.runners.core.AutoValue_TimerInternals_TimerData;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateNamespaces;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ComparisonChain;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public interface TimerInternals {
    public void setTimer(StateNamespace var1, String var2, String var3, Instant var4, Instant var5, TimeDomain var6);

    @Deprecated
    public void setTimer(TimerData var1);

    public void deleteTimer(StateNamespace var1, String var2, String var3, TimeDomain var4);

    @Deprecated
    public void deleteTimer(StateNamespace var1, String var2, String var3);

    @Deprecated
    public void deleteTimer(TimerData var1);

    public Instant currentProcessingTime();

    public @Nullable Instant currentSynchronizedProcessingTime();

    public Instant currentInputWatermarkTime();

    public @Nullable Instant currentOutputWatermarkTime();

    public static class TimerDataCoder
    extends StructuredCoder<TimerData> {
        private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final InstantCoder INSTANT_CODER = InstantCoder.of();
        private final Coder<? extends BoundedWindow> windowCoder;

        public static TimerDataCoder of(Coder<? extends BoundedWindow> windowCoder) {
            return new TimerDataCoder(windowCoder);
        }

        private TimerDataCoder(Coder<? extends BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
        }

        public void encode(TimerData timer, OutputStream outStream) throws CoderException, IOException {
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
        }

        public TimerData decode(InputStream inStream) throws CoderException, IOException {
            String timerId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString(STRING_CODER.decode(inStream), this.windowCoder);
            Instant timestamp = INSTANT_CODER.decode(inStream);
            TimeDomain domain = TimeDomain.valueOf((String)STRING_CODER.decode(inStream));
            return TimerData.of(timerId, namespace, timestamp, timestamp, domain);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            TimerDataCoder.verifyDeterministic((Coder)this, (String)"window coder must be deterministic", (Coder[])new Coder[]{this.windowCoder});
        }
    }

    public static class TimerDataCoderV2
    extends StructuredCoder<TimerData> {
        private static final StringUtf8Coder STRING_CODER = StringUtf8Coder.of();
        private static final InstantCoder INSTANT_CODER = InstantCoder.of();
        private final Coder<? extends BoundedWindow> windowCoder;

        public static TimerDataCoderV2 of(Coder<? extends BoundedWindow> windowCoder) {
            return new TimerDataCoderV2(windowCoder);
        }

        private TimerDataCoderV2(Coder<? extends BoundedWindow> windowCoder) {
            this.windowCoder = windowCoder;
        }

        public void encode(TimerData timer, OutputStream outStream) throws CoderException, IOException {
            STRING_CODER.encode(timer.getTimerId(), outStream);
            STRING_CODER.encode(timer.getTimerFamilyId(), outStream);
            STRING_CODER.encode(timer.getNamespace().stringKey(), outStream);
            INSTANT_CODER.encode(timer.getTimestamp(), outStream);
            INSTANT_CODER.encode(timer.getOutputTimestamp(), outStream);
            STRING_CODER.encode(timer.getDomain().name(), outStream);
        }

        public TimerData decode(InputStream inStream) throws CoderException, IOException {
            String timerId = STRING_CODER.decode(inStream);
            String timerFamilyId = STRING_CODER.decode(inStream);
            StateNamespace namespace = StateNamespaces.fromString(STRING_CODER.decode(inStream), this.windowCoder);
            Instant timestamp = INSTANT_CODER.decode(inStream);
            Instant outputTimestamp = INSTANT_CODER.decode(inStream);
            TimeDomain domain = TimeDomain.valueOf((String)STRING_CODER.decode(inStream));
            return TimerData.of(timerId, timerFamilyId, namespace, timestamp, outputTimestamp, domain);
        }

        public List<? extends Coder<?>> getCoderArguments() {
            return Arrays.asList(this.windowCoder);
        }

        public void verifyDeterministic() throws Coder.NonDeterministicException {
            TimerDataCoderV2.verifyDeterministic((Coder)this, (String)"window coder must be deterministic", (Coder[])new Coder[]{this.windowCoder});
        }
    }

    @AutoValue
    public static abstract class TimerData
    implements Comparable<TimerData> {
        public abstract String getTimerId();

        public abstract String getTimerFamilyId();

        public abstract StateNamespace getNamespace();

        public abstract Instant getTimestamp();

        public abstract Instant getOutputTimestamp();

        public abstract TimeDomain getDomain();

        public abstract boolean getDeleted();

        public static TimerData of(String timerId, StateNamespace namespace, Instant timestamp, Instant outputTimestamp, TimeDomain domain) {
            return new AutoValue_TimerInternals_TimerData(timerId, "", namespace, timestamp, outputTimestamp, domain, false);
        }

        public static TimerData of(String timerId, String timerFamilyId, StateNamespace namespace, Instant timestamp, Instant outputTimestamp, TimeDomain domain) {
            return new AutoValue_TimerInternals_TimerData(timerId, timerFamilyId, namespace, timestamp, outputTimestamp, domain, false);
        }

        public static TimerData of(StateNamespace namespace, Instant timestamp, Instant outputTimestamp, TimeDomain domain) {
            String timerId = "" + domain.ordinal() + ':' + timestamp.getMillis();
            return TimerData.of(timerId, namespace, timestamp, outputTimestamp, domain);
        }

        public TimerData deleted() {
            return new AutoValue_TimerInternals_TimerData(this.getTimerId(), this.getTimerFamilyId(), this.getNamespace(), this.getTimestamp(), this.getOutputTimestamp(), this.getDomain(), true);
        }

        @Override
        public int compareTo(TimerData that) {
            if (this.equals(that)) {
                return 0;
            }
            ComparisonChain chain = ComparisonChain.start().compare(Boolean.valueOf(this.getDeleted()), Boolean.valueOf(that.getDeleted())).compare((Comparable)this.getTimestamp(), (Comparable)that.getTimestamp()).compare((Comparable)this.getOutputTimestamp(), (Comparable)that.getOutputTimestamp()).compare((Comparable)this.getDomain(), (Comparable)that.getDomain()).compare((Comparable)((Object)this.getTimerId()), (Comparable)((Object)that.getTimerId())).compare((Comparable)((Object)this.getTimerFamilyId()), (Comparable)((Object)that.getTimerFamilyId()));
            if (chain.result() == 0 && !this.getNamespace().equals(that.getNamespace())) {
                chain = chain.compare((Comparable)((Object)this.getNamespace().stringKey()), (Comparable)((Object)that.getNamespace().stringKey()));
            }
            return chain.result();
        }
    }
}

