/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertiesSearchQuery;
import com.dropbox.core.v2.fileproperties.TemplateFilter;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class PropertiesSearchArg {
    protected final List<PropertiesSearchQuery> queries;
    protected final TemplateFilter templateFilter;

    public PropertiesSearchArg(List<PropertiesSearchQuery> queries, TemplateFilter templateFilter) {
        if (queries == null) {
            throw new IllegalArgumentException("Required value for 'queries' is null");
        }
        if (queries.size() < 1) {
            throw new IllegalArgumentException("List 'queries' has fewer than 1 items");
        }
        for (PropertiesSearchQuery x : queries) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'queries' is null");
        }
        this.queries = queries;
        if (templateFilter == null) {
            throw new IllegalArgumentException("Required value for 'templateFilter' is null");
        }
        this.templateFilter = templateFilter;
    }

    public PropertiesSearchArg(List<PropertiesSearchQuery> queries) {
        this(queries, TemplateFilter.FILTER_NONE);
    }

    public List<PropertiesSearchQuery> getQueries() {
        return this.queries;
    }

    public TemplateFilter getTemplateFilter() {
        return this.templateFilter;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.queries, this.templateFilter});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PropertiesSearchArg other = (PropertiesSearchArg)obj;
            return !(this.queries != other.queries && !this.queries.equals(other.queries) || this.templateFilter != other.templateFilter && !this.templateFilter.equals(other.templateFilter));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PropertiesSearchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PropertiesSearchArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("queries");
            StoneSerializers.list(PropertiesSearchQuery.Serializer.INSTANCE).serialize(value.queries, g);
            g.writeFieldName("template_filter");
            TemplateFilter.Serializer.INSTANCE.serialize(value.templateFilter, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PropertiesSearchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            TemplateFilter f_templateFilter;
            List<PropertiesSearchQuery> f_queries;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_queries = null;
                f_templateFilter = TemplateFilter.FILTER_NONE;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("queries".equals(field)) {
                        f_queries = StoneSerializers.list(PropertiesSearchQuery.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("template_filter".equals(field)) {
                        f_templateFilter = TemplateFilter.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_queries == null) {
                    throw new JsonParseException(p, "Required field \"queries\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PropertiesSearchArg value = new PropertiesSearchArg(f_queries, f_templateFilter);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

