/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.fileproperties.TemplateError;
import com.dropbox.core.v2.files.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class ListFolderError {
    public static final ListFolderError OTHER = new ListFolderError().withTag(Tag.OTHER);
    private Tag _tag;
    private LookupError pathValue;
    private TemplateError templateErrorValue;

    private ListFolderError() {
    }

    private ListFolderError withTag(Tag _tag) {
        ListFolderError result = new ListFolderError();
        result._tag = _tag;
        return result;
    }

    private ListFolderError withTagAndPath(Tag _tag, LookupError pathValue) {
        ListFolderError result = new ListFolderError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private ListFolderError withTagAndTemplateError(Tag _tag, TemplateError templateErrorValue) {
        ListFolderError result = new ListFolderError();
        result._tag = _tag;
        result.templateErrorValue = templateErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static ListFolderError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListFolderError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isTemplateError() {
        return this._tag == Tag.TEMPLATE_ERROR;
    }

    public static ListFolderError templateError(TemplateError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListFolderError().withTagAndTemplateError(Tag.TEMPLATE_ERROR, value);
    }

    public TemplateError getTemplateErrorValue() {
        if (this._tag != Tag.TEMPLATE_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.TEMPLATE_ERROR, but was Tag." + this._tag.name());
        }
        return this.templateErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue, this.templateErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ListFolderError) {
            ListFolderError other = (ListFolderError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case TEMPLATE_ERROR: {
                    return this.templateErrorValue == other.templateErrorValue || this.templateErrorValue.equals(other.templateErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<ListFolderError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFolderError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g.writeStartObject();
                    this.writeTag("path", g);
                    g.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g);
                    g.writeEndObject();
                    break;
                }
                case TEMPLATE_ERROR: {
                    g.writeStartObject();
                    this.writeTag("template_error", g);
                    g.writeFieldName("template_error");
                    TemplateError.Serializer.INSTANCE.serialize(value.templateErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public ListFolderError deserialize(JsonParser p) throws IOException, JsonParseException {
            ListFolderError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = ListFolderError.path(fieldValue);
            } else if ("template_error".equals(tag)) {
                TemplateError fieldValue = null;
                Serializer.expectField("template_error", p);
                fieldValue = TemplateError.Serializer.INSTANCE.deserialize(p);
                value = ListFolderError.templateError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        TEMPLATE_ERROR,
        OTHER;

    }
}

