/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.numberrange;

import java.util.LinkedList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.numberrange.NumberRange;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeData;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeRule;
import org.w3c.dom.Node;

@Transform(id="NumberRange", image="numberrange.svg", name="i18n::BaseTransform.TypeLongDesc.NumberRange", description="i18n::BaseTransform.TypeTooltipDesc.NumberRange", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::NumberRangeMeta.keyword"}, documentationUrl="/pipeline/transforms/numberrange.html")
public class NumberRangeMeta
extends BaseTransformMeta<NumberRange, NumberRangeData> {
    private String inputField;
    private String outputField;
    private String fallBackValue;
    private List<NumberRangeRule> rules;

    public NumberRangeMeta() {
    }

    public void emptyRules() {
        this.rules = new LinkedList<NumberRangeRule>();
    }

    public NumberRangeMeta(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.loadXml(transformNode, metadataProvider);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)"inputField", (String)this.inputField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"outputField", (String)this.outputField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"fallBackValue", (String)this.getFallBackValue()));
        retval.append("    <rules>").append(Const.CR);
        for (NumberRangeRule rule : this.rules) {
            retval.append("      <rule>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"lower_bound", (double)rule.getLowerBound()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"upper_bound", (double)rule.getUpperBound()));
            retval.append("        ").append(XmlHandler.addTagValue((String)"value", (String)rule.getValue()));
            retval.append("      </rule>").append(Const.CR);
        }
        retval.append("    </rules>").append(Const.CR);
        return retval.toString();
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString mcValue = new ValueMetaString(this.outputField);
        mcValue.setOrigin(name);
        mcValue.setLength(255);
        row.addValueMeta((IValueMeta)mcValue);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.inputField = XmlHandler.getTagValue((Node)transformNode, (String)"inputField");
            this.outputField = XmlHandler.getTagValue((Node)transformNode, (String)"outputField");
            this.emptyRules();
            String fallBackValue = XmlHandler.getTagValue((Node)transformNode, (String)"fallBackValue");
            this.setFallBackValue(fallBackValue);
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"rules");
            int count = XmlHandler.countNodes((Node)fields, (String)"rule");
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"rule", (int)i);
                String lowerBoundStr = XmlHandler.getTagValue((Node)fnode, (String)"lower_bound");
                String upperBoundStr = XmlHandler.getTagValue((Node)fnode, (String)"upper_bound");
                String value = XmlHandler.getTagValue((Node)fnode, (String)"value");
                double lowerBound = Double.parseDouble(lowerBoundStr);
                double upperBound = Double.parseDouble(upperBoundStr);
                this.addRule(lowerBound, upperBound, value);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read transform info from XML node", (Throwable)e);
        }
    }

    public void setDefault() {
        this.emptyRules();
        this.setFallBackValue("unknown");
        this.addRule(-1.7976931348623157E308, 5.0, "Less than 5");
        this.addRule(5.0, 10.0, "5-10");
        this.addRule(10.0, Double.MAX_VALUE, "More than 10");
        this.inputField = "";
        this.outputField = "range";
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous transforms!", (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transforms.", (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transforms!", (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getInputField() {
        return this.inputField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public List<NumberRangeRule> getRules() {
        return this.rules;
    }

    public String getFallBackValue() {
        return this.fallBackValue;
    }

    public void setInputField(String inputField) {
        this.inputField = inputField;
    }

    public void setFallBackValue(String fallBackValue) {
        this.fallBackValue = fallBackValue;
    }

    public void addRule(double lowerBound, double upperBound, String value) {
        NumberRangeRule rule = new NumberRangeRule(lowerBound, upperBound, value);
        this.rules.add(rule);
    }

    public void setRules(List<NumberRangeRule> rules) {
        this.rules = rules;
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

