/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.Objects;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

public class PeriodicSequence
extends PTransform<PCollection<SequenceDefinition>, PCollection<Instant>> {
    private PeriodicSequence() {
    }

    public static PeriodicSequence create() {
        return new PeriodicSequence();
    }

    @Override
    public PCollection<Instant> expand(PCollection<SequenceDefinition> input) {
        return (PCollection)input.apply(ParDo.of(new PeriodicSequenceFn()));
    }

    private static class PeriodicSequenceFn
    extends DoFn<SequenceDefinition, Instant> {
        private PeriodicSequenceFn() {
        }

        @DoFn.GetInitialRestriction
        public OffsetRange getInitialRange(@DoFn.Element SequenceDefinition element) {
            return new OffsetRange(element.first.getMillis() - element.durationMilliSec, element.last.getMillis());
        }

        @DoFn.NewTracker
        public RestrictionTracker<OffsetRange, Long> newTracker(@DoFn.Restriction OffsetRange restriction) {
            return new OutputRangeTracker(restriction);
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(@DoFn.Element SequenceDefinition srcElement, DoFn.OutputReceiver<Instant> out, RestrictionTracker<OffsetRange, Long> restrictionTracker) {
            OffsetRange restriction = restrictionTracker.currentRestriction();
            Long interval = srcElement.durationMilliSec;
            Long nextOutput = restriction.getFrom() + interval;
            boolean claimSuccess = true;
            while (claimSuccess && Instant.ofEpochMilli((long)nextOutput).isBeforeNow()) {
                claimSuccess = restrictionTracker.tryClaim(nextOutput);
                if (!claimSuccess) continue;
                Instant output = Instant.ofEpochMilli((long)nextOutput);
                out.outputWithTimestamp(output, output);
                nextOutput = nextOutput + interval;
            }
            DoFn.ProcessContinuation continuation = DoFn.ProcessContinuation.stop();
            if (claimSuccess) {
                Duration offset = new Duration((ReadableInstant)Instant.now(), (ReadableInstant)Instant.ofEpochMilli((long)nextOutput));
                continuation = DoFn.ProcessContinuation.resume().withResumeDelay(offset);
            }
            return continuation;
        }
    }

    public static class OutputRangeTracker
    extends RestrictionTracker<OffsetRange, Long>
    implements RestrictionTracker.HasProgress {
        private OffsetRange range;
        private @Nullable Long lastClaimedOffset = null;
        private @Nullable Long lastAttemptedOffset = null;

        public OutputRangeTracker(OffsetRange range) {
            this.range = (OffsetRange)Preconditions.checkNotNull((Object)range);
            this.lastAttemptedOffset = this.lastClaimedOffset = Long.valueOf(this.range.getFrom());
        }

        @Override
        public OffsetRange currentRestriction() {
            return this.range;
        }

        @Override
        public SplitResult<OffsetRange> trySplit(double fractionOfRemainder) {
            if (fractionOfRemainder != 0.0) {
                return null;
            }
            OffsetRange res = new OffsetRange(this.lastClaimedOffset, this.range.getTo());
            this.range = new OffsetRange(this.range.getFrom(), this.lastClaimedOffset);
            return SplitResult.of(this.range, res);
        }

        @Override
        public boolean tryClaim(Long i) {
            Preconditions.checkArgument((i > this.lastAttemptedOffset ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (Object)i, (Object)this.lastAttemptedOffset);
            Preconditions.checkArgument((i >= this.range.getFrom() ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (Object)i, (Object)this.range);
            this.lastAttemptedOffset = i;
            if (i > this.range.getTo()) {
                return false;
            }
            this.lastClaimedOffset = i;
            return true;
        }

        @Override
        public void checkDone() throws IllegalStateException {
            Preconditions.checkState((this.lastAttemptedOffset >= this.range.getTo() - 1L ? 1 : 0) != 0, (String)"Last attempted offset was %s in range %s, claiming work in (%s, %s] was not attempted", (Object)this.lastAttemptedOffset, (Object)this.range, (Object)this.lastAttemptedOffset, (Object)this.range.getTo());
        }

        @Override
        public RestrictionTracker.IsBounded isBounded() {
            return RestrictionTracker.IsBounded.BOUNDED;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("range", (Object)this.range).add("lastClaimedOffset", (Object)this.lastClaimedOffset).add("lastAttemptedOffset", (Object)this.lastAttemptedOffset).toString();
        }

        @Override
        public RestrictionTracker.Progress getProgress() {
            double workRemaining = Math.max(this.range.getTo() - this.lastAttemptedOffset, 0L);
            return RestrictionTracker.Progress.from((double)(this.range.getTo() - this.range.getFrom()) - workRemaining, workRemaining);
        }
    }

    @DefaultSchema(value=JavaFieldSchema.class)
    public static class SequenceDefinition {
        public Instant first;
        public Instant last;
        public Long durationMilliSec;

        public SequenceDefinition() {
        }

        public SequenceDefinition(Instant first, Instant last, Duration duration) {
            this.first = first;
            this.last = last;
            this.durationMilliSec = duration.getMillis();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SequenceDefinition src = (SequenceDefinition)obj;
            return src.first.equals((Object)this.first) && src.last.equals((Object)this.last) && src.durationMilliSec.equals(this.durationMilliSec);
        }

        public int hashCode() {
            int result = Objects.hash(this.first, this.last, this.durationMilliSec);
            return result;
        }
    }
}

