/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental
public class ToJson<T>
extends PTransform<PCollection<T>, PCollection<String>> {
    private volatile transient @Nullable ObjectMapper objectMapper;

    private ToJson() {
    }

    public static <T> ToJson<T> of() {
        return new ToJson<T>();
    }

    @Override
    public PCollection<String> expand(PCollection<T> rows) {
        final Schema inputSchema = rows.getSchema();
        RowJson.verifySchemaSupported(inputSchema);
        final SerializableFunction<T, Row> toRow = rows.getToRowFunction();
        return (PCollection)rows.apply(ParDo.of(new DoFn<T, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) {
                context.output(RowJsonUtils.rowToJson(ToJson.this.objectMapper(inputSchema), (Row)toRow.apply(context.element())));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectMapper objectMapper(Schema schema) {
        if (this.objectMapper == null) {
            ToJson toJson = this;
            synchronized (toJson) {
                if (this.objectMapper == null) {
                    this.objectMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonSerializer.forSchema(schema));
                }
            }
        }
        return this.objectMapper;
    }
}

