/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.action;

import org.apache.hop.core.logging.LogLevel;

public class ActionDebugLevel
implements Cloneable {
    private LogLevel logLevel = LogLevel.DEBUG;
    private boolean loggingResult = false;
    private boolean loggingVariables = false;
    private boolean loggingResultRows = false;
    private boolean loggingResultFiles = false;

    public ActionDebugLevel() {
    }

    public ActionDebugLevel(LogLevel logLevel) {
        this();
        this.logLevel = logLevel;
    }

    public ActionDebugLevel(LogLevel logLevel, boolean loggingResult, boolean loggingVariables, boolean loggingResultRows, boolean loggingResultFiles) {
        this(logLevel);
        this.loggingResult = loggingResult;
        this.loggingVariables = loggingVariables;
        this.loggingResultRows = loggingResultRows;
        this.loggingResultFiles = loggingResultFiles;
    }

    public ActionDebugLevel clone() {
        return new ActionDebugLevel(this.logLevel, this.loggingResult, this.loggingVariables, this.loggingResultRows, this.loggingResultFiles);
    }

    public String toString() {
        Object s = this.logLevel.toString();
        if (this.loggingResult) {
            s = (String)s + ", logging result";
        }
        if (this.loggingVariables) {
            s = (String)s + ", logging variables";
        }
        if (this.loggingResultRows) {
            s = (String)s + ", logging result rows";
        }
        if (this.loggingResultFiles) {
            s = (String)s + ", logging result files";
        }
        return s;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isLoggingResult() {
        return this.loggingResult;
    }

    public void setLoggingResult(boolean loggingResult) {
        this.loggingResult = loggingResult;
    }

    public boolean isLoggingVariables() {
        return this.loggingVariables;
    }

    public void setLoggingVariables(boolean loggingVariables) {
        this.loggingVariables = loggingVariables;
    }

    public boolean isLoggingResultRows() {
        return this.loggingResultRows;
    }

    public void setLoggingResultRows(boolean loggingResultRows) {
        this.loggingResultRows = loggingResultRows;
    }

    public boolean isLoggingResultFiles() {
        return this.loggingResultFiles;
    }

    public void setLoggingResultFiles(boolean loggingResultFiles) {
        this.loggingResultFiles = loggingResultFiles;
    }
}

