/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.parquet.transforms.input.ParquetInputData;
import org.apache.hop.parquet.transforms.input.ParquetInputMeta;
import org.apache.hop.parquet.transforms.input.ParquetReadSupport;
import org.apache.hop.parquet.transforms.input.ParquetReaderBuilder;
import org.apache.hop.parquet.transforms.input.ParquetStream;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.parquet.hadoop.ParquetReader;

public class ParquetInput
extends BaseTransform<ParquetInputMeta, ParquetInputData> {
    public ParquetInput(TransformMeta transformMeta, ParquetInputMeta meta, ParquetInputData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ParquetInputData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((ParquetInputMeta)this.meta).getFields(((ParquetInputData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((ParquetInputData)this.data).filenameFieldIndex = this.getInputRowMeta().indexOfValue(this.resolve(((ParquetInputMeta)this.meta).getFilenameField()));
            if (((ParquetInputData)this.data).filenameFieldIndex < 0) {
                throw new HopException("Unable to find filename field " + ((ParquetInputMeta)this.meta).getFilenameField() + " in the input");
            }
        }
        if (this.getInputRowMeta().isNull(row, ((ParquetInputData)this.data).filenameFieldIndex)) {
            return true;
        }
        String filename = this.getInputRowMeta().getString(row, ((ParquetInputData)this.data).filenameFieldIndex);
        FileObject fileObject = HopVfs.getFileObject((String)filename);
        try {
            long size = fileObject.getContent().getSize();
            InputStream inputStream = HopVfs.getInputStream((FileObject)fileObject);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream((int)size);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            ParquetStream inputFile = new ParquetStream(outputStream.toByteArray(), filename);
            ParquetReadSupport readSupport = new ParquetReadSupport(((ParquetInputMeta)this.meta).getFields());
            ParquetReader reader = new ParquetReaderBuilder<RowMetaAndData>(readSupport, inputFile).build();
            RowMetaAndData r = (RowMetaAndData)reader.read();
            while (r != null && !this.isStopped()) {
                Object[] outputRow = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])r.getData());
                this.putRow(((ParquetInputData)this.data).outputRowMeta, outputRow);
                r = (RowMetaAndData)reader.read();
            }
        }
        catch (Exception e) {
            throw new HopException("Error read file " + filename, (Throwable)e);
        }
        return true;
    }
}

