/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.cassandra.datastax;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.schemabuilder.CreateKeyspace;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.extras.codecs.MappingCodec;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.util.Utils;
import org.apache.hop.databases.cassandra.datastax.DriverKeyspace;
import org.apache.hop.databases.cassandra.spi.Connection;
import org.apache.hop.databases.cassandra.spi.Keyspace;

public class DriverConnection
implements Connection,
AutoCloseable {
    private String host;
    private int port = 9042;
    private String username;
    private String password;
    private Map<String, String> opts = new HashMap<String, String>();
    private Cluster cluster;
    private boolean useCompression;
    private Session session;
    private Map<String, Session> sessions = new HashMap<String, Session>();
    private boolean expandCollection = true;

    public DriverConnection() {
    }

    public DriverConnection(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void setHosts(String hosts) {
        this.host = hosts;
    }

    @Override
    public void setDefaultPort(int port) {
        this.port = port;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setAdditionalOptions(Map<String, String> opts) {
        this.opts = opts;
        if (opts.containsKey("compression")) {
            this.setUseCompression(true);
        }
    }

    @Override
    public Map<String, String> getAdditionalOptions() {
        return this.opts;
    }

    @Override
    public Session openConnection() throws Exception {
        this.session = this.getCluster().connect();
        return this.session;
    }

    @Override
    public void closeConnection() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
        this.sessions.forEach((name, session) -> session.close());
        this.sessions.clear();
        if (this.cluster != null) {
            this.cluster.closeAsync();
            this.cluster = null;
        }
    }

    public Session getUnderlyingSession() {
        return this.session;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public Cluster getCluster() {
        if (this.cluster == null) {
            Cluster.Builder builder = Cluster.builder().addContactPointsWithPorts(this.getAddresses());
            if (!Utils.isEmpty((CharSequence)this.username)) {
                builder = builder.withCredentials(this.username, this.password);
            }
            if (this.opts.containsKey("socketTimeout")) {
                int timeoutMs = Integer.parseUnsignedInt(this.opts.get("socketTimeout").trim());
                builder.withSocketOptions(new SocketOptions().setConnectTimeoutMillis(timeoutMs));
            }
            builder.withCompression(this.useCompression ? ProtocolOptions.Compression.LZ4 : ProtocolOptions.Compression.NONE);
            this.cluster = builder.build();
            this.registerCodecs(this.cluster.getConfiguration().getCodecRegistry());
        }
        return this.cluster;
    }

    public Session getSession(String keyspace) {
        return this.sessions.computeIfAbsent(keyspace, ks -> this.getCluster().connect(ks));
    }

    @Override
    public Keyspace getKeyspace(String keyspaceName) throws Exception {
        KeyspaceMetadata keyspace = this.getCluster().getMetadata().getKeyspace(keyspaceName);
        if (keyspace == null) {
            throw new Exception("Unable to find keyspace '" + keyspaceName + "'");
        }
        return new DriverKeyspace(this, keyspace);
    }

    @Override
    public String[] getKeyspaceNames() throws Exception {
        List keyspaceList = this.getCluster().getMetadata().getKeyspaces();
        String[] names = new String[keyspaceList.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((KeyspaceMetadata)keyspaceList.get(i)).getName();
        }
        return names;
    }

    @Override
    public void createKeyspace(String keyspaceName, boolean ifNotExists, Map<String, Object> createOptions) throws Exception {
        CreateKeyspace create = SchemaBuilder.createKeyspace((String)keyspaceName).ifNotExists();
        create.with().replication(createOptions);
    }

    public ResultSet executeCql(String query, Map<String, Object> values) throws Exception {
        Session session = this.cluster.connect();
        return session.execute(query, values);
    }

    @Override
    public void close() throws Exception {
        this.closeConnection();
    }

    public boolean isExpandCollection() {
        return this.expandCollection;
    }

    public InetSocketAddress[] getAddresses() {
        if (!this.host.contains(",") && !this.host.contains(":")) {
            return new InetSocketAddress[]{new InetSocketAddress(this.host, this.port)};
        }
        String[] hostsStrings = StringUtils.split((String)this.host, (String)",");
        InetSocketAddress[] hosts = new InetSocketAddress[hostsStrings.length];
        for (int i = 0; i < hosts.length; ++i) {
            String[] hostPair = StringUtils.split((String)hostsStrings[i], (String)":");
            String hostName = hostPair[0].trim();
            int port = this.port;
            if (hostPair.length > 1) {
                try {
                    port = Integer.parseInt(hostPair[1].trim());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            hosts[i] = new InetSocketAddress(hostName, port);
        }
        return hosts;
    }

    private void registerCodecs(CodecRegistry registry) {
        registry.register((TypeCodec)new MappingCodec<Long, Integer>((TypeCodec)TypeCodec.cint(), Long.class){

            protected Long deserialize(Integer value) {
                return value == null ? null : Long.valueOf(value.longValue());
            }

            protected Integer serialize(Long value) {
                return value == null ? null : Integer.valueOf(value.intValue());
            }
        });
        registry.register((TypeCodec)new MappingCodec<Double, Float>((TypeCodec)TypeCodec.cfloat(), Double.class){

            protected Double deserialize(Float value) {
                return value == null ? null : Double.valueOf(value.doubleValue());
            }

            protected Float serialize(Double value) {
                return value == null ? null : Float.valueOf(value.floatValue());
            }
        });
    }
}

