/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.coalesce;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class CoalesceField
implements Cloneable {
    @HopMetadataProperty(key="name", injectionKey="NAME", injectionKeyDescription="CoalesceMeta.Injection.Field.Name")
    private String name;
    @HopMetadataProperty(key="type", injectionKey="TYPE", injectionKeyDescription="CoalesceMeta.Injection.Field.Type")
    private String type = ValueMetaFactory.getValueMetaName((int)0);
    @HopMetadataProperty(key="remove", injectionKey="REMOVE_INPUT_FIELDS", injectionKeyDescription="CoalesceMeta.Injection.Field.Remove")
    private boolean removeFields;
    @HopMetadataProperty(key="input", injectionKey="INPUT_FIELDS", injectionKeyDescription="CoalesceMeta.Injection.Field.InputFields")
    private String inputFields;
    private List<String> cache = new ArrayList<String>();

    public CoalesceField() {
    }

    public CoalesceField(String name, String type, boolean removeFields, String inputFields, List<String> cache) {
        this.name = name;
        this.type = type;
        this.removeFields = removeFields;
        this.inputFields = inputFields;
        this.cache = cache;
    }

    public CoalesceField(CoalesceField cloned) {
        this.name = cloned.name;
        this.type = cloned.type;
        this.removeFields = cloned.removeFields;
        this.setInputFields(cloned.inputFields);
    }

    public Object clone() {
        return new CoalesceField(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.stripToNull((String)name);
    }

    public String getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(String fields) {
        this.inputFields = fields;
        this.cache = new ArrayList<String>();
        if (this.inputFields != null) {
            for (String field : this.inputFields.split("\\s*,\\s*")) {
                this.cache.add(field);
            }
        }
    }

    public List<String> getInputFieldNames() {
        return this.cache;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isRemoveFields() {
        return this.removeFields;
    }

    public void setRemoveFields(boolean remove) {
        this.removeFields = remove;
    }

    public String toString() {
        return this.name + ":" + this.type;
    }
}

