/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.stub.metrics.HeaderTracer;
import com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.common.base.Preconditions;
import io.grpc.Metadata;
import javax.annotation.Nonnull;

@InternalApi
public class HeaderTracerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;
    private final HeaderTracer headerTracer;
    private final String spanName;

    public HeaderTracerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> callable, @Nonnull HeaderTracer headerTracer, @Nonnull String spanName) {
        this.innerCallable = (ServerStreamingCallable)Preconditions.checkNotNull(callable, (Object)"Inner callable must be set");
        this.headerTracer = (HeaderTracer)Preconditions.checkNotNull((Object)headerTracer, (Object)"HeaderTracer must be set");
        this.spanName = (String)Preconditions.checkNotNull((Object)spanName, (Object)"Span name must be set");
    }

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
        if (RpcViews.isGfeMetricsRegistered()) {
            HeaderTracerResponseObserver<ResponseT> innerObserver = new HeaderTracerResponseObserver<ResponseT>(responseObserver, this.headerTracer, responseMetadata, this.spanName);
            this.innerCallable.call(request, innerObserver, (ApiCallContext)responseMetadata.addHandlers(context));
        } else {
            this.innerCallable.call(request, responseObserver, context);
        }
    }

    private class HeaderTracerResponseObserver<ResponseT>
    implements ResponseObserver<ResponseT> {
        private ResponseObserver<ResponseT> outerObserver;
        private HeaderTracer headerTracer;
        private GrpcResponseMetadata responseMetadata;
        private String spanName;

        HeaderTracerResponseObserver(ResponseObserver<ResponseT> observer, HeaderTracer headerTracer, GrpcResponseMetadata metadata, String spanName) {
            this.outerObserver = observer;
            this.headerTracer = headerTracer;
            this.responseMetadata = metadata;
            this.spanName = spanName;
        }

        public void onStart(StreamController controller) {
            this.outerObserver.onStart(controller);
        }

        public void onResponse(ResponseT response) {
            this.outerObserver.onResponse(response);
        }

        public void onError(Throwable t) {
            Metadata metadata = this.responseMetadata.getMetadata();
            if (metadata != null) {
                this.headerTracer.recordGfeMetadata(metadata, this.spanName);
            } else {
                this.headerTracer.recordGfeMissingHeader(this.spanName);
            }
            this.outerObserver.onError(t);
        }

        public void onComplete() {
            Metadata metadata = this.responseMetadata.getMetadata();
            if (metadata != null) {
                this.headerTracer.recordGfeMetadata(metadata, this.spanName);
            } else {
                this.headerTracer.recordGfeMissingHeader(this.spanName);
            }
            this.outerObserver.onComplete();
        }
    }
}

