/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort;

import org.apache.spark.Partitioner;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.executor.ShuffleWriteMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.scheduler.MapStatus$;
import org.apache.spark.shuffle.BaseShuffleHandle;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.ShuffleWriter;
import org.apache.spark.shuffle.api.ShuffleExecutorComponents;
import org.apache.spark.shuffle.api.ShuffleMapOutputWriter;
import org.apache.spark.shuffle.sort.SortShuffleWriter$;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.util.collection.ExternalSorter;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product2;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%g!\u0002\u000f\u001e\u0001\u0005:\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\t\u0011%\u0003!\u0011!Q\u0001\n)C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001B\u0001B\u0003%!\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004j\u0001\t\u0007I\u0011\u00026\t\r9\u0004\u0001\u0015!\u0003l\u0011\u001dy\u0007A1A\u0005\nADaa\u001e\u0001!\u0002\u0013\t\bb\u0002=\u0001\u0001\u0004%I!\u001f\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0005\u0003#Aq!!\u0004\u0001A\u0003&!\u0010C\u0005\u0002&\u0001\u0001\r\u0011\"\u0003\u0002(!I\u0011q\u0006\u0001A\u0002\u0013%\u0011\u0011\u0007\u0005\t\u0003k\u0001\u0001\u0015)\u0003\u0002*!I\u0011q\u0007\u0001A\u0002\u0013%\u0011\u0011\b\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0005\u0003\u0013B\u0001\"!\u0014\u0001A\u0003&\u00111\b\u0005\n\u0003\u001f\u0002!\u0019!C\u0005\u0003#B\u0001\"a\u0018\u0001A\u0003%\u00111\u000b\u0005\b\u0003C\u0002A\u0011IA2\u0011\u001d\t9\t\u0001C!\u0003\u0013;\u0001\"!&\u001e\u0011\u0003\t\u0013q\u0013\u0004\b9uA\t!IAM\u0011\u0019\u0001\u0017\u0004\"\u0001\u0002\"\"9\u00111U\r\u0005\u0002\u0005\u0015&!E*peR\u001c\u0006.\u001e4gY\u0016<&/\u001b;fe*\u0011adH\u0001\u0005g>\u0014HO\u0003\u0002!C\u000591\u000f[;gM2,'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0016\t!zSHT\n\u0004\u0001%z\u0004\u0003\u0002\u0016,[qj\u0011aH\u0005\u0003Y}\u0011Qb\u00155vM\u001adWm\u0016:ji\u0016\u0014\bC\u0001\u00180\u0019\u0001!Q\u0001\r\u0001C\u0002I\u0012\u0011aS\u0002\u0001#\t\u0019\u0014\b\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0004O_RD\u0017N\\4\u0011\u0005QR\u0014BA\u001e6\u0005\r\te.\u001f\t\u0003]u\"QA\u0010\u0001C\u0002I\u0012\u0011A\u0016\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u0006\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\t\u0006\u0013q\u0001T8hO&tw-\u0001\u000btQV4g\r\\3CY>\u001c7NU3t_24XM\u001d\t\u0003U\u001dK!\u0001S\u0010\u00033%sG-\u001a=TQV4g\r\\3CY>\u001c7NU3t_24XM]\u0001\u0007Q\u0006tG\r\\3\u0011\u000b)ZU\u0006P'\n\u00051{\"!\u0005\"bg\u0016\u001c\u0006.\u001e4gY\u0016D\u0015M\u001c3mKB\u0011aF\u0014\u0003\u0006\u001f\u0002\u0011\rA\r\u0002\u0002\u0007\u0006)Q.\u00199JIB\u0011AGU\u0005\u0003'V\u0012A\u0001T8oO\u000691m\u001c8uKb$\bC\u0001,X\u001b\u0005\t\u0013B\u0001-\"\u0005-!\u0016m]6D_:$X\r\u001f;\u00023MDWO\u001a4mK\u0016CXmY;u_J\u001cu.\u001c9p]\u0016tGo\u001d\t\u00037zk\u0011\u0001\u0018\u0006\u0003;~\t1!\u00199j\u0013\tyFLA\rTQV4g\r\\3Fq\u0016\u001cW\u000f^8s\u0007>l\u0007o\u001c8f]R\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0004cI\u00164w\r\u001b\t\u0006G\u0002iC(T\u0007\u0002;!)QI\u0002a\u0001\r\")\u0011J\u0002a\u0001\u0015\")\u0001K\u0002a\u0001#\")AK\u0002a\u0001+\")\u0011L\u0002a\u00015\u0006\u0019A-\u001a9\u0016\u0003-\u0004RA\u00167.y5K!!\\\u0011\u0003#MCWO\u001a4mK\u0012+\u0007/\u001a8eK:\u001c\u00170\u0001\u0003eKB\u0004\u0013\u0001\u00042m_\u000e\\W*\u00198bO\u0016\u0014X#A9\u0011\u0005I,X\"A:\u000b\u0005Q\f\u0013aB:u_J\fw-Z\u0005\u0003mN\u0014AB\u00117pG.l\u0015M\\1hKJ\fQB\u00197pG.l\u0015M\\1hKJ\u0004\u0013AB:peR,'/F\u0001{a\rY\u0018\u0011\u0002\t\by\u0006\rQ\u0006PA\u0004\u001b\u0005i(B\u0001@\u0000\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0004\u0003\u0003\t\u0013\u0001B;uS2L1!!\u0002~\u00059)\u0005\u0010^3s]\u0006d7k\u001c:uKJ\u00042ALA\u0005\t)\tY!DA\u0001\u0002\u0003\u0015\tA\r\u0002\u0004?\u0012\n\u0014aB:peR,'\u000fI\u0001\u000bg>\u0014H/\u001a:`I\u0015\fH\u0003BA\n\u00033\u00012\u0001NA\u000b\u0013\r\t9\"\u000e\u0002\u0005+:LG\u000fC\u0005\u0002\u001c1\t\t\u00111\u0001\u0002\u001e\u0005\u0019\u0001\u0010J\u00191\t\u0005}\u00111\u0005\t\by\u0006\rQ\u0006PA\u0011!\rq\u00131\u0005\u0003\f\u0003\u0017\tI\"!A\u0001\u0002\u000b\u0005!'\u0001\u0005ti>\u0004\b/\u001b8h+\t\tI\u0003E\u00025\u0003WI1!!\f6\u0005\u001d\u0011un\u001c7fC:\fAb\u001d;paBLgnZ0%KF$B!a\u0005\u00024!I\u00111D\b\u0002\u0002\u0003\u0007\u0011\u0011F\u0001\ngR|\u0007\u000f]5oO\u0002\n\u0011\"\\1q'R\fG/^:\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005\u0013%A\u0005tG\",G-\u001e7fe&!\u0011QIA \u0005%i\u0015\r]*uCR,8/A\u0007nCB\u001cF/\u0019;vg~#S-\u001d\u000b\u0005\u0003'\tY\u0005C\u0005\u0002\u001cI\t\t\u00111\u0001\u0002<\u0005QQ.\u00199Ti\u0006$Xo\u001d\u0011\u0002\u0019]\u0014\u0018\u000e^3NKR\u0014\u0018nY:\u0016\u0005\u0005M\u0003\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005e\u0013%\u0001\u0005fq\u0016\u001cW\u000f^8s\u0013\u0011\ti&a\u0016\u0003'MCWO\u001a4mK^\u0013\u0018\u000e^3NKR\u0014\u0018nY:\u0002\u001b]\u0014\u0018\u000e^3NKR\u0014\u0018nY:!\u0003\u00159(/\u001b;f)\u0011\t\u0019\"!\u001a\t\u000f\u0005\u001dd\u00031\u0001\u0002j\u00059!/Z2pe\u0012\u001c\bCBA6\u0003w\n\tI\u0004\u0003\u0002n\u0005]d\u0002BA8\u0003kj!!!\u001d\u000b\u0007\u0005M\u0014'\u0001\u0004=e>|GOP\u0005\u0002m%\u0019\u0011\u0011P\u001b\u0002\u000fA\f7m[1hK&!\u0011QPA@\u0005!IE/\u001a:bi>\u0014(bAA=kA)A'a!.y%\u0019\u0011QQ\u001b\u0003\u0011A\u0013x\u000eZ;diJ\nAa\u001d;paR!\u00111RAI!\u0015!\u0014QRA\u001e\u0013\r\ty)\u000e\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005Mu\u00031\u0001\u0002*\u000591/^2dKN\u001c\u0018!E*peR\u001c\u0006.\u001e4gY\u0016<&/\u001b;feB\u00111-G\n\u00043\u0005m\u0005c\u0001\u001b\u0002\u001e&\u0019\u0011qT\u001b\u0003\r\u0005s\u0017PU3g)\t\t9*A\u000btQ>,H\u000e\u001a\"za\u0006\u001c8/T3sO\u0016\u001cvN\u001d;\u0015\r\u0005%\u0012qUAY\u0011\u001d\tIk\u0007a\u0001\u0003W\u000bAaY8oMB\u0019a+!,\n\u0007\u0005=\u0016EA\u0005Ta\u0006\u00148nQ8oM\"1\u0011n\u0007a\u0001\u0003g\u0003\u0004\"!.\u0002:\u0006}\u0016Q\u0019\t\t-2\f9,!0\u0002DB\u0019a&!/\u0005\u0017\u0005m\u0016\u0011WA\u0001\u0002\u0003\u0015\tA\r\u0002\u0004?\u0012\u0012\u0004c\u0001\u0018\u0002@\u0012Y\u0011\u0011YAY\u0003\u0003\u0005\tQ!\u00013\u0005\ryFe\r\t\u0004]\u0005\u0015GaCAd\u0003c\u000b\t\u0011!A\u0003\u0002I\u00121a\u0018\u00135\u0001")
public class SortShuffleWriter<K, V, C>
extends ShuffleWriter<K, V>
implements Logging {
    private final long mapId;
    private final TaskContext context;
    private final ShuffleExecutorComponents shuffleExecutorComponents;
    private final ShuffleDependency<K, V, C> dep;
    private final BlockManager blockManager;
    private ExternalSorter<K, V, ?> sorter;
    private boolean stopping;
    private MapStatus mapStatus;
    private final ShuffleWriteMetrics writeMetrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean shouldBypassMergeSort(SparkConf sparkConf, ShuffleDependency<?, ?, ?> shuffleDependency) {
        return SortShuffleWriter$.MODULE$.shouldBypassMergeSort(sparkConf, shuffleDependency);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ShuffleDependency<K, V, C> dep() {
        return this.dep;
    }

    private BlockManager blockManager() {
        return this.blockManager;
    }

    private ExternalSorter<K, V, ?> sorter() {
        return this.sorter;
    }

    private void sorter_$eq(ExternalSorter<K, V, ?> x$1) {
        this.sorter = x$1;
    }

    private boolean stopping() {
        return this.stopping;
    }

    private void stopping_$eq(boolean x$1) {
        this.stopping = x$1;
    }

    private MapStatus mapStatus() {
        return this.mapStatus;
    }

    private void mapStatus_$eq(MapStatus x$1) {
        this.mapStatus = x$1;
    }

    private ShuffleWriteMetrics writeMetrics() {
        return this.writeMetrics;
    }

    @Override
    public void write(Iterator<Product2<K, V>> records) {
        this.sorter_$eq(this.dep().mapSideCombine() ? new ExternalSorter<K, V, C>(this.context, this.dep().aggregator(), (Option<Partitioner>)new Some((Object)this.dep().partitioner()), this.dep().keyOrdering(), this.dep().serializer()) : new ExternalSorter(this.context, None$.MODULE$, (Option<Partitioner>)new Some((Object)this.dep().partitioner()), None$.MODULE$, this.dep().serializer()));
        this.sorter().insertAll(records);
        ShuffleMapOutputWriter mapOutputWriter = this.shuffleExecutorComponents.createMapOutputWriter(this.dep().shuffleId(), this.mapId, this.dep().partitioner().numPartitions());
        this.sorter().writePartitionedMapOutput(this.dep().shuffleId(), this.mapId, mapOutputWriter);
        long[] partitionLengths = mapOutputWriter.commitAllPartitions().getPartitionLengths();
        this.mapStatus_$eq(MapStatus$.MODULE$.apply(this.blockManager().shuffleServerId(), partitionLengths, this.mapId));
    }

    @Override
    public Option<MapStatus> stop(boolean success) {
        Object object;
        try {
            if (this.stopping()) {
                object = None$.MODULE$;
            } else {
                this.stopping_$eq(true);
                object = success ? Option$.MODULE$.apply((Object)this.mapStatus()) : None$.MODULE$;
            }
        }
        finally {
            if (this.sorter() != null) {
                long startTime = System.nanoTime();
                this.sorter().stop();
                this.writeMetrics().incWriteTime(System.nanoTime() - startTime);
                this.sorter_$eq(null);
            }
        }
        return object;
    }

    public SortShuffleWriter(IndexShuffleBlockResolver shuffleBlockResolver, BaseShuffleHandle<K, V, C> handle, long mapId, TaskContext context, ShuffleExecutorComponents shuffleExecutorComponents) {
        this.mapId = mapId;
        this.context = context;
        this.shuffleExecutorComponents = shuffleExecutorComponents;
        Logging.$init$(this);
        this.dep = handle.dependency();
        this.blockManager = SparkEnv$.MODULE$.get().blockManager();
        this.sorter = null;
        this.stopping = false;
        this.mapStatus = null;
        this.writeMetrics = context.taskMetrics().shuffleWriteMetrics();
    }
}

