/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.executor.ExecutorExitCode$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockId$;
import org.apache.spark.storage.TempLocalBlockId;
import org.apache.spark.storage.TempShuffleBlockId;
import org.apache.spark.storage.UnrecognizedBlockId;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mb!B\r\u001b\u0001q\u0011\u0003\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011U\u0002!\u0011!Q\u0001\nYBQ!\u000f\u0001\u0005\u0002iB\u0001b\u0010\u0001C\u0002\u0013\u0005A\u0004\u0011\u0005\u0007\t\u0002\u0001\u000b\u0011B!\t\u0011\u0015\u0003!\u0019!C\u00019\u0019CaA\u0015\u0001!\u0002\u00139\u0005\u0002C*\u0001\u0005\u0004%\t\u0001\b+\t\r\u0005\u0004\u0001\u0015!\u0003V\u0011\u001d\u0011\u0007A1A\u0005\n\rDa!\u001a\u0001!\u0002\u0013!\u0007b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B\u0012\t\u000b%\u0004A\u0011\u00016\t\u000b%\u0004A\u0011A7\t\u000bM\u0004A\u0011\u0001;\t\u000bY\u0004A\u0011A<\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\tY\u0003\u0001C\u0005\u0003[A\u0001\"a\f\u0001\t\u0003a\u0012\u0011\u0007\u0005\b\u0003s\u0001A\u0011BA\u0019\u0005A!\u0015n]6CY>\u001c7.T1oC\u001e,'O\u0003\u0002\u001c9\u000591\u000f^8sC\u001e,'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0014\u0007\u0001\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0004B]f\u0014VM\u001a\t\u0003U5j\u0011a\u000b\u0006\u0003Yq\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003]-\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003eMj\u0011\u0001H\u0005\u0003iq\u0011\u0011b\u00159be.\u001cuN\u001c4\u0002#\u0011,G.\u001a;f\r&dWm](o'R|\u0007\u000f\u0005\u0002%o%\u0011\u0001(\n\u0002\b\u0005>|G.Z1o\u0003\u0019a\u0014N\\5u}Q\u00191(\u0010 \u0011\u0005q\u0002Q\"\u0001\u000e\t\u000b=\u001a\u0001\u0019A\u0019\t\u000bU\u001a\u0001\u0019\u0001\u001c\u0002%M,(\rR5sgB+'\u000fT8dC2$\u0015N]\u000b\u0002\u0003B\u0011AEQ\u0005\u0003\u0007\u0016\u00121!\u00138u\u0003M\u0019XO\u0019#jeN\u0004VM\u001d'pG\u0006dG)\u001b:!\u0003%awnY1m\t&\u00148/F\u0001H!\r!\u0003JS\u0005\u0003\u0013\u0016\u0012Q!\u0011:sCf\u0004\"a\u0013)\u000e\u00031S!!\u0014(\u0002\u0005%|'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013AAR5mK\u0006QAn\\2bY\u0012K'o\u001d\u0011\u0002\u001f1|7-\u00197ESJ\u001c8\u000b\u001e:j]\u001e,\u0012!\u0016\t\u0004I!3\u0006CA,_\u001d\tAF\f\u0005\u0002ZK5\t!L\u0003\u0002\\a\u00051AH]8pizJ!!X\u0013\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;\u0016\n\u0001\u0003\\8dC2$\u0015N]:TiJLgn\u001a\u0011\u0002\u000fM,(\rR5sgV\tA\rE\u0002%\u0011\u001e\u000b\u0001b];c\t&\u00148\u000fI\u0001\rg\",H\u000fZ8x]\"{wn[\u000b\u0002G\u0005i1\u000f[;uI><h\u000eS8pW\u0002\nqaZ3u\r&dW\r\u0006\u0002KW\")AN\u0004a\u0001-\u0006Aa-\u001b7f]\u0006lW\r\u0006\u0002K]\")qn\u0004a\u0001a\u00069!\r\\8dW&#\u0007C\u0001\u001fr\u0013\t\u0011(DA\u0004CY>\u001c7.\u00133\u0002\u001b\r|g\u000e^1j]N\u0014En\\2l)\t1T\u000fC\u0003p!\u0001\u0007\u0001/A\u0006hKR\fE\u000e\u001c$jY\u0016\u001cH#\u0001=\u0011\u0007et(J\u0004\u0002{y:\u0011\u0011l_\u0005\u0002M%\u0011Q0J\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?&\u000319W\r^!mY\ncwnY6t)\t\t9\u0001E\u0002z}B\fAc\u0019:fCR,G+Z7q\u0019>\u001c\u0017\r\u001c\"m_\u000e\\GCAA\u0007!\u0019!\u0013qBA\n\u0015&\u0019\u0011\u0011C\u0013\u0003\rQ+\b\u000f\\33!\ra\u0014QC\u0005\u0004\u0003/Q\"\u0001\u0005+f[BdunY1m\u00052|7m[%e\u0003Y\u0019'/Z1uKR+W\u000e]*ik\u001a4G.\u001a\"m_\u000e\\GCAA\u000f!\u0019!\u0013qBA\u0010\u0015B\u0019A(!\t\n\u0007\u0005\r\"D\u0001\nUK6\u00048\u000b[;gM2,'\t\\8dW&#\u0017aD2sK\u0006$X\rT8dC2$\u0015N]:\u0015\u0007\u001d\u000bI\u0003C\u00030+\u0001\u0007\u0011'A\bbI\u0012\u001c\u0006.\u001e;e_^t\u0007j\\8l)\u0005\u0019\u0013\u0001B:u_B$\"!a\r\u0011\u0007\u0011\n)$C\u0002\u00028\u0015\u0012A!\u00168ji\u00061Am\\*u_B\u0004")
public class DiskBlockManager
implements Logging {
    private final boolean deleteFilesOnStop;
    private final int subDirsPerLocalDir;
    private final File[] localDirs;
    private final String[] localDirsString;
    private final File[][] subDirs;
    private final Object shutdownHook;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int subDirsPerLocalDir() {
        return this.subDirsPerLocalDir;
    }

    public File[] localDirs() {
        return this.localDirs;
    }

    public String[] localDirsString() {
        return this.localDirsString;
    }

    private File[][] subDirs() {
        return this.subDirs;
    }

    private Object shutdownHook() {
        return this.shutdownHook;
    }

    public File getFile(String filename) {
        File file;
        int hash = Utils$.MODULE$.nonNegativeHash(filename);
        int dirId = hash % this.localDirs().length;
        int subDirId = hash / this.localDirs().length % this.subDirsPerLocalDir();
        File[] fileArray = this.subDirs()[dirId];
        synchronized (fileArray) {
            File file2;
            File old = this.subDirs()[dirId][subDirId];
            if (old != null) {
                file2 = old;
            } else {
                File newDir = new File(this.localDirs()[dirId], new StringOps(Predef$.MODULE$.augmentString("%02x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)subDirId)})));
                Object object = !newDir.exists() ? Files.createDirectory(newDir.toPath(), new FileAttribute[0]) : BoxedUnit.UNIT;
                this.subDirs()[dirId][subDirId] = newDir;
                file2 = newDir;
            }
            file = file2;
        }
        File subDir = file;
        return new File(subDir, filename);
    }

    public File getFile(BlockId blockId) {
        return this.getFile(blockId.name());
    }

    public boolean containsBlock(BlockId blockId) {
        return this.getFile(blockId.name()).exists();
    }

    public Seq<File> getAllFiles() {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.subDirs())).flatMap((Function1 & Serializable & scala.Serializable)dir -> new ArrayOps.ofRef(DiskBlockManager.$anonfun$getAllFiles$1(dir)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DiskBlockManager.$anonfun$getAllFiles$2(x$2))))).flatMap((Function1 & Serializable & scala.Serializable)dir -> {
            File[] files = dir.listFiles();
            return files != null ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toSeq() : (Seq)Seq$.MODULE$.empty();
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public Seq<BlockId> getAllBlocks() {
        return (Seq)this.getAllFiles().flatMap((Function1 & Serializable & scala.Serializable)f -> {
            Iterable iterable;
            try {
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)BlockId$.MODULE$.apply(f.getName())));
            }
            catch (UnrecognizedBlockId unrecognizedBlockId) {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Tuple2<TempLocalBlockId, File> createTempLocalBlock() {
        TempLocalBlockId blockId = new TempLocalBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempLocalBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    public Tuple2<TempShuffleBlockId, File> createTempShuffleBlock() {
        TempShuffleBlockId blockId = new TempShuffleBlockId(UUID.randomUUID());
        while (this.getFile(blockId).exists()) {
            blockId = new TempShuffleBlockId(UUID.randomUUID());
        }
        return new Tuple2((Object)blockId, (Object)this.getFile(blockId));
    }

    private File[] createLocalDirs(SparkConf conf) {
        return (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.getConfiguredLocalDirs(conf))).flatMap((Function1 & Serializable & scala.Serializable)rootDir -> {
            Iterable iterable;
            try {
                File localDir = Utils$.MODULE$.createDirectory((String)rootDir, "blockmgr");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Created local directory at ").append(localDir).toString());
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)localDir));
            }
            catch (IOException e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Failed to create local dir in ").append((String)rootDir).append(". Ignoring this directory.").toString(), e);
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
    }

    private Object addShutdownHook() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Adding shutdown hook");
        return ShutdownHookManager$.MODULE$.addShutdownHook(ShutdownHookManager$.MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY() + 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown hook called");
            this.doStop();
        });
    }

    public void stop() {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.MODULE$.removeShutdownHook(this.shutdownHook()));
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception while removing shutdown hook.", e);
            bl = BoxedUnit.UNIT;
        }
        this.doStop();
    }

    private void doStop() {
        block0: {
            if (!this.deleteFilesOnStop) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).foreach((Function1 & Serializable & scala.Serializable)localDir -> {
                DiskBlockManager.$anonfun$doStop$1(this, localDir);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ Object[] $anonfun$getAllFiles$1(File[] dir) {
        File[] fileArray = dir;
        synchronized (dir) {
            File[] fileArray2 = (File[])dir.clone();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Predef$.MODULE$.refArrayOps((Object[])fileArray2);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getAllFiles$2(File x$2) {
        return x$2 != null;
    }

    public static final /* synthetic */ void $anonfun$doStop$1(DiskBlockManager $this, File localDir) {
        block3: {
            if (!localDir.isDirectory() || !localDir.exists()) break block3;
            try {
                if (!ShutdownHookManager$.MODULE$.hasRootAsShutdownDeleteDir(localDir)) {
                    Utils$.MODULE$.deleteRecursively(localDir);
                }
            }
            catch (Exception e) {
                $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Exception while deleting local spark dir: ").append(localDir).toString(), e);
            }
        }
    }

    public DiskBlockManager(SparkConf conf, boolean deleteFilesOnStop) {
        this.deleteFilesOnStop = deleteFilesOnStop;
        Logging.$init$(this);
        this.subDirsPerLocalDir = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.DISKSTORE_SUB_DIRECTORIES()));
        this.localDirs = this.createLocalDirs(conf);
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).isEmpty()) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create any local dir.");
            System.exit(ExecutorExitCode$.MODULE$.DISK_STORE_FAILED_TO_CREATE_DIR());
        }
        this.localDirsString = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.localDirs())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.subDirs = (File[][])Array$.MODULE$.fill(this.localDirs().length, (Function0 & Serializable & scala.Serializable)() -> new File[this.subDirsPerLocalDir()], ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(File.class)));
        this.shutdownHook = this.addShutdownHook();
    }
}

