/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManagerImpl;

public abstract class AbstractStreamOperatorCompat<OutputT>
extends AbstractStreamOperator<OutputT> {
    protected InternalTimeServiceManager<?> getTimeServiceManagerCompat() {
        return (InternalTimeServiceManager)this.getTimeServiceManager().orElseThrow(() -> new IllegalStateException("Time service manager is not set."));
    }

    protected int numProcessingTimeTimers() {
        return this.getTimeServiceManager().map(manager -> {
            InternalTimeServiceManagerImpl cast = (InternalTimeServiceManagerImpl)this.getTimeServiceManagerCompat();
            return cast.numProcessingTimeTimers();
        }).orElse(0);
    }

    abstract void cleanUp() throws Exception;

    abstract void flushData() throws Exception;

    public void finish() throws Exception {
        try {
            this.flushData();
        }
        finally {
            super.finish();
        }
    }

    public void close() throws Exception {
        try {
            this.cleanUp();
        }
        finally {
            super.close();
        }
    }
}

