/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrooutput;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputField;
import org.apache.hop.avro.transforms.avrooutput.AvroOutputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AvroOutputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AvroOutputMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private static final String[] OUTPUT_TYPE_DESC = new String[]{BaseMessages.getString(PKG, (String)"AvroOutputDialog.OutputType.BinaryFile", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.OutputType.BinaryField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.OutputType.JsonField", (String[])new String[0])};
    private CCombo wOutputType;
    private TextVar wFilename;
    private TextVar wOutputField;
    private Button wbSchema;
    private TextVar wSchema;
    private Button wCreateParentFolder;
    private Button wAddTransformnr;
    private Button wAddPartnr;
    private Label wlAddDate;
    private Button wAddDate;
    private Label wlAddTime;
    private Button wAddTime;
    private Label wlDateTimeFormat;
    private CCombo wDateTimeFormat;
    private CCombo wCompression;
    private Button wSpecifyFormat;
    private Button wCreateSchemaFile;
    private Button wWriteSchemaFile;
    private TextVar wRecordName;
    private TextVar wNamespace;
    private TextVar wDoc;
    private TableView wFields;
    private AvroOutputMeta input;
    private Button wAddToResult;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;
    private Schema avroSchema;
    private boolean validSchema = false;
    private String[] avroFieldNames = null;

    public AvroOutputDialog(Shell parent, IVariables variables, Object baseTransformMeta, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)baseTransformMeta, pipelineMeta, transformName);
        this.input = (AvroOutputMeta)((Object)baseTransformMeta);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        String[] dats;
        String[] compressions;
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsFlags = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AvroOutputDialog.this.setFlags();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        wTabFolder.setSimple(false);
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Label wlOutputType = new Label(wFileComp, 131072);
        wlOutputType.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.OutputType.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOutputType);
        FormData fdlOutputType = new FormData();
        fdlOutputType.left = new FormAttachment(0, 0);
        fdlOutputType.top = new FormAttachment(0, margin);
        fdlOutputType.right = new FormAttachment(middle, -margin);
        wlOutputType.setLayoutData((Object)fdlOutputType);
        this.wOutputType = new CCombo(wFileComp, 2056);
        this.wOutputType.setEditable(false);
        this.props.setLook((Control)this.wOutputType);
        this.wOutputType.addModifyListener(lsMod);
        this.wOutputType.addSelectionListener((SelectionListener)lsFlags);
        FormData fdOutputType = new FormData();
        fdOutputType.left = new FormAttachment(middle, 0);
        fdOutputType.top = new FormAttachment(0, margin);
        fdOutputType.right = new FormAttachment(75, 0);
        this.wOutputType.setLayoutData((Object)fdOutputType);
        for (String outputTypeDesc : OUTPUT_TYPE_DESC) {
            this.wOutputType.add(outputTypeDesc);
        }
        Label wlFilename = new Label(wFileComp, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wOutputType, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wOutputType, margin);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wOutputType, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.avro", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"AvroOutputDialog.AvroFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        Label wlOutputField = new Label(wFileComp, 131072);
        wlOutputField.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.OutputField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOutputField);
        FormData fdlOutputField = new FormData();
        fdlOutputField.left = new FormAttachment(0, 0);
        fdlOutputField.top = new FormAttachment((Control)this.wFilename, margin);
        fdlOutputField.right = new FormAttachment(middle, -margin);
        wlOutputField.setLayoutData((Object)fdlOutputField);
        this.wOutputField = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wOutputField);
        this.wOutputField.addModifyListener(lsMod);
        FormData fdOutputField = new FormData();
        fdOutputField.left = new FormAttachment(middle, 0);
        fdOutputField.top = new FormAttachment((Control)this.wFilename, margin);
        fdOutputField.right = new FormAttachment(100, -margin);
        this.wOutputField.setLayoutData((Object)fdOutputField);
        Label wlCreateSchemaFile = new Label(wFileComp, 131072);
        wlCreateSchemaFile.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.CreateSchemaFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateSchemaFile);
        FormData fdlCreateSchemaFile = new FormData();
        fdlCreateSchemaFile.left = new FormAttachment(0, 0);
        fdlCreateSchemaFile.top = new FormAttachment((Control)this.wOutputField, margin);
        fdlCreateSchemaFile.right = new FormAttachment(middle, -margin);
        wlCreateSchemaFile.setLayoutData((Object)fdlCreateSchemaFile);
        this.wCreateSchemaFile = new Button(wFileComp, 32);
        this.wCreateSchemaFile.setToolTipText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.CreateSchemaFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateSchemaFile);
        FormData fdCreateSchemaFile = new FormData();
        fdCreateSchemaFile.left = new FormAttachment(middle, 0);
        fdCreateSchemaFile.top = new FormAttachment((Control)this.wOutputField, margin);
        fdCreateSchemaFile.right = new FormAttachment(100, 0);
        this.wCreateSchemaFile.setLayoutData((Object)fdCreateSchemaFile);
        this.wCreateSchemaFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
                AvroOutputDialog.this.setCreateSchemaFile();
            }
        });
        Label wlWriteSchemaFile = new Label(wFileComp, 131072);
        wlWriteSchemaFile.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.WriteSchemaFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlWriteSchemaFile);
        FormData fdlWriteSchemaFile = new FormData();
        fdlWriteSchemaFile.left = new FormAttachment(0, 0);
        fdlWriteSchemaFile.top = new FormAttachment((Control)this.wCreateSchemaFile, margin);
        fdlWriteSchemaFile.right = new FormAttachment(middle, -margin);
        wlWriteSchemaFile.setLayoutData((Object)fdlWriteSchemaFile);
        this.wWriteSchemaFile = new Button(wFileComp, 32);
        this.wWriteSchemaFile.setToolTipText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.WriteSchemaFile.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wWriteSchemaFile);
        FormData fdWriteSchemaFile = new FormData();
        fdWriteSchemaFile.left = new FormAttachment(middle, 0);
        fdWriteSchemaFile.top = new FormAttachment((Control)this.wCreateSchemaFile, margin);
        fdWriteSchemaFile.right = new FormAttachment(100, 0);
        this.wWriteSchemaFile.setLayoutData((Object)fdWriteSchemaFile);
        this.wWriteSchemaFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
                AvroOutputDialog.this.setCreateSchemaFile();
            }
        });
        Label wlNamespace = new Label(wFileComp, 131072);
        wlNamespace.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Namespace.Label", (String[])new String[0]));
        this.props.setLook((Control)wlNamespace);
        FormData fdlNamespace = new FormData();
        fdlNamespace.left = new FormAttachment(0, 0);
        fdlNamespace.top = new FormAttachment((Control)this.wWriteSchemaFile, margin);
        fdlNamespace.right = new FormAttachment(middle, -margin);
        wlNamespace.setLayoutData((Object)fdlNamespace);
        this.wNamespace = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wNamespace);
        FormData fdNamespace = new FormData();
        fdNamespace.left = new FormAttachment(middle, 0);
        fdNamespace.top = new FormAttachment((Control)this.wWriteSchemaFile, margin);
        fdNamespace.right = new FormAttachment(100, 0);
        this.wNamespace.setLayoutData((Object)fdNamespace);
        this.wNamespace.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        Label wlRecordName = new Label(wFileComp, 131072);
        wlRecordName.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.RecordName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRecordName);
        FormData fdlRecordName = new FormData();
        fdlRecordName.left = new FormAttachment(0, 0);
        fdlRecordName.top = new FormAttachment((Control)this.wNamespace, margin);
        fdlRecordName.right = new FormAttachment(middle, -margin);
        wlRecordName.setLayoutData((Object)fdlRecordName);
        this.wRecordName = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wRecordName);
        FormData fdRecordName = new FormData();
        fdRecordName.left = new FormAttachment(middle, 0);
        fdRecordName.top = new FormAttachment((Control)this.wNamespace, margin);
        fdRecordName.right = new FormAttachment(100, 0);
        this.wRecordName.setLayoutData((Object)fdRecordName);
        this.wRecordName.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        Label wlDoc = new Label(wFileComp, 131072);
        wlDoc.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Doc.Label", (String[])new String[0]));
        this.props.setLook((Control)wlDoc);
        FormData fdlDoc = new FormData();
        fdlDoc.left = new FormAttachment(0, 0);
        fdlDoc.top = new FormAttachment((Control)this.wRecordName, margin);
        fdlDoc.right = new FormAttachment(middle, -margin);
        wlDoc.setLayoutData((Object)fdlDoc);
        this.wDoc = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wDoc);
        FormData fdDoc = new FormData();
        fdDoc.left = new FormAttachment(middle, 0);
        fdDoc.top = new FormAttachment((Control)this.wRecordName, margin);
        fdDoc.right = new FormAttachment(100, 0);
        this.wDoc.setLayoutData((Object)fdDoc);
        this.wDoc.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        ModifyListener lsSchema = e -> this.updateSchema();
        Label wlSchema = new Label(wFileComp, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Schema.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.top = new FormAttachment((Control)this.wDoc, margin);
        fdlSchema.right = new FormAttachment(middle, -margin);
        wlSchema.setLayoutData((Object)fdlSchema);
        this.wbSchema = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbSchema = new FormData();
        fdbSchema.right = new FormAttachment(100, 0);
        fdbSchema.top = new FormAttachment((Control)this.wDoc, 0);
        this.wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addModifyListener(lsSchema);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment((Control)this.wDoc, margin);
        fdSchema.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        this.wbSchema.addListener(13, e -> BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, (TextVar)this.wSchema, (IVariables)this.variables, (String[])new String[]{"*.avsc", "*.json", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"AvroOutputDialog.AvroFilesSchema", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.AvroFilesSchemaJson", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        Label wlCreateParentFolder = new Label(wFileComp, 131072);
        wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wSchema, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button(wFileComp, 32);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCreateParentFolder);
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)this.wSchema, margin);
        fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        Label wlCompression = new Label(wFileComp, 131072);
        wlCompression.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Compression.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCompression);
        FormData fdlCompression = new FormData();
        fdlCompression.left = new FormAttachment(0, 0);
        fdlCompression.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlCompression.right = new FormAttachment(middle, -margin);
        wlCompression.setLayoutData((Object)fdlCompression);
        this.wCompression = new CCombo(wFileComp, 2056);
        this.wCompression.setEditable(true);
        this.props.setLook((Control)this.wCompression);
        this.wCompression.addModifyListener(lsMod);
        FormData fdCompression = new FormData();
        fdCompression.left = new FormAttachment(middle, 0);
        fdCompression.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdCompression.right = new FormAttachment(75, 0);
        this.wCompression.setLayoutData((Object)fdCompression);
        for (String compression : compressions = AvroOutputMeta.compressionTypes) {
            this.wCompression.add(compression);
        }
        Label wlAddTransformnr = new Label(wFileComp, 131072);
        wlAddTransformnr.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddTransformNr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddTransformnr);
        FormData fdlAddTransformnr = new FormData();
        fdlAddTransformnr.left = new FormAttachment(0, 0);
        fdlAddTransformnr.top = new FormAttachment((Control)this.wCompression, margin);
        fdlAddTransformnr.right = new FormAttachment(middle, -margin);
        wlAddTransformnr.setLayoutData((Object)fdlAddTransformnr);
        this.wAddTransformnr = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddTransformnr);
        FormData fdAddTransformnr = new FormData();
        fdAddTransformnr.left = new FormAttachment(middle, 0);
        fdAddTransformnr.top = new FormAttachment((Control)this.wCompression, margin);
        fdAddTransformnr.right = new FormAttachment(100, 0);
        this.wAddTransformnr.setLayoutData((Object)fdAddTransformnr);
        this.wAddTransformnr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        Label wlAddPartnr = new Label(wFileComp, 131072);
        wlAddPartnr.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddPartnr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddPartnr);
        FormData fdlAddPartnr = new FormData();
        fdlAddPartnr.left = new FormAttachment(0, 0);
        fdlAddPartnr.top = new FormAttachment((Control)this.wAddTransformnr, margin);
        fdlAddPartnr.right = new FormAttachment(middle, -margin);
        wlAddPartnr.setLayoutData((Object)fdlAddPartnr);
        this.wAddPartnr = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddPartnr);
        FormData fdAddPartnr = new FormData();
        fdAddPartnr.left = new FormAttachment(middle, 0);
        fdAddPartnr.top = new FormAttachment((Control)this.wAddTransformnr, margin);
        fdAddPartnr.right = new FormAttachment(100, 0);
        this.wAddPartnr.setLayoutData((Object)fdAddPartnr);
        this.wAddPartnr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddDate = new Label(wFileComp, 131072);
        this.wlAddDate.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddDate.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddDate);
        FormData fdlAddDate = new FormData();
        fdlAddDate.left = new FormAttachment(0, 0);
        fdlAddDate.top = new FormAttachment((Control)this.wAddPartnr, margin);
        fdlAddDate.right = new FormAttachment(middle, -margin);
        this.wlAddDate.setLayoutData((Object)fdlAddDate);
        this.wAddDate = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddDate);
        FormData fdAddDate = new FormData();
        fdAddDate.left = new FormAttachment(middle, 0);
        fdAddDate.top = new FormAttachment((Control)this.wAddPartnr, margin);
        fdAddDate.right = new FormAttachment(100, 0);
        this.wAddDate.setLayoutData((Object)fdAddDate);
        this.wAddDate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        this.wlAddTime = new Label(wFileComp, 131072);
        this.wlAddTime.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddTime.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTime);
        FormData fdlAddTime = new FormData();
        fdlAddTime.left = new FormAttachment(0, 0);
        fdlAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        fdlAddTime.right = new FormAttachment(middle, -margin);
        this.wlAddTime.setLayoutData((Object)fdlAddTime);
        this.wAddTime = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wAddTime);
        FormData fdAddTime = new FormData();
        fdAddTime.left = new FormAttachment(middle, 0);
        fdAddTime.top = new FormAttachment((Control)this.wAddDate, margin);
        fdAddTime.right = new FormAttachment(100, 0);
        this.wAddTime.setLayoutData((Object)fdAddTime);
        this.wAddTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
            }
        });
        Label wlSpecifyFormat = new Label(wFileComp, 131072);
        wlSpecifyFormat.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.SpecifyFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSpecifyFormat);
        FormData fdlSpecifyFormat = new FormData();
        fdlSpecifyFormat.left = new FormAttachment(0, 0);
        fdlSpecifyFormat.top = new FormAttachment((Control)this.wAddTime, margin);
        fdlSpecifyFormat.right = new FormAttachment(middle, -margin);
        wlSpecifyFormat.setLayoutData((Object)fdlSpecifyFormat);
        this.wSpecifyFormat = new Button(wFileComp, 32);
        this.props.setLook((Control)this.wSpecifyFormat);
        this.wSpecifyFormat.setToolTipText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.SpecifyFormat.Tooltip", (String[])new String[0]));
        FormData fdSpecifyFormat = new FormData();
        fdSpecifyFormat.left = new FormAttachment(middle, 0);
        fdSpecifyFormat.top = new FormAttachment((Control)this.wAddTime, margin);
        fdSpecifyFormat.right = new FormAttachment(100, 0);
        this.wSpecifyFormat.setLayoutData((Object)fdSpecifyFormat);
        this.wSpecifyFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AvroOutputDialog.this.input.setChanged();
                AvroOutputDialog.this.setDateTimeFormat();
            }
        });
        this.wlDateTimeFormat = new Label(wFileComp, 131072);
        this.wlDateTimeFormat.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.DateTimeFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDateTimeFormat);
        FormData fdlDateTimeFormat = new FormData();
        fdlDateTimeFormat.left = new FormAttachment(0, 0);
        fdlDateTimeFormat.top = new FormAttachment((Control)this.wSpecifyFormat, margin);
        fdlDateTimeFormat.right = new FormAttachment(middle, -margin);
        this.wlDateTimeFormat.setLayoutData((Object)fdlDateTimeFormat);
        this.wDateTimeFormat = new CCombo(wFileComp, 2056);
        this.wDateTimeFormat.setEditable(true);
        this.props.setLook((Control)this.wDateTimeFormat);
        this.wDateTimeFormat.addModifyListener(lsMod);
        FormData fdDateTimeFormat = new FormData();
        fdDateTimeFormat.left = new FormAttachment(middle, 0);
        fdDateTimeFormat.top = new FormAttachment((Control)this.wSpecifyFormat, margin);
        fdDateTimeFormat.right = new FormAttachment(75, 0);
        this.wDateTimeFormat.setLayoutData((Object)fdDateTimeFormat);
        for (String dat : dats = Const.getDateFormats()) {
            this.wDateTimeFormat.add(dat);
        }
        Label wlAddToResult = new Label(wFileComp, 131072);
        wlAddToResult.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddToResult);
        FormData fdlAddToResult = new FormData();
        fdlAddToResult.left = new FormAttachment(0, 0);
        fdlAddToResult.top = new FormAttachment((Control)this.wDateTimeFormat, 2 * margin);
        fdlAddToResult.right = new FormAttachment(middle, -margin);
        wlAddToResult.setLayoutData((Object)fdlAddToResult);
        this.wAddToResult = new Button(wFileComp, 32);
        this.wAddToResult.setToolTipText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AddFileToResult.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAddToResult);
        FormData fdAddToResult = new FormData();
        fdAddToResult.left = new FormAttachment(middle, 0);
        fdAddToResult.top = new FormAttachment((Control)this.wDateTimeFormat, 2 * margin);
        fdAddToResult.right = new FormAttachment(100, 0);
        this.wAddToResult.setLayoutData((Object)fdAddToResult);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                AvroOutputDialog.this.input.setChanged();
            }
        };
        this.wAddToResult.addSelectionListener((SelectionListener)lsSelR);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.FieldsTab.TabTitle", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)wFieldsComp);
        this.wGet = new Button(wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.GetFields", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(50, -margin);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        Button wUpdateTypes = new Button(wFieldsComp, 8);
        wUpdateTypes.setText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Button.UpdateTypes", (String[])new String[0]));
        wUpdateTypes.setToolTipText(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Tooltip.UpdateTypes", (String[])new String[0]));
        FormData fdUpdateTypes = new FormData();
        fdUpdateTypes.left = new FormAttachment((Control)this.wGet, margin * 2);
        fdUpdateTypes.bottom = new FormAttachment(100, 0);
        wUpdateTypes.setLayoutData((Object)fdUpdateTypes);
        int FieldsCols = 4;
        int FieldsRows = this.input.getOutputFields().size();
        this.colinf = new ColumnInfo[4];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.StreamColumn.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AvroColumn.Column", (String[])new String[0]), 2, this.getSchemaFields(), false);
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AvroType.Column", (String[])new String[0]), 2, AvroOutputField.getAvroTypeArraySorted(), false);
        this.colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.Nullable.Column", (String[])new String[0]), 2, YES_NO_COMBO, false);
        this.colinf[2].setComboValuesSelectionListener((tableItem, rowNr, colNr) -> {
            String[] comboValues = new String[]{};
            if (!this.wCreateSchemaFile.getSelection() && this.validSchema) {
                String avroColumn = tableItem.getText(colNr - 1);
                String streamColumn = tableItem.getText(colNr - 2);
                Schema fieldSchema = this.getFieldSchema(avroColumn = avroColumn != null ? avroColumn : streamColumn);
                if (fieldSchema != null) {
                    String[] combo = AvroOutputField.mapAvroType(fieldSchema, fieldSchema.getType());
                    comboValues = combo;
                    fieldSchema = null;
                } else {
                    comboValues = AvroOutputField.getAvroTypeArraySorted();
                }
            } else {
                comboValues = AvroOutputField.getAvroTypeArraySorted();
            }
            return comboValues;
        });
        this.wFields = new TableView(this.variables, wFieldsComp, 67586, this.colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)wTabFolder);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.wGet.addListener(13, e -> this.get());
        wUpdateTypes.addListener(13, e -> this.updateTypes());
        this.getData();
        this.input.setChanged(this.changed);
        this.setCreateSchemaFile();
        this.setFlags();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private Schema getFieldSchema(String avroName) {
        if (this.avroSchema != null) {
            Schema.Field f;
            if (avroName.startsWith("$.")) {
                avroName = avroName.substring(2);
            }
            Schema recordSchema = this.avroSchema;
            while (avroName.contains(".")) {
                String parentRecord = avroName.substring(0, avroName.indexOf("."));
                avroName = avroName.substring(avroName.indexOf(".") + 1);
                Schema.Field field = recordSchema.getField(parentRecord);
                if (field == null) {
                    return null;
                }
                recordSchema = field.schema();
            }
            if (this.log.isDetailed()) {
                this.logDetailed("Avro name is " + avroName);
                this.logDetailed("Record Schema is " + recordSchema.toString(true));
            }
            if ((f = recordSchema.getField(avroName)) == null) {
                return null;
            }
            return f.schema();
        }
        return null;
    }

    private void updateSchema() {
        try {
            this.avroSchema = null;
            this.avroSchema = new Schema.Parser().parse(new File(this.variables.resolve(this.wSchema.getText())));
            this.validSchema = true;
            this.wFields.setColumnInfo(1, new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroOutputDialog.AvroColumn.Column", (String[])new String[0]), 2, this.getSchemaFields(), false));
        }
        catch (Exception ex) {
            this.validSchema = false;
            this.avroSchema = null;
        }
    }

    private ArrayList<String> getFieldsList(Schema schema, String parent) {
        ArrayList<String> result = new ArrayList<String>();
        if (schema.getType() != Schema.Type.RECORD) {
            return result;
        }
        List fields = schema.getFields();
        for (Schema.Field f : fields) {
            ArrayList<Schema> fieldSchemas;
            if (f.schema().getType() == Schema.Type.UNION) {
                fieldSchemas = f.schema().getTypes();
            } else {
                fieldSchemas = new ArrayList<Schema>();
                fieldSchemas.add(f.schema());
            }
            Iterator itTypes = fieldSchemas.iterator();
            boolean added = false;
            while (itTypes.hasNext()) {
                Schema type = (Schema)itTypes.next();
                if (type.getType() != Schema.Type.NULL) {
                    if (type.getType() == Schema.Type.RECORD) {
                        String child = "$." + f.name();
                        if (parent != null && parent.length() > 0 && !parent.equals("$.")) {
                            child = parent + "." + f.name();
                        }
                        ArrayList<String> children = this.getFieldsList(type, child);
                        result.addAll(children);
                    } else if (!added) {
                        added = true;
                        String name = "$." + f.name();
                        if (parent != null && parent.length() > 0 && !parent.equals("$.")) {
                            name = parent + "." + f.name();
                        }
                        result.add(name);
                    }
                }
                type = null;
            }
        }
        return result;
    }

    private String[] getSchemaFields() {
        String[] avroFields;
        if (this.validSchema) {
            ArrayList<String> fields = this.getFieldsList(this.avroSchema, "$.");
            avroFields = new String[fields.size() + 1];
            avroFields[0] = "";
            Iterator<String> itNames = fields.iterator();
            int i = 1;
            while (itNames.hasNext()) {
                avroFields[i] = itNames.next();
                ++i;
            }
        } else {
            avroFields = new String[]{""};
        }
        this.avroFieldNames = avroFields;
        return avroFields;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void setFlags() {
        int outputTypeId = this.wOutputType.getSelectionIndex();
        if (outputTypeId == 0) {
            this.wFilename.setEnabled(true);
            this.wCompression.setEnabled(true);
            this.wAddTransformnr.setEnabled(true);
            this.wAddPartnr.setEnabled(true);
            this.wAddDate.setEnabled(true);
            this.wAddTime.setEnabled(true);
            this.wSpecifyFormat.setEnabled(true);
            this.wDateTimeFormat.setEnabled(true);
            this.wOutputField.setEnabled(false);
        } else if (outputTypeId == 1 || outputTypeId == 2) {
            this.wFilename.setEnabled(false);
            this.wCompression.setEnabled(false);
            this.wAddTransformnr.setEnabled(false);
            this.wAddPartnr.setEnabled(false);
            this.wAddDate.setEnabled(false);
            this.wAddTime.setEnabled(false);
            this.wSpecifyFormat.setEnabled(false);
            this.wDateTimeFormat.setEnabled(false);
            this.wOutputField.setEnabled(true);
        }
    }

    private void setCreateSchemaFile() {
        this.wDoc.setEnabled(this.wCreateSchemaFile.getSelection());
        this.wNamespace.setEnabled(this.wCreateSchemaFile.getSelection());
        this.wRecordName.setEnabled(this.wCreateSchemaFile.getSelection());
        this.wWriteSchemaFile.setEnabled(this.wCreateSchemaFile.getSelection());
        if (this.wWriteSchemaFile.getSelection() || !this.wCreateSchemaFile.getSelection()) {
            this.wSchema.setEnabled(true);
            this.wbSchema.setEnabled(true);
        } else {
            this.wSchema.setEnabled(false);
            this.wbSchema.setEnabled(false);
        }
    }

    private void setDateTimeFormat() {
        if (this.wSpecifyFormat.getSelection()) {
            this.wAddDate.setSelection(false);
            this.wAddTime.setSelection(false);
        }
        this.wDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wlDateTimeFormat.setEnabled(this.wSpecifyFormat.getSelection());
        this.wAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddDate.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
        this.wlAddTime.setEnabled(!this.wSpecifyFormat.getSelection());
    }

    public void getData() {
        if (this.input.getOutputTypeId() >= 0 && this.input.getOutputTypeId() < OUTPUT_TYPE_DESC.length) {
            this.wOutputType.setText(OUTPUT_TYPE_DESC[this.input.getOutputTypeId()]);
        }
        if (this.input.getFileName() != null && !this.wFilename.isDisposed()) {
            this.wFilename.setText(this.input.getFileName());
        }
        this.wOutputField.setText(Const.NVL((String)this.input.getOutputFieldName(), (String)""));
        if (this.input.getSchemaFileName() != null && !this.wSchema.isDisposed()) {
            this.wSchema.setText(this.input.getSchemaFileName());
            this.updateSchema();
        }
        if (this.input.getNamespace() != null && !this.wNamespace.isDisposed()) {
            this.wNamespace.setText(this.input.getNamespace());
        }
        if (this.input.getDoc() != null && !this.wDoc.isDisposed()) {
            this.wDoc.setText(this.input.getDoc());
        }
        if (this.input.getRecordName() != null && !this.wRecordName.isDisposed()) {
            this.wRecordName.setText(this.input.getRecordName());
        }
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wCreateSchemaFile.setSelection(this.input.isCreateSchemaFile());
        this.wWriteSchemaFile.setSelection(this.input.isWriteSchemaFile());
        this.wCompression.setText(Const.NVL((String)this.input.getCompressionType(), (String)""));
        this.wAddDate.setSelection(this.input.isDateInFilename());
        this.wAddTime.setSelection(this.input.isTimeInFilename());
        this.wDateTimeFormat.setText(Const.NVL((String)this.input.getDateTimeFormat(), (String)""));
        this.wSpecifyFormat.setSelection(this.input.isSpecifyingFormat());
        this.wAddTransformnr.setSelection(this.input.isTransformNrInFilename());
        this.wAddPartnr.setSelection(this.input.isPartNrInFilename());
        this.wAddToResult.setSelection(this.input.isAddToResultFilenames());
        this.logDebug("getting fields info...");
        for (int i = 0; i < this.input.getOutputFields().size(); ++i) {
            AvroOutputField field = this.input.getOutputFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            if (field.getName() != null) {
                item.setText(1, field.getName());
            }
            if (field.getAvroName() != null) {
                item.setText(2, field.getAvroName());
            }
            if (field.getAvroTypeDesc() != null) {
                item.setText(3, field.getAvroTypeDesc());
            }
            if (field.isNullable()) {
                item.setText(4, "Y");
                continue;
            }
            item.setText(4, "N");
        }
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.avroSchema = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(AvroOutputMeta tfoi) {
        tfoi.setOutputTypeById(this.wOutputType.getSelectionIndex());
        tfoi.setFileName(this.wFilename.getText());
        tfoi.setOutputFieldName(this.wOutputField.getText());
        tfoi.setSchemaFileName(this.wSchema.getText());
        tfoi.setCreateSchemaFile(this.wCreateSchemaFile.getSelection());
        tfoi.setWriteSchemaFile(this.wWriteSchemaFile.getSelection());
        tfoi.setNamespace(this.wNamespace.getText());
        tfoi.setRecordName(this.wRecordName.getText());
        tfoi.setDoc(this.wDoc.getText());
        tfoi.setCompressionType(this.wCompression.getText());
        tfoi.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        tfoi.setTransformNrInFilename(this.wAddTransformnr.getSelection());
        tfoi.setPartNrInFilename(this.wAddPartnr.getSelection());
        tfoi.setDateInFilename(this.wAddDate.getSelection());
        tfoi.setTimeInFilename(this.wAddTime.getSelection());
        tfoi.setDateTimeFormat(this.wDateTimeFormat.getText());
        tfoi.setSpecifyingFormat(this.wSpecifyFormat.getSelection());
        tfoi.setAddToResultFilenames(this.wAddToResult.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        tfoi.getOutputFields().clear();
        for (int i = 0; i < nrfields; ++i) {
            AvroOutputField field = new AvroOutputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setAvroName(item.getText(2));
            field.setAvroType(item.getText(3));
            boolean nullable = "Y".equalsIgnoreCase(item.getText(4));
            if (item.getText(4).isEmpty()) {
                nullable = true;
            }
            field.setNullable(nullable);
            tfoi.getOutputFields().add(field);
        }
    }

    private void ok() {
        this.avroSchema = null;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.input.setChanged(true);
        this.dispose();
    }

    private void updateTypes() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                this.updateTypes(r, this.wFields, 1, 2, new int[]{3});
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> true;
                this.getFieldsFromPreviousAvro(r, this.wFields, 1, new int[]{1}, new int[]{2}, new int[]{3}, listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void updateTypes(IRowMeta row, TableView tableView, int nameColumn, int avroNameColumn, int[] typeColumn) {
        boolean createSchemaFile = this.wCreateSchemaFile.getSelection();
        if (this.validSchema || createSchemaFile) {
            Table table = tableView.table;
            boolean typesPopulated = false;
            for (int i = 0; i < table.getItemCount(); ++i) {
                TableItem tableItem = table.getItem(i);
                if (typesPopulated) continue;
                for (int c = 0; c < typeColumn.length; ++c) {
                    if (Utils.isEmpty((CharSequence)tableItem.getText(typeColumn[c]))) continue;
                    typesPopulated = true;
                    break;
                }
                if (typesPopulated) break;
            }
            int choice = 0;
            if (typesPopulated) {
                MessageDialogWithToggle md = new MessageDialogWithToggle(tableView.getShell(), BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.Message", (String[])new String[0]), 8, new String[]{BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.ReplaceAll", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.Cancel", (String[])new String[0])}, "", true);
                int idx = md.open();
                choice = idx & 0xFF;
            }
            if (choice == 2 || choice == 255) {
                return;
            }
            for (int i = 0; i < table.getItemCount(); ++i) {
                TableItem tableItem = table.getItem(i);
                String avroName = !tableItem.getText(2).isEmpty() ? tableItem.getText(2) : tableItem.getText(1);
                String streamName = tableItem.getText(1);
                this.logBasic("Stream name is " + streamName);
                if (!avroName.isEmpty() && !createSchemaFile && this.avroSchema != null) {
                    Schema fieldSchema = this.getFieldSchema(avroName);
                    if (fieldSchema != null) {
                        String[] types = AvroOutputField.mapAvroType(fieldSchema, fieldSchema.getType());
                        if (types.length > 0) {
                            for (int c = 0; c < typeColumn.length; ++c) {
                                if (choice == 0 && !Utils.isEmpty((CharSequence)tableItem.getText(typeColumn[c]))) continue;
                                tableItem.setText(typeColumn[c], types[0]);
                            }
                            continue;
                        }
                        if (choice != 1) continue;
                        for (int c = 0; c < typeColumn.length; ++c) {
                            tableItem.setText(typeColumn[c], "");
                        }
                        continue;
                    }
                    if (choice != 1) continue;
                    for (int c = 0; c < typeColumn.length; ++c) {
                        tableItem.setText(typeColumn[c], "");
                    }
                    continue;
                }
                if (!createSchemaFile || streamName.isEmpty()) continue;
                this.logBasic("Create File");
                IValueMeta v = row.searchValueMeta(streamName);
                this.logBasic(v != null ? v.getName() : "Value Meta is null");
                String avroType = "";
                if (v != null) {
                    avroType = AvroOutputField.getAvroTypeDesc(AvroOutputField.getDefaultAvroType(v.getType()));
                }
                for (int aTypeColumn : typeColumn) {
                    if (choice != 1 && (choice != 0 || !tableItem.getText(aTypeColumn).isEmpty())) continue;
                    tableItem.setText(aTypeColumn, avroType);
                }
            }
        } else {
            MessageDialogWithToggle md = new MessageDialogWithToggle(tableView.getShell(), BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.BadSchema.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AvroOutputDialog.GetTypesChoice.BadSchema.Message", (String[])new String[0]), 8, new String[]{BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0])}, "", true);
            int n = md.open();
        }
    }

    public void getFieldsFromPreviousAvro(IRowMeta row, TableView tableView, int keyColumn, int[] nameColumn, int[] avroNameColumn, int[] avroTypeColumn, ITableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = tableView.table;
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Utils.isEmpty((CharSequence)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (!keys.isEmpty()) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(tableView.getShell(), BaseMessages.getString(PKG, (String)"BaseTransformDialog.GetFieldsChoice.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.GetFieldsChoice.Message", (String[])new String[]{"" + keys.size(), "" + row.size()}), 8, new String[]{BaseMessages.getString(PKG, (String)"BaseTransformDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseTransformDialog.Cancel", (String[])new String[0])}, "Y", true);
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.clearAll(false);
        }
        for (int i = 0; i < row.size(); ++i) {
            IValueMeta v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            TableItem tableItem = new TableItem(table, 0);
            for (int aNameColumn : nameColumn) {
                tableItem.setText(aNameColumn, Const.NVL((String)v.getName(), (String)""));
            }
            if (this.validSchema && !this.wCreateSchemaFile.getSelection()) {
                block5: for (int anAvroNameColumn : avroNameColumn) {
                    for (int o = 0; o < this.avroFieldNames.length; ++o) {
                        Object fieldName = this.avroFieldNames[o];
                        String matchName = fieldName;
                        if (fieldName != null && ((String)fieldName).startsWith("$.")) {
                            matchName = ((String)fieldName).substring(2);
                        }
                        if (!matchName.equalsIgnoreCase(Const.NVL((String)v.getName(), (String)""))) continue;
                        if (fieldName != null && ((String)fieldName).length() > 0) {
                            fieldName = "$." + matchName;
                        }
                        tableItem.setText(anAvroNameColumn, Const.NVL((String)fieldName, (String)""));
                        try {
                            Schema fieldSchema = this.getFieldSchema((String)fieldName);
                            String[] avroType = AvroOutputField.mapAvroType(fieldSchema, fieldSchema.getType());
                            if (avroType.length <= 0) continue block5;
                            for (int anAvroTypeColumn : avroTypeColumn) {
                                tableItem.setText(anAvroTypeColumn, avroType[0]);
                            }
                            continue block5;
                        }
                        catch (Exception exception) {
                            continue block5;
                        }
                    }
                }
            } else if (this.wCreateSchemaFile.getSelection()) {
                for (int aNameColumn : nameColumn) {
                    tableItem.setText(aNameColumn, Const.NVL((String)v.getName(), (String)""));
                }
                Object avroName = v.getName();
                if (avroName != null && ((String)avroName).length() > 0) {
                    avroName = "$." + (String)avroName;
                }
                for (int anAvroNameColumn : avroNameColumn) {
                    tableItem.setText(anAvroNameColumn, Const.NVL((String)avroName, (String)""));
                }
                String avroType = AvroOutputField.getAvroTypeDesc(AvroOutputField.getDefaultAvroType(v.getType()));
                for (int anAvroTypeColumn : avroTypeColumn) {
                    tableItem.setText(anAvroTypeColumn, Const.NVL((String)avroType, (String)""));
                }
            }
            if (listener == null || listener.tableItemInserted(tableItem, v)) continue;
            tableItem.dispose();
        }
        tableView.removeEmptyRows();
        tableView.setRowNums();
        tableView.optWidth(true);
    }
}

