/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workarounds;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStreamWithCloseDetection
extends BufferedOutputStream {
    boolean alreadyClosed = false;

    public BufferedOutputStreamWithCloseDetection(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.alreadyClosed && this.count == 0) {
            return;
        }
        super.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.alreadyClosed) {
            super.close();
            this.alreadyClosed = true;
        }
    }
}

