/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.w3c.dom.Node;

public class HopServerSequence {
    public static final String XML_TAG = "sequence";
    private String name;
    private long startValue;
    private DatabaseMeta databaseMeta;
    private String schemaName;
    private String tableName;
    private String sequenceNameField;
    private String valueField;

    public HopServerSequence() {
        this.startValue = 1L;
    }

    public HopServerSequence(String name, long startValue, DatabaseMeta databaseMeta, String schemaName, String tableName, String sequenceNameField, String valueField) {
        this.name = name;
        this.startValue = startValue;
        this.databaseMeta = databaseMeta;
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.sequenceNameField = sequenceNameField;
        this.valueField = valueField;
    }

    public synchronized long getNextValue(IVariables variables, ILoggingObject log, long incrementValue) throws HopException {
        Database db = null;
        try {
            long value;
            db = new Database(log, variables, this.databaseMeta);
            db.connect();
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
            String seqField = this.databaseMeta.quoteField(this.sequenceNameField);
            String valField = this.databaseMeta.quoteField(this.valueField);
            boolean update = false;
            String sql = "SELECT " + valField + " FROM " + schemaTable + " WHERE " + seqField + " = ?";
            RowMetaAndData param = new RowMetaAndData();
            param.addValue(seqField, 2, (Object)this.name);
            RowMetaAndData row = db.getOneRow(sql, param.getRowMeta(), param.getData());
            if (row != null && row.getData() != null) {
                update = true;
                Long longValue = row.getInteger(0);
                value = longValue == null ? this.startValue : longValue;
            } else {
                value = this.startValue;
            }
            long maximum = value + incrementValue;
            if (update) {
                sql = "UPDATE " + schemaTable + " SET " + valField + "= ? WHERE " + seqField + "= ? ";
                param = new RowMetaAndData();
                param.addValue(valField, 5, (Object)maximum);
                param.addValue(seqField, 2, (Object)this.name);
            } else {
                sql = "INSERT INTO " + schemaTable + "(" + seqField + ", " + valField + ") VALUES( ? , ? )";
                param = new RowMetaAndData();
                param.addValue(seqField, 2, (Object)this.name);
                param.addValue(valField, 5, (Object)maximum);
            }
            db.execStatement(sql, param.getRowMeta(), param.getData());
            long l = value;
            return l;
        }
        catch (Exception e) {
            throw new HopException("Unable to get next value for server sequence '" + this.name + "' on database '" + this.databaseMeta.getName() + "'", (Throwable)e);
        }
        finally {
            db.disconnect();
        }
    }

    public HopServerSequence(Node node, List<DatabaseMeta> databases) throws HopXmlException {
        this.name = XmlHandler.getTagValue((Node)node, (String)"name");
        this.startValue = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"start"), (int)0);
        this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)XmlHandler.getTagValue((Node)node, (String)"connection"));
        this.schemaName = XmlHandler.getTagValue((Node)node, (String)"schema");
        this.tableName = XmlHandler.getTagValue((Node)node, (String)"table");
        this.sequenceNameField = XmlHandler.getTagValue((Node)node, (String)"sequence_field");
        this.valueField = XmlHandler.getTagValue((Node)node, (String)"value_field");
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(100);
        xml.append(XmlHandler.addTagValue((String)"name", (String)this.name));
        xml.append(XmlHandler.addTagValue((String)"start", (long)this.startValue));
        xml.append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        xml.append(XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        xml.append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        xml.append(XmlHandler.addTagValue((String)"sequence_field", (String)this.sequenceNameField));
        xml.append(XmlHandler.addTagValue((String)"value_field", (String)this.valueField));
        return xml.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getStartValue() {
        return this.startValue;
    }

    public void setStartValue(long startValue) {
        this.startValue = startValue;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSequenceNameField() {
        return this.sequenceNameField;
    }

    public void setSequenceNameField(String sequenceNameField) {
        this.sequenceNameField = sequenceNameField;
    }

    public String getValueField() {
        return this.valueField;
    }

    public void setValueField(String valueField) {
        this.valueField = valueField;
    }

    public static HopServerSequence findServerSequence(String name, List<HopServerSequence> hopServerSequences) {
        for (HopServerSequence hopServerSequence : hopServerSequences) {
            if (!hopServerSequence.getName().equalsIgnoreCase(name)) continue;
            return hopServerSequence;
        }
        return null;
    }
}

