/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.grpc.internal;

import java.util.ArrayList;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ConnectivityState;

@NotThreadSafe
final class ConnectivityStateManager {
    private ArrayList<Listener> listeners = new ArrayList();
    private volatile ConnectivityState state = ConnectivityState.IDLE;

    ConnectivityStateManager() {
    }

    void notifyWhenStateChanged(Runnable callback, Executor executor, ConnectivityState source) {
        Preconditions.checkNotNull(callback, "callback");
        Preconditions.checkNotNull(executor, "executor");
        Preconditions.checkNotNull(source, "source");
        Listener stateChangeListener = new Listener(callback, executor);
        if (this.state != source) {
            stateChangeListener.runInExecutor();
        } else {
            this.listeners.add(stateChangeListener);
        }
    }

    void gotoState(@Nonnull ConnectivityState newState) {
        Preconditions.checkNotNull(newState, "newState");
        if (this.state != newState && this.state != ConnectivityState.SHUTDOWN) {
            this.state = newState;
            if (this.listeners.isEmpty()) {
                return;
            }
            ArrayList<Listener> savedListeners = this.listeners;
            this.listeners = new ArrayList();
            for (Listener listener : savedListeners) {
                listener.runInExecutor();
            }
        }
    }

    ConnectivityState getState() {
        ConnectivityState stateCopy = this.state;
        if (stateCopy == null) {
            throw new UnsupportedOperationException("Channel state API is not implemented");
        }
        return stateCopy;
    }

    private static final class Listener {
        final Runnable callback;
        final Executor executor;

        Listener(Runnable callback, Executor executor) {
            this.callback = callback;
            this.executor = executor;
        }

        void runInExecutor() {
            this.executor.execute(this.callback);
        }
    }
}

