/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SimpleBuilders;
import org.apache.cassandra.db.partitions.PartitionStatisticsCollector;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Cells;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ColumnDefinitionVersionComparator;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.WrappedInt;

public abstract class Rows {
    public static final Row EMPTY_STATIC_ROW = BTreeRow.emptyRow(Clustering.STATIC_CLUSTERING);

    private Rows() {
    }

    public static Row.Builder copy(Row row, Row.Builder builder) {
        builder.newRow(row.clustering());
        builder.addPrimaryKeyLivenessInfo(row.primaryKeyLivenessInfo());
        builder.addRowDeletion(row.deletion());
        for (ColumnData cd : row) {
            if (cd.column().isSimple()) {
                builder.addCell((Cell)cd);
                continue;
            }
            ComplexColumnData complexData = (ComplexColumnData)cd;
            builder.addComplexDeletion(complexData.column(), complexData.complexDeletion());
            for (Cell cell : complexData) {
                builder.addCell(cell);
            }
        }
        return builder;
    }

    public static Row.SimpleBuilder simpleBuilder(CFMetaData metadata, Object ... clusteringValues) {
        return new SimpleBuilders.RowBuilder(metadata, clusteringValues);
    }

    public static int collectStats(Row row, PartitionStatisticsCollector collector) {
        assert (!row.isEmpty());
        collector.update(row.primaryKeyLivenessInfo());
        collector.update(row.deletion().time());
        WrappedInt columnCount = new WrappedInt(0);
        WrappedInt cellCount = new WrappedInt(0);
        row.apply(cd -> {
            if (cd.column().isSimple()) {
                columnCount.increment();
                cellCount.increment();
                Cells.collectStats((Cell)cd, collector);
            } else {
                ComplexColumnData complexData = (ComplexColumnData)cd;
                collector.update(complexData.complexDeletion());
                if (complexData.hasCells()) {
                    columnCount.increment();
                    for (Cell cell : complexData) {
                        cellCount.increment();
                        Cells.collectStats(cell, collector);
                    }
                }
            }
        }, false);
        collector.updateColumnSetPerRow(columnCount.get());
        return cellCount.get();
    }

    public static void diff(final RowDiffListener diffListener, Row merged, final Row ... inputs) {
        final Clustering clustering = merged.clustering();
        LivenessInfo mergedInfo = merged.primaryKeyLivenessInfo().isEmpty() ? null : merged.primaryKeyLivenessInfo();
        Row.Deletion mergedDeletion = merged.deletion().isLive() ? null : merged.deletion();
        for (int i = 0; i < inputs.length; ++i) {
            Row.Deletion inputDeletion;
            Row[] input = inputs[i];
            LivenessInfo inputInfo = input == null || input.primaryKeyLivenessInfo().isEmpty() ? null : input.primaryKeyLivenessInfo();
            Row.Deletion deletion = inputDeletion = input == null || input.deletion().isLive() ? null : input.deletion();
            if (mergedInfo != null || inputInfo != null) {
                diffListener.onPrimaryKeyLivenessInfo(i, clustering, mergedInfo, inputInfo);
            }
            if (mergedDeletion == null && inputDeletion == null) continue;
            diffListener.onDeletion(i, clustering, mergedDeletion, inputDeletion);
        }
        ArrayList inputIterators = new ArrayList(1 + inputs.length);
        inputIterators.add(merged.iterator());
        for (Row row : inputs) {
            inputIterators.add(row == null ? Collections.emptyIterator() : row.iterator());
        }
        MergeIterator<ColumnData, Object> iter = MergeIterator.get(inputIterators, ColumnData.comparator, new MergeIterator.Reducer<ColumnData, Object>(){
            ColumnData mergedData;
            ColumnData[] inputDatas;
            {
                this.inputDatas = new ColumnData[inputs.length];
            }

            @Override
            public void reduce(int idx, ColumnData current) {
                if (idx == 0) {
                    this.mergedData = current;
                } else {
                    this.inputDatas[idx - 1] = current;
                }
            }

            @Override
            protected Object getReduced() {
                for (int i = 0; i != this.inputDatas.length; ++i) {
                    ColumnData input = this.inputDatas[i];
                    if (this.mergedData == null && input == null) continue;
                    ColumnDefinition column = (this.mergedData != null ? this.mergedData : input).column;
                    if (column.isSimple()) {
                        diffListener.onCell(i, clustering, (Cell)this.mergedData, (Cell)input);
                        continue;
                    }
                    ComplexColumnData mergedData = (ComplexColumnData)this.mergedData;
                    ComplexColumnData inputData = (ComplexColumnData)input;
                    if (mergedData == null) {
                        if (!inputData.complexDeletion().isLive()) {
                            diffListener.onComplexDeletion(i, clustering, column, null, inputData.complexDeletion());
                        }
                        for (Cell inputCell : inputData) {
                            diffListener.onCell(i, clustering, null, inputCell);
                        }
                        continue;
                    }
                    if (inputData == null) {
                        if (!mergedData.complexDeletion().isLive()) {
                            diffListener.onComplexDeletion(i, clustering, column, mergedData.complexDeletion(), null);
                        }
                        for (Cell mergedCell : mergedData) {
                            diffListener.onCell(i, clustering, mergedCell, null);
                        }
                        continue;
                    }
                    if (!mergedData.complexDeletion().isLive() || !inputData.complexDeletion().isLive()) {
                        diffListener.onComplexDeletion(i, clustering, column, mergedData.complexDeletion(), inputData.complexDeletion());
                    }
                    PeekingIterator mergedCells = Iterators.peekingIterator(mergedData.iterator());
                    PeekingIterator inputCells = Iterators.peekingIterator(inputData.iterator());
                    while (mergedCells.hasNext() && inputCells.hasNext()) {
                        int cmp = column.cellPathComparator().compare(((Cell)mergedCells.peek()).path(), ((Cell)inputCells.peek()).path());
                        if (cmp == 0) {
                            diffListener.onCell(i, clustering, (Cell)mergedCells.next(), (Cell)inputCells.next());
                            continue;
                        }
                        if (cmp < 0) {
                            diffListener.onCell(i, clustering, (Cell)mergedCells.next(), null);
                            continue;
                        }
                        diffListener.onCell(i, clustering, null, (Cell)inputCells.next());
                    }
                    while (mergedCells.hasNext()) {
                        diffListener.onCell(i, clustering, (Cell)mergedCells.next(), null);
                    }
                    while (inputCells.hasNext()) {
                        diffListener.onCell(i, clustering, null, (Cell)inputCells.next());
                    }
                }
                return null;
            }

            @Override
            protected void onKeyChange() {
                this.mergedData = null;
                Arrays.fill(this.inputDatas, null);
            }
        });
        while (iter.hasNext()) {
            iter.next();
        }
    }

    public static Row merge(Row row1, Row row2, int nowInSec) {
        Row.Builder builder = BTreeRow.sortedBuilder();
        Rows.merge(row1, row2, builder, nowInSec);
        return builder.build();
    }

    public static long merge(Row existing, Row update, Row.Builder builder, int nowInSec) {
        Row.Deletion rowDeletion;
        Clustering clustering = existing.clustering();
        builder.newRow(clustering);
        LivenessInfo existingInfo = existing.primaryKeyLivenessInfo();
        LivenessInfo updateInfo = update.primaryKeyLivenessInfo();
        LivenessInfo mergedInfo = existingInfo.supersedes(updateInfo) ? existingInfo : updateInfo;
        long timeDelta = Math.abs(existingInfo.timestamp() - mergedInfo.timestamp());
        Row.Deletion deletion = rowDeletion = existing.deletion().supersedes(update.deletion()) ? existing.deletion() : update.deletion();
        if (rowDeletion.deletes(mergedInfo)) {
            mergedInfo = LivenessInfo.EMPTY;
        } else if (rowDeletion.isShadowedBy(mergedInfo)) {
            rowDeletion = Row.Deletion.LIVE;
        }
        builder.addPrimaryKeyLivenessInfo(mergedInfo);
        builder.addRowDeletion(rowDeletion);
        DeletionTime deletion2 = rowDeletion.time();
        Iterator a = existing.iterator();
        Iterator b = update.iterator();
        ColumnData nexta = a.hasNext() ? (ColumnData)a.next() : null;
        ColumnData nextb = b.hasNext() ? (ColumnData)b.next() : null;
        while (nexta != null | nextb != null) {
            ColumnData curb;
            int comparison = nexta == null ? 1 : (nextb == null ? -1 : nexta.column.compareTo(nextb.column));
            ColumnData cura = comparison <= 0 ? nexta : null;
            ColumnDefinition column = Rows.getColumnDefinition(cura, curb = comparison >= 0 ? nextb : null);
            if (column.isSimple()) {
                timeDelta = Math.min(timeDelta, Cells.reconcile((Cell)cura, (Cell)curb, deletion2, builder, nowInSec));
            } else {
                DeletionTime maxDt;
                ComplexColumnData existingData = (ComplexColumnData)cura;
                ComplexColumnData updateData = (ComplexColumnData)curb;
                DeletionTime existingDt = existingData == null ? DeletionTime.LIVE : existingData.complexDeletion();
                DeletionTime updateDt = updateData == null ? DeletionTime.LIVE : updateData.complexDeletion();
                DeletionTime deletionTime = maxDt = existingDt.supersedes(updateDt) ? existingDt : updateDt;
                if (maxDt.supersedes(deletion2)) {
                    builder.addComplexDeletion(column, maxDt);
                } else {
                    maxDt = deletion2;
                }
                Iterator<Cell> existingCells = existingData == null ? null : existingData.iterator();
                Iterator<Cell> updateCells = updateData == null ? null : updateData.iterator();
                timeDelta = Math.min(timeDelta, Cells.reconcileComplex(column, existingCells, updateCells, maxDt, builder, nowInSec));
            }
            if (cura != null) {
                ColumnData columnData = nexta = a.hasNext() ? (ColumnData)a.next() : null;
            }
            if (curb == null) continue;
            nextb = b.hasNext() ? (ColumnData)b.next() : null;
        }
        return timeDelta;
    }

    public static Row removeShadowedCells(Row existing, Row update, DeletionTime rangeDeletion, int nowInSec) {
        ColumnData nextb;
        Row.Deletion rowDeletion;
        LivenessInfo existingInfo;
        Row.Builder builder = BTreeRow.sortedBuilder();
        Clustering clustering = existing.clustering();
        builder.newRow(clustering);
        DeletionTime deletion = update.deletion().time();
        if (rangeDeletion.supersedes(deletion)) {
            deletion = rangeDeletion;
        }
        if (!deletion.deletes(existingInfo = existing.primaryKeyLivenessInfo())) {
            builder.addPrimaryKeyLivenessInfo(existingInfo);
        }
        if (!deletion.supersedes((rowDeletion = existing.deletion()).time())) {
            builder.addRowDeletion(rowDeletion);
        }
        Iterator a = existing.iterator();
        Iterator b = update.iterator();
        ColumnData nexta = a.hasNext() ? (ColumnData)a.next() : null;
        ColumnData columnData = nextb = b.hasNext() ? (ColumnData)b.next() : null;
        while (nexta != null) {
            int comparison;
            int n = comparison = nextb == null ? -1 : nexta.column.compareTo(nextb.column);
            if (comparison <= 0) {
                ColumnData curb;
                ColumnData cura = nexta;
                ColumnDefinition column = cura.column;
                ColumnData columnData2 = curb = comparison == 0 ? nextb : null;
                if (column.isSimple()) {
                    Cells.addNonShadowed((Cell)cura, (Cell)curb, deletion, builder, nowInSec);
                } else {
                    DeletionTime maxDt;
                    ComplexColumnData existingData = (ComplexColumnData)cura;
                    ComplexColumnData updateData = (ComplexColumnData)curb;
                    DeletionTime existingDt = existingData.complexDeletion();
                    DeletionTime updateDt = updateData == null ? DeletionTime.LIVE : updateData.complexDeletion();
                    DeletionTime deletionTime = maxDt = updateDt.supersedes(deletion) ? updateDt : deletion;
                    if (existingDt.supersedes(maxDt)) {
                        builder.addComplexDeletion(column, existingDt);
                        maxDt = existingDt;
                    }
                    Iterator<Cell> existingCells = existingData.iterator();
                    Iterator<Cell> updateCells = updateData == null ? null : updateData.iterator();
                    Cells.addNonShadowedComplex(column, existingCells, updateCells, maxDt, builder, nowInSec);
                }
                ColumnData columnData3 = nexta = a.hasNext() ? (ColumnData)a.next() : null;
                if (curb == null) continue;
                nextb = b.hasNext() ? (ColumnData)b.next() : null;
                continue;
            }
            nextb = b.hasNext() ? (ColumnData)b.next() : null;
        }
        Row row = builder.build();
        return row != null && !row.isEmpty() ? row : null;
    }

    private static ColumnDefinition getColumnDefinition(ColumnData cura, ColumnData curb) {
        if (cura == null) {
            return curb.column;
        }
        if (curb == null) {
            return cura.column;
        }
        if (ColumnDefinitionVersionComparator.INSTANCE.compare(cura.column, curb.column) >= 0) {
            return cura.column;
        }
        return curb.column;
    }
}

