/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CorruptBlockException;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.AbstractReaderFileProxy;
import org.apache.cassandra.io.util.BufferManagingRebufferer;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.ThreadLocalByteBufferHolder;

public abstract class CompressedChunkReader
extends AbstractReaderFileProxy
implements ChunkReader {
    final CompressionMetadata metadata;

    protected CompressedChunkReader(ChannelProxy channel, CompressionMetadata metadata) {
        super(channel, metadata.dataLength);
        this.metadata = metadata;
        assert (Integer.bitCount(metadata.chunkLength()) == 1);
    }

    @Override
    @VisibleForTesting
    public double getCrcCheckChance() {
        return this.metadata.parameters.getCrcCheckChance();
    }

    protected final boolean shouldCheckCrc() {
        return this.getCrcCheckChance() >= 1.0 || this.getCrcCheckChance() > ThreadLocalRandom.current().nextDouble();
    }

    @Override
    public String toString() {
        return String.format("CompressedChunkReader.%s(%s - %s, chunk length %d, data length %d)", this.getClass().getSimpleName(), this.channel.filePath(), this.metadata.compressor().getClass().getSimpleName(), this.metadata.chunkLength(), this.metadata.dataLength);
    }

    @Override
    public int chunkSize() {
        return this.metadata.chunkLength();
    }

    @Override
    public BufferType preferredBufferType() {
        return this.metadata.compressor().preferredBufferType();
    }

    @Override
    public Rebufferer instantiateRebufferer() {
        return new BufferManagingRebufferer.Aligned(this);
    }

    public static class Mmap
    extends CompressedChunkReader {
        protected final MmappedRegions regions;

        public Mmap(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
            super(channel, metadata);
            this.regions = regions;
        }

        @Override
        public void readChunk(long position, ByteBuffer uncompressed) {
            try {
                assert ((position & (long)(-uncompressed.capacity())) == position);
                assert (position <= this.fileLength);
                CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
                MmappedRegions.Region region = this.regions.floor(chunk.offset);
                long segmentOffset = region.offset();
                int chunkOffset = Ints.checkedCast((long)(chunk.offset - segmentOffset));
                ByteBuffer compressedChunk = region.buffer();
                compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                uncompressed.clear();
                if (this.shouldCheckCrc()) {
                    int checksum = (int)this.metadata.checksumType.of(compressedChunk);
                    compressedChunk.limit(compressedChunk.capacity());
                    if (compressedChunk.getInt() != checksum) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk);
                    }
                    compressedChunk.position(chunkOffset).limit(chunkOffset + chunk.length);
                }
                try {
                    this.metadata.compressor().uncompress(compressedChunk, uncompressed);
                }
                catch (IOException e) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk, e);
                }
                finally {
                    uncompressed.flip();
                }
            }
            catch (CorruptBlockException e) {
                throw new CorruptSSTableException((Throwable)e, this.channel.filePath());
            }
        }

        @Override
        public void close() {
            this.regions.closeQuietly();
            super.close();
        }
    }

    public static class Standard
    extends CompressedChunkReader {
        ThreadLocalByteBufferHolder bufferHolder;

        public Standard(ChannelProxy channel, CompressionMetadata metadata) {
            super(channel, metadata);
            this.bufferHolder = new ThreadLocalByteBufferHolder(metadata.compressor().preferredBufferType());
        }

        @Override
        public void readChunk(long position, ByteBuffer uncompressed) {
            try {
                assert ((position & (long)(-uncompressed.capacity())) == position);
                assert (position <= this.fileLength);
                CompressionMetadata.Chunk chunk = this.metadata.chunkFor(position);
                boolean shouldCheckCrc = this.shouldCheckCrc();
                int length = shouldCheckCrc ? chunk.length + 4 : chunk.length;
                ByteBuffer compressed = this.bufferHolder.getBuffer(length);
                if (this.channel.read(compressed, chunk.offset) != length) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk);
                }
                compressed.flip();
                uncompressed.clear();
                compressed.position(0).limit(chunk.length);
                if (shouldCheckCrc) {
                    int checksum = (int)this.metadata.checksumType.of(compressed);
                    compressed.limit(length);
                    if (compressed.getInt() != checksum) {
                        throw new CorruptBlockException(this.channel.filePath(), chunk);
                    }
                    compressed.position(0).limit(chunk.length);
                }
                try {
                    this.metadata.compressor().uncompress(compressed, uncompressed);
                }
                catch (IOException e) {
                    throw new CorruptBlockException(this.channel.filePath(), chunk, e);
                }
                finally {
                    uncompressed.flip();
                }
            }
            catch (CorruptBlockException e) {
                throw new CorruptSSTableException((Throwable)e, this.channel.filePath());
            }
        }
    }
}

