/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.shared;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInputMeta;
import org.apache.hop.pipeline.transforms.kafka.shared.KafkaFactory;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.config.ConfigDef;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;

public class KafkaDialogHelper {
    private IVariables variables;
    private KafkaFactory kafkaFactory;
    private ComboVar wTopic;
    private TextVar wBootstrapServers;
    private TableView optionsTable;
    private TransformMeta parentMeta;

    public KafkaDialogHelper(IVariables variables, ComboVar wTopic, TextVar wBootstrapServers, KafkaFactory kafkaFactory, TableView optionsTable, TransformMeta parentMeta) {
        this.variables = variables;
        this.wTopic = wTopic;
        this.wBootstrapServers = wBootstrapServers;
        this.kafkaFactory = kafkaFactory;
        this.optionsTable = optionsTable;
        this.parentMeta = parentMeta;
    }

    public void clusterNameChanged(Event event) {
        String current = this.wTopic.getText();
        if (StringUtils.isEmpty((String)this.wBootstrapServers.getText())) {
            return;
        }
        String directBootstrapServers = this.wBootstrapServers.getText();
        Map<String, String> config = KafkaDialogHelper.getConfig(this.optionsTable);
        CompletableFuture.supplyAsync(() -> this.listTopics(directBootstrapServers, config)).thenAccept(topicMap -> Display.getDefault().syncExec(() -> this.populateTopics((Map<String, List<PartitionInfo>>)topicMap, current)));
    }

    private void populateTopics(Map<String, List<PartitionInfo>> topicMap, String current) {
        if (!this.wTopic.getCComboWidget().isDisposed()) {
            this.wTopic.getCComboWidget().removeAll();
        }
        topicMap.keySet().stream().filter(key -> !key.startsWith("_")).sorted().forEach(key -> {
            if (!this.wTopic.isDisposed()) {
                this.wTopic.add(key);
            }
        });
        if (!this.wTopic.getCComboWidget().isDisposed()) {
            this.wTopic.getCComboWidget().setText(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<PartitionInfo>> listTopics(String directBootstrapServers, Map<String, String> config) {
        try (Consumer kafkaConsumer = null;){
            KafkaConsumerInputMeta localMeta = new KafkaConsumerInputMeta();
            localMeta.setDirectBootstrapServers(directBootstrapServers);
            localMeta.setConfig(config);
            localMeta.setParentTransformMeta(this.parentMeta);
            kafkaConsumer = this.kafkaFactory.consumer(localMeta, arg_0 -> ((IVariables)this.variables).resolve(arg_0));
            Map map = kafkaConsumer.listTopics();
            return map;
        }
    }

    public static void populateFieldsList(IVariables variables, PipelineMeta pipelineMeta, ComboVar comboVar, String transformName) {
        String current = comboVar.getText();
        comboVar.getCComboWidget().removeAll();
        comboVar.setText(current);
        try {
            IRowMeta rmi = pipelineMeta.getPrevTransformFields(variables, transformName);
            for (int i = 0; i < rmi.size(); ++i) {
                IValueMeta vmb = rmi.getValueMeta(i);
                comboVar.add(vmb.getName());
            }
        }
        catch (HopTransformException ex) {
            LogChannel.UI.logError("Error getting fields", (Throwable)ex);
        }
    }

    public static List<String> getConsumerConfigOptionNames() {
        List<String> optionNames = KafkaDialogHelper.getConfigOptionNames(ConsumerConfig.class);
        Stream.of("bootstrap.servers", "group.id", "value.deserializer", "key.deserializer").forEach(optionNames::remove);
        return optionNames;
    }

    public static List<String> getProducerConfigOptionNames() {
        List<String> optionNames = KafkaDialogHelper.getConfigOptionNames(ProducerConfig.class);
        Stream.of("bootstrap.servers", "client.id", "value.serializer", "key.serializer").forEach(optionNames::remove);
        return optionNames;
    }

    public static List<String> getConsumerAdvancedConfigOptionNames() {
        return Arrays.asList("auto.offset.reset", "ssl.key.password", "ssl.keystore.location", "ssl.keystore.password", "ssl.truststore.location", "ssl.truststore.password");
    }

    public static List<String> getProducerAdvancedConfigOptionNames() {
        return Arrays.asList("compression.type", "ssl.key.password", "ssl.keystore.location", "ssl.keystore.password", "ssl.truststore.location", "ssl.truststore.password");
    }

    private static List<String> getConfigOptionNames(Class cl) {
        return KafkaDialogHelper.getStaticField(cl, "CONFIG").map(config -> ((ConfigDef)config).configKeys().keySet().stream().sorted().collect(Collectors.toList())).orElse(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<Object> getStaticField(Class cl, String fieldName) {
        Field field = null;
        boolean isAccessible = false;
        try {
            field = cl.getDeclaredField(fieldName);
            isAccessible = field.isAccessible();
            field.setAccessible(true);
            Optional<Object> optional = Optional.ofNullable(field.get(null));
            return optional;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Optional<Object> optional = Optional.empty();
            return optional;
        }
        finally {
            if (field != null) {
                field.setAccessible(isAccessible);
            }
        }
    }

    public static Map<String, String> getConfig(TableView optionsTable) {
        int itemCount = optionsTable.getItemCount();
        LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = optionsTable.getTable().getItem(rowIndex);
            String config = row.getText(1);
            String value = row.getText(2);
            if (StringUtils.isBlank((String)config) || advancedConfig.containsKey(config)) continue;
            advancedConfig.put(config, value);
        }
        return advancedConfig;
    }
}

