/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.pipeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.history.AuditManager;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.GuiContextHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypeBase;
import org.apache.hop.ui.hopgui.file.HopFileTypePlugin;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@HopFileTypePlugin(id="HopFile-Pipeline-Plugin", description="The pipeline file information for the Hop GUI", image="ui/images/pipeline.svg")
public class HopPipelineFileType<T extends PipelineMeta>
extends HopFileTypeBase
implements IHopFileType {
    public static final Class<?> PKG = HopPipelineFileType.class;
    public static final String PIPELINE_FILE_TYPE_DESCRIPTION = "Pipeline";
    public static final String ACTION_ID_NEW_PIPELINE = "NewPipeline";

    @Override
    public String getName() {
        return PIPELINE_FILE_TYPE_DESCRIPTION;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".hpl";
    }

    @Override
    public String[] getFilterExtensions() {
        return new String[]{"*.hpl"};
    }

    @Override
    public String[] getFilterNames() {
        return new String[]{"Pipelines"};
    }

    @Override
    public Properties getCapabilities() {
        Properties capabilities = new Properties();
        capabilities.setProperty("New", "true");
        capabilities.setProperty("Close", "true");
        capabilities.setProperty("Start", "true");
        capabilities.setProperty("Stop", "true");
        capabilities.setProperty("Save", "true");
        capabilities.setProperty("SaveAs", "true");
        capabilities.setProperty("ExportToSvg", "true");
        capabilities.setProperty("Pause", "true");
        capabilities.setProperty("Preview", "true");
        capabilities.setProperty("Debug", "true");
        capabilities.setProperty("Copy", "true");
        capabilities.setProperty("Paste", "true");
        capabilities.setProperty("Cut", "true");
        capabilities.setProperty("Delete", "true");
        capabilities.setProperty("FileHistory", "true");
        return capabilities;
    }

    @Override
    public IHopFileTypeHandler openFile(HopGui hopGui, String filename, IVariables parentVariableSpace) throws HopException {
        try {
            HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
            perspective.activate();
            TabItemHandler tabItemHandlerWithFilename = perspective.findTabItemHandlerWithFilename(filename);
            if (tabItemHandlerWithFilename != null) {
                perspective.switchToTab(tabItemHandlerWithFilename);
                return tabItemHandlerWithFilename.getTypeHandler();
            }
            PipelineMeta pipelineMeta = new PipelineMeta(filename, (IHopMetadataProvider)hopGui.getMetadataProvider(), true, parentVariableSpace);
            pipelineMeta.setMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
            IHopFileTypeHandler typeHandler = perspective.addPipeline(hopGui, pipelineMeta, this);
            AuditManager.registerEvent((String)HopNamespace.getNamespace(), (String)"file", (String)filename, (String)"open");
            ExtensionPointHandler.callExtensionPoint((ILogChannel)hopGui.getLog(), (IVariables)parentVariableSpace, (String)HopExtensionPoint.PipelineAfterOpen.id, (Object)pipelineMeta);
            return typeHandler;
        }
        catch (Exception e) {
            throw new HopException("Error opening pipeline file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public IHopFileTypeHandler newFile(HopGui hopGui, IVariables parentVariableSpace) throws HopException {
        try {
            HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
            perspective.activate();
            PipelineMeta pipelineMeta = new PipelineMeta();
            pipelineMeta.setName(BaseMessages.getString(PKG, (String)"HopPipelineFileType.New.Text", (String[])new String[0]));
            pipelineMeta.setMetadataProvider((IHopMetadataProvider)hopGui.getMetadataProvider());
            return perspective.addPipeline(hopGui, pipelineMeta, this);
        }
        catch (Exception e) {
            throw new HopException("Error creating new pipeline", (Throwable)e);
        }
    }

    @Override
    public boolean isHandledBy(String filename, boolean checkContent) throws HopException {
        try {
            if (checkContent) {
                Document document = XmlHandler.loadXmlFile((String)filename);
                Node pipelineNode = XmlHandler.getSubNode((Node)document, (String)"pipeline");
                return pipelineNode != null;
            }
            return super.isHandledBy(filename, checkContent);
        }
        catch (Exception e) {
            throw new HopException("Unable to verify file handling of file '" + filename + "'", (Throwable)e);
        }
    }

    @Override
    public boolean supportsFile(IHasFilename metaObject) {
        return metaObject instanceof PipelineMeta;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        HopGui hopGui = HopGui.getInstance();
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        GuiAction newAction = new GuiAction(ACTION_ID_NEW_PIPELINE, GuiActionType.Create, BaseMessages.getString(PKG, (String)"HopPipelineFileType.GuiAction.Pipeline.Name", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopPipelineFileType.GuiAction.Pipeline.Tooltip", (String[])new String[0]), "ui/images/pipeline.svg", (shiftClicked, controlClicked, parameters) -> {
            try {
                this.newFile(hopGui, hopGui.getVariables());
            }
            catch (Exception e) {
                new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"HopPipelineFileType.ErrorDialog.PipelineDrawing.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"HopPipelineFileType.ErrorDialog.PipelineDrawing.Message", (String[])new String[0]), e);
            }
        });
        newAction.setCategory("File");
        newAction.setCategoryOrder("1");
        handlers.add(new GuiContextHandler(ACTION_ID_NEW_PIPELINE, Arrays.asList(newAction)));
        return handlers;
    }

    @Override
    public String getFileTypeImage() {
        return "ui/images/pipeline.svg";
    }
}

