/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.workflow.actions.missing;

import java.util.List;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.missing.MissingAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MissingActionDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = MissingActionDialog.class;
    private Shell shell;
    private List<MissingAction> missingActions;
    private int mode;
    protected IAction action;
    public static final int MISSING_ACTIONS = 1;
    public static final int MISSING_ACTION_ID = 2;

    public MissingActionDialog(Shell parent, List<MissingAction> missingActions) {
        super(parent, null, HopGui.getInstance().getVariables());
        this.missingActions = missingActions;
        this.mode = 1;
    }

    public MissingActionDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        this.mode = 2;
    }

    private String getErrorMessage(List<MissingAction> missingEntries, int mode) {
        String message = "";
        if (mode == 1) {
            StringBuilder entries = new StringBuilder();
            for (MissingAction action : missingEntries) {
                if (missingEntries.indexOf(action) == missingEntries.size() - 1) {
                    entries.append("- " + action.getName() + " - " + action.getMissingPluginId() + "\n\n");
                    continue;
                }
                entries.append("- " + action.getName() + " - " + action.getMissingPluginId() + "\n");
            }
            message = BaseMessages.getString(PKG, (String)"MissingActionDialog.MissingActions", (String[])new String[]{entries.toString()});
        }
        if (mode == 2) {
            message = BaseMessages.getString(PKG, (String)"MissingActionDialog.MissingActionId", (String[])new String[]{this.action.getName() + " - " + ((MissingAction)this.action).getMissingPluginId()});
        }
        return message;
    }

    public IAction open() {
        PropsUi props = PropsUi.getInstance();
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 67681);
        props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginLeft = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"MissingActionDialog.MissingPlugins", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        Label image = new Label((Composite)this.shell, 0);
        props.setLook((Control)image);
        Image icon = display.getSystemImage(4);
        image.setImage(icon);
        FormData imageData = new FormData();
        imageData.left = new FormAttachment(0, 5);
        imageData.right = new FormAttachment(11, 0);
        imageData.top = new FormAttachment(0, 10);
        image.setLayoutData((Object)imageData);
        Label error = new Label((Composite)this.shell, 64);
        props.setLook((Control)error);
        error.setText(this.getErrorMessage(this.missingActions, this.mode));
        FormData errorData = new FormData();
        errorData.left = new FormAttachment((Control)image, 5);
        errorData.right = new FormAttachment(100, -5);
        errorData.top = new FormAttachment(0, 10);
        error.setLayoutData((Object)errorData);
        Label separator = new Label((Composite)this.shell, 64);
        props.setLook((Control)separator);
        FormData separatorData = new FormData();
        separatorData.top = new FormAttachment((Control)error, 10);
        separator.setLayoutData((Object)separatorData);
        Button closeButton = new Button((Composite)this.shell, 8);
        props.setLook((Control)closeButton);
        FormData fdClose = new FormData();
        fdClose.right = new FormAttachment(98);
        fdClose.top = new FormAttachment((Control)separator);
        closeButton.setLayoutData((Object)fdClose);
        closeButton.setText(BaseMessages.getString(PKG, (String)"MissingActionDialog.Close", (String[])new String[0]));
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingActionDialog.this.close();
            }
        });
        FormData fdSearch = new FormData();
        if (this.mode == 1) {
            Button openButton = new Button((Composite)this.shell, 8);
            props.setLook((Control)openButton);
            FormData fdOpen = new FormData();
            fdOpen.right = new FormAttachment((Control)closeButton, -5);
            fdOpen.bottom = new FormAttachment((Control)closeButton, 0, 1024);
            openButton.setLayoutData((Object)fdOpen);
            openButton.setText(BaseMessages.getString(PKG, (String)"MissingActionDialog.OpenFile", (String[])new String[0]));
            openButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MissingActionDialog.this.openFile();
                }
            });
            fdSearch.right = new FormAttachment((Control)openButton, -5);
            fdSearch.bottom = new FormAttachment((Control)openButton, 0, 1024);
        } else {
            fdSearch.right = new FormAttachment((Control)closeButton, -5);
            fdSearch.bottom = new FormAttachment((Control)closeButton, 0, 1024);
        }
        Button searchButton = new Button((Composite)this.shell, 8);
        props.setLook((Control)searchButton);
        searchButton.setText(BaseMessages.getString(PKG, (String)"MissingActionDialog.SearchMarketplace", (String[])new String[0]));
        searchButton.setLayoutData((Object)fdSearch);
        searchButton.setEnabled(false);
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MissingActionDialog.this.searchMarketplace();
            }
        });
        BaseDialog.defaultShellHandling(this.shell, c -> this.openFile(), c -> this.close());
        return this.action;
    }

    private void searchMarketplace() {
        try {
            this.shell.dispose();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openFile() {
        this.shell.dispose();
        this.action = new MissingAction();
    }

    private void close() {
        this.shell.dispose();
        this.action = null;
    }
}

