/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.BlobType;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CopyState;
import com.microsoft.azure.storage.blob.CopyStatus;
import com.microsoft.azure.storage.blob.LeaseDuration;
import com.microsoft.azure.storage.blob.LeaseState;
import com.microsoft.azure.storage.blob.LeaseStatus;
import com.microsoft.azure.storage.blob.ListBlobsResponse;
import com.microsoft.azure.storage.blob.PremiumPageBlobTier;
import com.microsoft.azure.storage.blob.RehydrationStatus;
import com.microsoft.azure.storage.blob.StandardBlobTier;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class BlobListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ListBlobsResponse response = new ListBlobsResponse();
    private final CloudBlobContainer container;
    private BlobProperties properties;
    private HashMap<String, String> metadata;
    private CopyState copyState;
    private String blobName;
    private String snapshotID;
    private boolean deleted;

    private BlobListHandler(CloudBlobContainer container) {
        this.container = container;
    }

    public static ListBlobsResponse getBlobList(InputStream stream, CloudBlobContainer container) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        BlobListHandler handler = new BlobListHandler(container);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("Blob".equals(localName) || "BlobPrefix".equals(localName)) {
            this.blobName = "";
            this.snapshotID = null;
            this.properties = new BlobProperties();
            this.metadata = new HashMap();
            this.copyState = null;
            this.deleted = false;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Blob".equals(currentNode)) {
            CloudBlob retBlob;
            block42: {
                retBlob = null;
                try {
                    if (this.properties.getBlobType() == BlobType.BLOCK_BLOB) {
                        retBlob = this.container.getBlockBlobReference(this.blobName);
                        break block42;
                    }
                    if (this.properties.getBlobType() == BlobType.PAGE_BLOB) {
                        retBlob = this.container.getPageBlobReference(this.blobName);
                        break block42;
                    }
                    if (this.properties.getBlobType() == BlobType.APPEND_BLOB) {
                        retBlob = this.container.getAppendBlobReference(this.blobName);
                        break block42;
                    }
                    throw new SAXException("The response received is invalid or improperly formatted.");
                }
                catch (StorageException e) {
                    throw new SAXException(e);
                }
                catch (URISyntaxException e) {
                    throw new SAXException(e);
                }
            }
            retBlob.snapshotID = this.snapshotID;
            retBlob.properties = this.properties;
            retBlob.metadata = this.metadata;
            retBlob.properties.setCopyState(this.copyState);
            retBlob.deleted = this.deleted;
            this.response.getResults().add(retBlob);
        } else if ("BlobPrefix".equals(currentNode)) {
            try {
                this.response.getResults().add(this.container.getDirectoryReference(this.blobName));
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("Prefix".equals(currentNode)) {
                this.response.setPrefix(value);
            } else if ("Marker".equals(currentNode)) {
                this.response.setMarker(value);
            } else if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            } else if ("MaxResults".equals(currentNode)) {
                this.response.setMaxResults(Integer.parseInt(value));
            } else if ("Delimiter".equals(currentNode)) {
                this.response.setDelimiter(value);
            }
        } else if ("Blob".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.blobName = value;
            } else if ("Snapshot".equals(currentNode)) {
                this.snapshotID = value;
            } else if ("Deleted".equals(currentNode)) {
                this.deleted = Boolean.parseBoolean(value);
            }
        } else if ("BlobPrefix".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.blobName = value;
            }
        } else if ("Properties".equals(parentNode)) {
            try {
                this.setProperties(currentNode, value);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
        } else if ("Metadata".equals(parentNode)) {
            this.metadata.put(currentNode, value);
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setProperties(String currentNode, String value) throws ParseException, URISyntaxException, SAXException {
        if ("Last-Modified".equals(currentNode)) {
            this.properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if ("Etag".equals(currentNode)) {
            this.properties.setEtag(Utility.formatETag(value));
            return;
        } else if ("Content-Length".equals(currentNode)) {
            this.properties.setLength(Long.parseLong(value));
            return;
        } else if ("Content-Type".equals(currentNode)) {
            this.properties.setContentType(value);
            return;
        } else if ("Content-Encoding".equals(currentNode)) {
            this.properties.setContentEncoding(value);
            return;
        } else if ("Content-Language".equals(currentNode)) {
            this.properties.setContentLanguage(value);
            return;
        } else if ("Content-MD5".equals(currentNode)) {
            this.properties.setContentMD5(value);
            return;
        } else if ("Cache-Control".equals(currentNode)) {
            this.properties.setCacheControl(value);
            return;
        } else if ("Content-Disposition".equals(currentNode)) {
            this.properties.setContentDisposition(value);
            return;
        } else if ("BlobType".equals(currentNode)) {
            String tempString = value;
            if (tempString.equals("BlockBlob")) {
                this.properties.setBlobType(BlobType.BLOCK_BLOB);
                return;
            } else if (tempString.equals("PageBlob".toString())) {
                this.properties.setBlobType(BlobType.PAGE_BLOB);
                return;
            } else {
                if (!tempString.equals("AppendBlob".toString())) throw new SAXException("The response received is invalid or improperly formatted.");
                this.properties.setBlobType(BlobType.APPEND_BLOB);
            }
            return;
        } else if ("LeaseStatus".equals(currentNode)) {
            LeaseStatus tempStatus = LeaseStatus.parse(value);
            if (tempStatus.equals((Object)LeaseStatus.UNSPECIFIED)) return;
            this.properties.setLeaseStatus(tempStatus);
            return;
        } else if ("LeaseState".equals(currentNode)) {
            LeaseState tempState = LeaseState.parse(value);
            if (tempState.equals((Object)LeaseState.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.properties.setLeaseState(tempState);
            return;
        } else if ("LeaseDuration".equals(currentNode)) {
            LeaseDuration tempDuration = LeaseDuration.parse(value);
            if (tempDuration.equals((Object)LeaseDuration.UNSPECIFIED)) throw new SAXException("The response received is invalid or improperly formatted.");
            this.properties.setLeaseDuration(tempDuration);
            return;
        } else if ("ServerEncrypted".equals(currentNode)) {
            this.properties.setServerEncrypted("true".equals(value));
            return;
        } else if ("CopyId".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setCopyId(value);
            return;
        } else if ("CopyCompletionTime".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if ("CopyStatus".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setStatus(CopyStatus.parse(value));
            return;
        } else if ("CopySource".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setSource(new URI(value));
            return;
        } else if ("CopyProgress".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            String tempString = value;
            String[] progressSequence = tempString.split("/");
            this.copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
            this.copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
            return;
        } else if ("CopyStatusDescription".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setStatusDescription(value);
            return;
        } else if ("IncrementalCopy".equals(currentNode)) {
            this.properties.setIncrementalCopy("true".equals(value));
            return;
        } else if ("CopyDestinationSnapshot".equals(currentNode)) {
            if (this.copyState == null) {
                this.copyState = new CopyState();
            }
            this.copyState.setCopyDestinationSnapshotID(value);
            return;
        } else if ("AccessTier".equals(currentNode)) {
            if (this.properties.getBlobType().equals((Object)BlobType.PAGE_BLOB)) {
                PremiumPageBlobTier premiumPageBlobTier = PremiumPageBlobTier.parse(value);
                this.properties.setPremiumPageBlobTier(premiumPageBlobTier);
                return;
            } else if (this.properties.getBlobType().equals((Object)BlobType.BLOCK_BLOB)) {
                StandardBlobTier standardBlobTier = StandardBlobTier.parse(value);
                this.properties.setStandardBlobTier(standardBlobTier);
                return;
            } else {
                if (!this.properties.getBlobType().equals((Object)BlobType.UNSPECIFIED)) return;
                PremiumPageBlobTier premiumPageBlobTier = PremiumPageBlobTier.parse(value);
                StandardBlobTier standardBlobTier = StandardBlobTier.parse(value);
                if (!premiumPageBlobTier.equals((Object)PremiumPageBlobTier.UNKNOWN)) {
                    this.properties.setPremiumPageBlobTier(premiumPageBlobTier);
                    return;
                } else if (!standardBlobTier.equals((Object)StandardBlobTier.UNKNOWN)) {
                    this.properties.setStandardBlobTier(standardBlobTier);
                    return;
                } else {
                    this.properties.setPremiumPageBlobTier(PremiumPageBlobTier.UNKNOWN);
                    this.properties.setStandardBlobTier(StandardBlobTier.UNKNOWN);
                }
            }
            return;
        } else if ("AccessTierInferred".equals(currentNode)) {
            this.properties.setBlobTierInferred(Boolean.parseBoolean(value));
            return;
        } else if ("AccessTierChangeTime".equals(currentNode)) {
            this.properties.setTierChangeTime(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if ("ArchiveStatus".equals(currentNode)) {
            this.properties.setRehydrationStatus(RehydrationStatus.parse(value));
            return;
        } else if ("DeletedTime".equals(currentNode)) {
            this.properties.setDeletedTime(Utility.parseRFC1123DateFromStringInGMT(value));
            return;
        } else if ("RemainingRetentionDays".equals(currentNode)) {
            this.properties.setRemainingRetentionDays(Integer.parseInt(value));
            return;
        } else {
            if (!"Creation-Time".equals(currentNode)) return;
            this.properties.setCreatedTime(Utility.parseRFC1123DateFromStringInGMT(value));
        }
    }
}

