/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.reflection.pipeline.xp;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.TransformMetaDataCombi;
import org.apache.hop.reflection.pipeline.meta.PipelineLog;
import org.apache.hop.reflection.pipeline.meta.PipelineToLogLocation;
import org.apache.hop.reflection.pipeline.transform.PipelineLogging;

@ExtensionPoint(id="PipelineStartLoggingXp", extensionPointId="PipelinePrepareExecution", description="At the start of a pipeline, handle any Pipeline Log metadata objects")
public class PipelineStartLoggingXp
implements IExtensionPoint<Pipeline> {
    public static final String PIPELINE_LOGGING_FLAG = "PipelineLoggingActive";

    public void callExtensionPoint(ILogChannel log, IVariables variables, Pipeline pipeline) throws HopException {
        if (pipeline.getExtensionDataMap().get(PIPELINE_LOGGING_FLAG) != null) {
            return;
        }
        if (pipeline.isPreview()) {
            return;
        }
        IHopMetadataProvider metadataProvider = pipeline.getMetadataProvider();
        IHopMetadataSerializer serializer = metadataProvider.getSerializer(PipelineLog.class);
        List pipelineLogs = serializer.loadAll();
        for (PipelineLog pipelineLog : pipelineLogs) {
            this.handlePipelineLog(log, pipelineLog, (IPipelineEngine<PipelineMeta>)pipeline, variables);
        }
    }

    private void handlePipelineLog(ILogChannel log, PipelineLog pipelineLog, IPipelineEngine<PipelineMeta> pipeline, IVariables variables) throws HopException {
        if (!pipelineLog.isEnabled()) {
            return;
        }
        if (pipelineLog.isLoggingParentsOnly() && (pipeline.getParentWorkflow() != null || pipeline.getParentPipeline() != null)) {
            return;
        }
        String loggingPipelineFilename = variables.resolve(pipelineLog.getPipelineFilename());
        FileObject loggingFileObject = HopVfs.getFileObject((String)loggingPipelineFilename);
        try {
            if (!loggingFileObject.exists()) {
                log.logBasic("WARNING: The Pipeline Log pipeline file '" + loggingPipelineFilename + "' couldn't be found to execute.");
                return;
            }
        }
        catch (Exception e) {
            pipeline.stopAll();
            throw new HopException("Error handling Pipeline Log metadata object '" + pipelineLog.getName() + "' at the start of pipeline: " + pipeline, (Throwable)e);
        }
        if (pipelineLog.getPipelinesToLog().isEmpty()) {
            this.logPipeline(pipelineLog, pipeline, loggingPipelineFilename, variables);
        } else {
            for (PipelineToLogLocation pipelineToLogLocation : pipelineLog.getPipelinesToLog()) {
                String pipelineToLogUri;
                String pipelineUri = HopVfs.getFileObject((String)pipeline.getFilename()).getPublicURIString();
                if (!pipelineUri.equals(pipelineToLogUri = HopVfs.getFileObject((String)variables.resolve(pipelineToLogLocation.getPipelineToLogFilename())).getPublicURIString())) continue;
                this.logPipeline(pipelineLog, pipeline, loggingPipelineFilename, variables);
            }
        }
    }

    private void logPipeline(final PipelineLog pipelineLog, final IPipelineEngine<PipelineMeta> pipeline, final String loggingPipelineFilename, final IVariables variables) throws HopException {
        try {
            int intervalInSeconds;
            Timer timer = new Timer();
            if (pipelineLog.isExecutingAtStart()) {
                this.executeLoggingPipeline(pipelineLog, "start", loggingPipelineFilename, pipeline, variables);
            }
            if (pipelineLog.isExecutingAtEnd()) {
                pipeline.addExecutionFinishedListener(engine -> {
                    this.executeLoggingPipeline(pipelineLog, "end", loggingPipelineFilename, pipeline, variables);
                    timer.cancel();
                });
                pipeline.addExecutionStoppedListener(engine -> {
                    try {
                        this.executeLoggingPipeline(pipelineLog, "stop", loggingPipelineFilename, pipeline, variables);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to do interval logging for Pipeline Log object '" + pipelineLog.getName() + "'", e);
                    }
                    timer.cancel();
                });
            }
            if (pipelineLog.isExecutingPeriodically() && (intervalInSeconds = Const.toInt((String)variables.resolve(pipelineLog.getIntervalInSeconds()), (int)-1)) > 0) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            PipelineStartLoggingXp.this.executeLoggingPipeline(pipelineLog, "interval", loggingPipelineFilename, (IPipelineEngine<PipelineMeta>)pipeline, variables);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Unable to do interval logging for Pipeline Log object '" + pipelineLog.getName() + "'", e);
                        }
                    }
                };
                timer.schedule(timerTask, (long)intervalInSeconds * 1000L, (long)intervalInSeconds * 1000L);
            }
        }
        catch (Exception e) {
            pipeline.stopAll();
            throw new HopException("Error handling Pipeline Log metadata object '" + pipelineLog.getName() + "' at the start of pipeline: " + pipeline, (Throwable)e);
        }
    }

    private synchronized void executeLoggingPipeline(PipelineLog pipelineLog, String loggingPhase, String loggingPipelineFilename, IPipelineEngine<PipelineMeta> pipeline, IVariables variables) throws HopException {
        PipelineMeta loggingPipelineMeta = new PipelineMeta(loggingPipelineFilename, pipeline.getMetadataProvider(), true, variables);
        LocalPipelineEngine loggingPipeline = new LocalPipelineEngine(loggingPipelineMeta, variables, pipeline);
        loggingPipeline.getExtensionDataMap().put(PIPELINE_LOGGING_FLAG, "Y");
        loggingPipeline.setLogLevel(LogLevel.ERROR);
        loggingPipeline.prepareExecution();
        for (TransformMetaDataCombi combi : loggingPipeline.getTransforms()) {
            if (!(combi.transform instanceof PipelineLogging)) continue;
            PipelineLogging pipelineLogging = (PipelineLogging)combi.transform;
            pipelineLogging.setLoggingPipeline(pipeline);
            pipelineLogging.setLoggingPhase(loggingPhase);
        }
        loggingPipeline.startThreads();
        loggingPipeline.waitUntilFinished();
    }
}

