/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public final class ClickHouseChecker {
    private static final String DEFAULT_NAME = "value";
    private static final String ERR_SHOULD_BETWEEN = "%s(%s) should between %s and %s inclusive of both values";
    private static final String ERR_SHOULD_BETWEEN_EXCLUSIVE = "%s(%s) should between %s and %s exclusive of both values";
    private static final String ERR_SHOULD_GE = "%s(%s) should NOT less than %s";

    static final IllegalArgumentException newException(String format, Object ... args) {
        return new IllegalArgumentException(String.format(Locale.ROOT, format, args));
    }

    public static int between(int value, int minValue, int maxValue) {
        return ClickHouseChecker.between(value, DEFAULT_NAME, minValue, maxValue);
    }

    public static long between(long value, long minValue, long maxValue) {
        return ClickHouseChecker.between(value, DEFAULT_NAME, minValue, maxValue);
    }

    public static int between(byte value, String name, byte minValue, byte maxValue) {
        if (value < minValue || value > maxValue) {
            throw ClickHouseChecker.newException(ERR_SHOULD_BETWEEN, name, value, minValue, maxValue);
        }
        return value;
    }

    public static int between(int value, String name, int minValue, int maxValue) {
        if (value < minValue || value > maxValue) {
            throw ClickHouseChecker.newException(ERR_SHOULD_BETWEEN, name, value, minValue, maxValue);
        }
        return value;
    }

    public static long between(long value, String name, long minValue, long maxValue) {
        if (value < minValue || value > maxValue) {
            throw ClickHouseChecker.newException(ERR_SHOULD_BETWEEN, name, value, minValue, maxValue);
        }
        return value;
    }

    public static BigInteger between(BigInteger value, BigInteger minValue, BigInteger maxValue) {
        return ClickHouseChecker.between(value, DEFAULT_NAME, minValue, maxValue);
    }

    public static BigInteger between(BigInteger value, String name, BigInteger minValue, BigInteger maxValue) {
        if (value.compareTo(minValue) < 0 || value.compareTo(maxValue) > 0) {
            throw ClickHouseChecker.newException(ERR_SHOULD_BETWEEN, name, value, minValue, maxValue);
        }
        return value;
    }

    public static BigDecimal between(BigDecimal value, BigDecimal minValue, BigDecimal maxValue) {
        return ClickHouseChecker.between(value, DEFAULT_NAME, minValue, maxValue);
    }

    public static BigDecimal between(BigDecimal value, String name, BigDecimal minValue, BigDecimal maxValue) {
        if (value.compareTo(minValue) <= 0 || value.compareTo(maxValue) >= 0) {
            throw ClickHouseChecker.newException(ERR_SHOULD_BETWEEN_EXCLUSIVE, name, value, minValue, maxValue);
        }
        return value;
    }

    public static boolean isNullOrEmpty(CharSequence value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNullOrBlank(CharSequence value) {
        if (ClickHouseChecker.isNullOrEmpty(value)) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String nonBlank(String value, String name) {
        if (ClickHouseChecker.isNullOrBlank(value)) {
            throw ClickHouseChecker.newException("%s cannot be null, empty or blank string", name);
        }
        return value;
    }

    public static String nonEmpty(String value, String name) {
        if (ClickHouseChecker.isNullOrEmpty(value)) {
            throw ClickHouseChecker.newException("%s cannot be null or empty string", name);
        }
        return value;
    }

    public static final <T> T nonNull(T value, String name) {
        if (value == null) {
            throw ClickHouseChecker.newException("Non-null %s is required", name);
        }
        return value;
    }

    public static int notLessThan(int value, String name, int minValue) {
        if (value < minValue) {
            throw ClickHouseChecker.newException(ERR_SHOULD_GE, name, value, minValue);
        }
        return value;
    }

    public static long notLessThan(long value, String name, long minValue) {
        if (value < minValue) {
            throw ClickHouseChecker.newException(ERR_SHOULD_GE, name, value, minValue);
        }
        return value;
    }

    public static BigInteger notLessThan(BigInteger value, String name, BigInteger minValue) {
        if (value.compareTo(minValue) < 0) {
            throw ClickHouseChecker.newException(ERR_SHOULD_GE, name, value, minValue);
        }
        return value;
    }

    public static byte[] notLongerThan(byte[] value, String name, int maxLength) {
        int length;
        int n = length = value == null ? 0 : value.length;
        if (length > maxLength) {
            throw ClickHouseChecker.newException("length of byte array %s is %d, which should NOT longer than %d", name, length, maxLength);
        }
        return value;
    }

    public static byte[] notWithDifferentLength(byte[] value, int expectedLength) {
        return ClickHouseChecker.notWithDifferentLength(value, DEFAULT_NAME, expectedLength);
    }

    public static byte[] notWithDifferentLength(byte[] value, String name, int expectedLength) {
        int length;
        int n = length = value == null ? 0 : value.length;
        if (length != expectedLength) {
            throw ClickHouseChecker.newException("length of byte array %s is %d, but it should be %d", name, length, expectedLength);
        }
        return value;
    }

    public static String notWithDifferentLength(String value, int expectedLength) {
        return ClickHouseChecker.notWithDifferentLength(value, null, DEFAULT_NAME, expectedLength);
    }

    public static String notWithDifferentLength(String value, Charset charset, int expectedLength) {
        return ClickHouseChecker.notWithDifferentLength(value, charset, DEFAULT_NAME, expectedLength);
    }

    public static String notWithDifferentLength(String value, Charset charset, String name, int expectedLength) {
        int length;
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        int n = length = value == null ? 0 : value.getBytes(charset).length;
        if (length != expectedLength) {
            throw ClickHouseChecker.newException("length of byte array %s is %d, but it should be %d", name, length, expectedLength);
        }
        return value;
    }

    private ClickHouseChecker() {
    }
}

