/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseClient;
import com.clickhouse.client.ClickHouseCompression;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseDeferredValue;
import com.clickhouse.client.ClickHouseException;
import com.clickhouse.client.ClickHouseFormat;
import com.clickhouse.client.ClickHouseInputStream;
import com.clickhouse.client.ClickHouseNode;
import com.clickhouse.client.ClickHouseNodeSelector;
import com.clickhouse.client.ClickHouseParameterizedQuery;
import com.clickhouse.client.ClickHouseResponse;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.config.ClickHouseClientOption;
import com.clickhouse.client.config.ClickHouseConfigChangeListener;
import com.clickhouse.client.config.ClickHouseOption;
import com.clickhouse.client.data.ClickHouseExternalTable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ClickHouseRequest<SelfT extends ClickHouseRequest<SelfT>>
implements Serializable {
    private static final String TYPE_EXTERNAL_TABLE = "ExternalTable";
    private static final long serialVersionUID = 4990313525960702287L;
    static final String PROP_DATA = "data";
    static final String PROP_PREPARED_QUERY = "preparedQuery";
    static final String PROP_QUERY = "query";
    static final String PROP_QUERY_ID = "queryId";
    private final boolean sealed;
    private transient ClickHouseClient client;
    protected final ClickHouseConfig clientConfig;
    protected final Function<ClickHouseNodeSelector, ClickHouseNode> server;
    protected final transient List<ClickHouseExternalTable> externalTables;
    protected final Map<ClickHouseOption, Serializable> options;
    protected final Map<String, Serializable> settings;
    protected final Map<String, String> namedParameters;
    protected transient ClickHouseDeferredValue<ClickHouseInputStream> input;
    protected String queryId;
    protected String sql;
    protected ClickHouseParameterizedQuery preparedQuery;
    protected transient ClickHouseConfigChangeListener<ClickHouseRequest<?>> changeListener;
    protected transient ClickHouseConfig config;
    protected transient List<String> statements;

    protected ClickHouseRequest(ClickHouseClient client, Function<ClickHouseNodeSelector, ClickHouseNode> server, boolean sealed) {
        if (client == null || server == null) {
            throw new IllegalArgumentException("Non-null client and server are required");
        }
        this.client = client;
        this.clientConfig = client.getConfig();
        this.server = server::apply;
        this.sealed = sealed;
        this.externalTables = new LinkedList<ClickHouseExternalTable>();
        this.options = new HashMap<ClickHouseOption, Serializable>();
        this.settings = new LinkedHashMap<String, Serializable>();
        this.namedParameters = new HashMap<String, String>();
    }

    protected <T> T changeProperty(String property, T oldValue, T newValue) {
        if (this.changeListener != null && !Objects.equals(oldValue, newValue)) {
            this.changeListener.propertyChanged(this, property, oldValue, newValue);
        }
        return newValue;
    }

    protected void checkSealed() {
        if (this.sealed) {
            throw new IllegalStateException("Sealed request is immutable");
        }
    }

    protected ClickHouseClient getClient() {
        if (this.client == null) {
            this.client = ClickHouseClient.builder().config(this.clientConfig).build();
        }
        return this.client;
    }

    protected String getQuery() {
        return this.sql;
    }

    protected void resetCache() {
        if (this.config != null) {
            this.config = null;
        }
        if (this.statements != null) {
            this.statements = null;
        }
    }

    public ClickHouseRequest<SelfT> copy() {
        ClickHouseRequest<SelfT> req = new ClickHouseRequest<SelfT>(this.getClient(), this.server, false);
        req.externalTables.addAll(this.externalTables);
        req.options.putAll(this.options);
        req.settings.putAll(this.settings);
        req.namedParameters.putAll(this.namedParameters);
        req.input = this.input;
        req.queryId = this.queryId;
        req.sql = this.sql;
        req.preparedQuery = this.preparedQuery;
        return req;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public boolean hasInputStream() {
        return this.input != null || !this.externalTables.isEmpty();
    }

    public final ClickHouseNode getServer() {
        return this.server.apply(this.getConfig().getNodeSelector());
    }

    public ClickHouseConfig getConfig() {
        if (this.config == null) {
            if (this.options.isEmpty()) {
                this.config = this.clientConfig;
            } else {
                HashMap<ClickHouseOption, Serializable> merged = new HashMap<ClickHouseOption, Serializable>();
                merged.putAll(this.clientConfig.getAllOptions());
                merged.putAll(this.options);
                this.config = new ClickHouseConfig(merged, this.clientConfig.getDefaultCredentials(), this.clientConfig.getNodeSelector(), this.clientConfig.getMetricRegistry().orElse(null));
            }
        }
        return this.config;
    }

    public final SelfT setChangeListener(ClickHouseConfigChangeListener<ClickHouseRequest<?>> listener) {
        this.changeListener = listener;
        return (SelfT)this;
    }

    public Optional<ClickHouseInputStream> getInputStream() {
        return this.input != null ? this.input.getOptional() : Optional.empty();
    }

    public List<ClickHouseExternalTable> getExternalTables() {
        return Collections.unmodifiableList(this.externalTables);
    }

    public ClickHouseFormat getFormat() {
        return this.getConfig().getFormat();
    }

    public ClickHouseFormat getInputFormat() {
        ClickHouseFormat format = this.getFormat();
        return this.options.containsKey(ClickHouseClientOption.FORMAT) ? format : format.defaultInputFormat();
    }

    public Optional<String> getQueryId() {
        return ClickHouseChecker.isNullOrEmpty(this.queryId) ? Optional.empty() : Optional.of(this.queryId);
    }

    public ClickHouseParameterizedQuery getPreparedQuery() {
        if (this.preparedQuery == null) {
            this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, ClickHouseParameterizedQuery.of(this.getConfig(), this.getQuery()));
        }
        return this.preparedQuery;
    }

    public Map<String, Object> getSettings() {
        return Collections.unmodifiableMap(this.settings);
    }

    public Optional<String> getSessionId() {
        String sessionId = (String)((Object)this.getConfig().getOption(ClickHouseClientOption.SESSION_ID));
        return ClickHouseChecker.isNullOrEmpty(sessionId) ? Optional.empty() : Optional.of(sessionId);
    }

    public List<String> getStatements() {
        return this.getStatements(true);
    }

    public List<String> getStatements(boolean withSettings) {
        if (this.statements == null) {
            String stmt;
            this.statements = new ArrayList<String>();
            if (withSettings) {
                for (Map.Entry<String, Serializable> entry : this.settings.entrySet()) {
                    Serializable value = entry.getValue();
                    StringBuilder sb = new StringBuilder().append("SET ").append(entry.getKey()).append('=');
                    if (value instanceof String) {
                        sb.append('\'').append(value).append('\'');
                    } else if (value instanceof Boolean) {
                        sb.append((Boolean)value != false ? 1 : 0);
                    } else {
                        sb.append(value);
                    }
                    this.statements.add(sb.toString());
                }
            }
            if (!ClickHouseChecker.isNullOrEmpty(stmt = this.getQuery())) {
                StringBuilder builder = new StringBuilder();
                if (this.preparedQuery == null) {
                    ClickHouseParameterizedQuery.apply(builder, stmt, this.namedParameters);
                } else {
                    this.preparedQuery.apply(builder, this.namedParameters);
                }
                this.statements.add(builder.toString());
            }
        }
        return Collections.unmodifiableList(this.statements);
    }

    public SelfT compressServerResponse(boolean enable) {
        return this.compressServerResponse(enable, null, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(boolean enable, ClickHouseCompression compressAlgorithm) {
        return this.compressServerResponse(enable, compressAlgorithm, (Integer)ClickHouseClientOption.COMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT compressServerResponse(boolean enable, ClickHouseCompression compressAlgorithm, int compressLevel) {
        this.checkSealed();
        if (compressAlgorithm == null) {
            ClickHouseCompression clickHouseCompression = compressAlgorithm = enable ? (ClickHouseCompression)((Object)ClickHouseClientOption.COMPRESS_ALGORITHM.getEffectiveDefaultValue()) : ClickHouseCompression.NONE;
        }
        if (compressLevel < 0) {
            compressLevel = 0;
        } else if (compressLevel > 9) {
            compressLevel = 9;
        }
        this.option(ClickHouseClientOption.COMPRESS, Boolean.valueOf(enable));
        this.option(ClickHouseClientOption.COMPRESS_ALGORITHM, (Serializable)((Object)compressAlgorithm));
        this.option(ClickHouseClientOption.COMPRESS_LEVEL, Integer.valueOf(compressLevel));
        return (SelfT)this;
    }

    public SelfT decompressClientRequest(boolean enable) {
        return this.decompressClientRequest(enable, null, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(boolean enable, ClickHouseCompression compressAlgorithm) {
        return this.decompressClientRequest(enable, compressAlgorithm, (Integer)ClickHouseClientOption.DECOMPRESS_LEVEL.getEffectiveDefaultValue());
    }

    public SelfT decompressClientRequest(boolean enable, ClickHouseCompression compressAlgorithm, int compressLevel) {
        this.checkSealed();
        if (compressAlgorithm == null) {
            ClickHouseCompression clickHouseCompression = compressAlgorithm = enable ? (ClickHouseCompression)((Object)ClickHouseClientOption.DECOMPRESS_ALGORITHM.getEffectiveDefaultValue()) : ClickHouseCompression.NONE;
        }
        if (compressLevel < 0) {
            compressLevel = 0;
        } else if (compressLevel > 9) {
            compressLevel = 9;
        }
        this.option(ClickHouseClientOption.DECOMPRESS, Boolean.valueOf(enable));
        this.option(ClickHouseClientOption.DECOMPRESS_ALGORITHM, (Serializable)((Object)compressAlgorithm));
        this.option(ClickHouseClientOption.DECOMPRESS_LEVEL, Integer.valueOf(compressLevel));
        return (SelfT)this;
    }

    public SelfT addExternal(ClickHouseExternalTable table) {
        this.checkSealed();
        if (this.externalTables.add(ClickHouseChecker.nonNull(table, TYPE_EXTERNAL_TABLE))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT external(ClickHouseExternalTable table, ClickHouseExternalTable ... more) {
        this.checkSealed();
        this.externalTables.clear();
        this.externalTables.add(ClickHouseChecker.nonNull(table, TYPE_EXTERNAL_TABLE));
        if (more != null) {
            for (ClickHouseExternalTable e : more) {
                this.externalTables.add(ClickHouseChecker.nonNull(e, TYPE_EXTERNAL_TABLE));
            }
        }
        return (SelfT)this;
    }

    public SelfT external(Collection<ClickHouseExternalTable> tables) {
        this.checkSealed();
        this.externalTables.clear();
        if (tables != null) {
            for (ClickHouseExternalTable e : tables) {
                this.externalTables.add(ClickHouseChecker.nonNull(e, TYPE_EXTERNAL_TABLE));
            }
        }
        return (SelfT)this;
    }

    public SelfT format(ClickHouseFormat format) {
        this.checkSealed();
        this.option(ClickHouseClientOption.FORMAT, (Serializable)((Object)format));
        return (SelfT)this;
    }

    public SelfT option(ClickHouseOption option, Serializable value) {
        this.checkSealed();
        if (value == null) {
            return this.removeOption(option);
        }
        Serializable oldValue = this.options.put(ClickHouseChecker.nonNull(option, "Option"), value);
        if (oldValue == null || !oldValue.equals(value)) {
            if (this.changeListener != null) {
                this.changeListener.optionChanged(this, option, oldValue, value);
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT options(Map<ClickHouseOption, Serializable> options) {
        this.checkSealed();
        if (this.changeListener == null) {
            this.options.clear();
            if (options != null) {
                this.options.putAll(options);
            }
            this.resetCache();
        } else {
            HashMap<ClickHouseOption, Serializable> m = new HashMap<ClickHouseOption, Serializable>();
            m.putAll(this.options);
            if (options != null) {
                for (Map.Entry<ClickHouseOption, Serializable> e : options.entrySet()) {
                    this.option(e.getKey(), e.getValue());
                    m.remove(e.getKey());
                }
            }
            for (ClickHouseOption o : m.keySet()) {
                this.removeOption(o);
            }
        }
        return (SelfT)this;
    }

    public SelfT options(Properties options) {
        this.checkSealed();
        HashMap<ClickHouseOption, Serializable> m = new HashMap<ClickHouseOption, Serializable>();
        m.putAll(this.options);
        if (options != null) {
            for (Map.Entry<Object, Object> e : options.entrySet()) {
                ClickHouseClientOption o;
                Object key = e.getKey();
                Object value = e.getValue();
                if (key == null || value == null || (o = ClickHouseClientOption.fromKey(key.toString())) == null) continue;
                this.option(o, ClickHouseOption.fromString(value.toString(), o.getValueType()));
                m.remove(o);
            }
        }
        for (ClickHouseOption o : m.keySet()) {
            this.removeOption(o);
        }
        return (SelfT)this;
    }

    public SelfT params(Collection<String> values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && !values.isEmpty()) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (String v : values) {
                this.namedParameters.put(names.get(index), v);
                if (++index < size) continue;
                break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(ClickHouseValue value, ClickHouseValue ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        if (value != null) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            this.namedParameters.put(names.get(index++), value.toSqlExpression());
            if (more != null && more.length > 0) {
                for (ClickHouseValue v : more) {
                    if (index >= size) break;
                    this.namedParameters.put(names.get(index++), v != null ? v.toSqlExpression() : "NULL");
                }
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(ClickHouseValue[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (ClickHouseValue v : values) {
                this.namedParameters.put(names.get(index), v != null ? v.toSqlExpression() : "NULL");
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(String value, String ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        List<String> names = this.getPreparedQuery().getParameters();
        int size = names.size();
        int index = 0;
        this.namedParameters.put(names.get(index++), value);
        if (more != null && more.length > 0) {
            for (String v : more) {
                if (index >= size) break;
                this.namedParameters.put(names.get(index++), v);
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(String[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (String v : values) {
                this.namedParameters.put(names.get(index), v);
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Object value, Object ... more) {
        this.checkSealed();
        this.namedParameters.clear();
        List<String> names = this.getPreparedQuery().getParameters();
        int size = names.size();
        int index = 0;
        this.namedParameters.put(names.get(index++), ClickHouseValues.convertToSqlExpression(value));
        if (more != null && more.length > 0) {
            for (Object v : more) {
                if (index >= size) break;
                this.namedParameters.put(names.get(index++), ClickHouseValues.convertToSqlExpression(v));
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Object[] values) {
        this.checkSealed();
        this.namedParameters.clear();
        if (values != null && values.length > 0) {
            List<String> names = this.getPreparedQuery().getParameters();
            int size = names.size();
            int index = 0;
            for (Object v : values) {
                this.namedParameters.put(names.get(index), ClickHouseValues.convertToSqlExpression(v));
                if (++index >= size) break;
            }
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT params(Map<String, String> namedParams) {
        this.checkSealed();
        this.namedParameters.clear();
        if (namedParams != null) {
            this.namedParameters.putAll(namedParams);
        }
        this.resetCache();
        return (SelfT)this;
    }

    public SelfT query(ClickHouseParameterizedQuery query) {
        return this.query(query, null);
    }

    public SelfT query(String sql) {
        return this.query(sql, null);
    }

    public SelfT query(ClickHouseParameterizedQuery query, String queryId) {
        this.checkSealed();
        if (!ClickHouseChecker.nonNull(query, PROP_QUERY).equals(this.preparedQuery)) {
            this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, query);
            this.sql = this.changeProperty(PROP_QUERY, this.sql, query.getOriginalQuery());
            this.resetCache();
        }
        this.queryId = this.changeProperty(PROP_QUERY_ID, this.queryId, queryId);
        return (SelfT)this;
    }

    public SelfT query(String query, String queryId) {
        this.checkSealed();
        if (!ClickHouseChecker.nonBlank(query, PROP_QUERY).equals(this.sql)) {
            this.sql = this.changeProperty(PROP_QUERY, this.sql, query);
            this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, null);
            this.resetCache();
        }
        this.queryId = this.changeProperty(PROP_QUERY_ID, this.queryId, queryId);
        return (SelfT)this;
    }

    public SelfT clearSession() {
        this.checkSealed();
        this.removeOption(ClickHouseClientOption.SESSION_ID);
        this.removeOption(ClickHouseClientOption.SESSION_CHECK);
        this.removeOption(ClickHouseClientOption.SESSION_TIMEOUT);
        return (SelfT)this;
    }

    public SelfT session(String sessionId) {
        return this.session(sessionId, null, null);
    }

    public SelfT session(String sessionId, Boolean check) {
        return this.session(sessionId, check, null);
    }

    public SelfT session(String sessionId, Integer timeout) {
        return this.session(sessionId, null, timeout);
    }

    public SelfT session(String sessionId, Boolean check, Integer timeout) {
        this.checkSealed();
        this.option(ClickHouseClientOption.SESSION_ID, (Serializable)((Object)sessionId));
        this.option(ClickHouseClientOption.SESSION_CHECK, check);
        this.option(ClickHouseClientOption.SESSION_TIMEOUT, timeout);
        return (SelfT)this;
    }

    public SelfT set(String setting, Serializable value) {
        this.checkSealed();
        if (value == null) {
            return this.removeSetting(setting);
        }
        Serializable oldValue = this.settings.put(ClickHouseChecker.nonBlank(setting, "setting"), value);
        if (oldValue == null || !oldValue.equals(value)) {
            if (this.changeListener != null) {
                this.changeListener.settingChanged(this, setting, oldValue, value);
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT set(String setting, String value) {
        this.checkSealed();
        return this.set(setting, (Serializable)((Object)ClickHouseUtils.escape(value, '\'')));
    }

    public SelfT table(String table) {
        return this.table(table, null);
    }

    public SelfT table(String table, String queryId) {
        return this.query("SELECT * FROM " + ClickHouseChecker.nonBlank(table, "table"), queryId);
    }

    public SelfT use(String database) {
        this.checkSealed();
        this.option(ClickHouseClientOption.DATABASE, (Serializable)((Object)database));
        return (SelfT)this;
    }

    public SelfT removeExternal(ClickHouseExternalTable external) {
        this.checkSealed();
        if (this.externalTables.remove(ClickHouseChecker.nonNull(external, TYPE_EXTERNAL_TABLE))) {
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeExternal(String name) {
        this.checkSealed();
        if (!ClickHouseChecker.isNullOrEmpty(name)) {
            boolean removed = false;
            Iterator<ClickHouseExternalTable> i = this.externalTables.iterator();
            while (i.hasNext()) {
                ClickHouseExternalTable e = i.next();
                if (!name.equals(e.getName())) continue;
                i.remove();
                removed = true;
            }
            if (removed) {
                this.resetCache();
            }
        }
        return (SelfT)this;
    }

    public SelfT removeOption(ClickHouseOption option) {
        this.checkSealed();
        Serializable oldValue = this.options.remove(ClickHouseChecker.nonNull(option, "option"));
        if (oldValue != null) {
            if (this.changeListener != null) {
                this.changeListener.optionChanged(this, option, oldValue, null);
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT removeSetting(String setting) {
        this.checkSealed();
        Serializable oldValue = this.settings.remove(ClickHouseChecker.nonBlank(setting, "setting"));
        if (oldValue != null) {
            if (this.changeListener != null) {
                this.changeListener.settingChanged(this, setting, oldValue, null);
            }
            this.resetCache();
        }
        return (SelfT)this;
    }

    public SelfT reset() {
        this.checkSealed();
        this.externalTables.clear();
        if (this.changeListener == null) {
            this.options.clear();
            this.settings.clear();
        } else {
            for (ClickHouseOption o : this.options.keySet().toArray(new ClickHouseOption[0])) {
                this.removeOption(o);
            }
            for (String s : this.settings.keySet().toArray(new String[0])) {
                this.removeSetting(s);
            }
            this.changeListener = null;
        }
        this.namedParameters.clear();
        this.input = this.changeProperty(PROP_DATA, this.input, null);
        this.sql = this.changeProperty(PROP_QUERY, this.sql, null);
        this.preparedQuery = this.changeProperty(PROP_PREPARED_QUERY, this.preparedQuery, null);
        this.queryId = this.changeProperty(PROP_QUERY_ID, this.queryId, null);
        this.resetCache();
        return (SelfT)this;
    }

    public ClickHouseRequest<SelfT> seal() {
        ClickHouseRequest<SelfT> req = this;
        if (!this.isSealed()) {
            req = new ClickHouseRequest<SelfT>(this.client, this.getServer(), true);
            req.externalTables.addAll(this.externalTables);
            req.options.putAll(this.options);
            req.settings.putAll(this.settings);
            req.namedParameters.putAll(this.namedParameters);
            req.input = this.input;
            req.queryId = this.queryId;
            req.sql = this.sql;
            req.preparedQuery = this.preparedQuery;
        }
        return req;
    }

    public Mutation write() {
        this.checkSealed();
        return new Mutation(this, false);
    }

    public CompletableFuture<ClickHouseResponse> execute() {
        return this.getClient().execute(this.isSealed() ? this : this.seal());
    }

    public ClickHouseResponse executeAndWait() throws ClickHouseException {
        return this.getClient().executeAndWait(this.isSealed() ? this : this.seal());
    }

    public static class Mutation
    extends ClickHouseRequest<Mutation> {
        protected Mutation(ClickHouseRequest<?> request, boolean sealed) {
            super(request.getClient(), request.server, sealed);
            this.options.putAll(request.options);
            this.settings.putAll(request.settings);
        }

        @Override
        protected String getQuery() {
            if (this.input != null && this.sql != null) {
                char ch;
                int len;
                int tmp = 0;
                int index = len = this.sql.length();
                while ((tmp = ClickHouseUtils.skipContentsUntil(this.sql, tmp, this.sql.length(), "format", false)) < len) {
                    index = tmp;
                }
                StringBuilder builder = new StringBuilder();
                boolean spaces = false;
                while (index < len && !ClickHouseUtils.isQuote(ch = this.sql.charAt(index)) && !ClickHouseUtils.isOpenBracket(ch)) {
                    if (Character.isWhitespace(ch)) {
                        if (builder.length() > 0) {
                            spaces = true;
                        }
                    } else if (index + 1 < len) {
                        char nextCh = this.sql.charAt(index + 1);
                        if (ch == '-' && nextCh == '-') {
                            index = ClickHouseUtils.skipSingleLineComment(this.sql, index + 2, len) - 1;
                        } else if (ch == '/' && nextCh == '*') {
                            index = ClickHouseUtils.skipMultiLineComment(this.sql, index + 2, len) - 1;
                        } else if (ch == '\\') {
                            ++index;
                        } else {
                            if (spaces) break;
                            builder.append(ch);
                        }
                    } else {
                        if (spaces) break;
                        builder.append(ch);
                    }
                    ++index;
                }
                return builder.length() > 0 && index == len ? this.sql : this.sql + "\n FORMAT " + this.getInputFormat().name();
            }
            return super.getQuery();
        }

        @Override
        public Mutation format(ClickHouseFormat format) {
            if (!ClickHouseChecker.nonNull(format, "format").supportsInput()) {
                throw new IllegalArgumentException("Only input format is allowed for mutation.");
            }
            return (Mutation)super.format(format);
        }

        public Mutation data(String file) {
            return this.data(file, ClickHouseCompression.fromFileName(file));
        }

        public Mutation data(String file, ClickHouseCompression compression) {
            this.checkSealed();
            Mutation self = this;
            String fileName = ClickHouseChecker.nonEmpty(file, "File");
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, ClickHouseDeferredValue.of(() -> {
                try {
                    return ClickHouseInputStream.of((InputStream)new FileInputStream(fileName), self.getConfig().getReadBufferSize(), compression);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }));
            return this;
        }

        public Mutation data(InputStream input) {
            return this.data(ClickHouseInputStream.of(input));
        }

        public Mutation data(ClickHouseInputStream input) {
            this.checkSealed();
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, ClickHouseDeferredValue.of(input, ClickHouseInputStream.class));
            return this;
        }

        public Mutation data(ClickHouseDeferredValue<ClickHouseInputStream> input) {
            this.checkSealed();
            this.input = this.changeProperty(ClickHouseRequest.PROP_DATA, this.input, input);
            return this;
        }

        public CompletableFuture<ClickHouseResponse> send() {
            return this.execute();
        }

        public ClickHouseResponse sendAndWait() throws ClickHouseException {
            return this.executeAndWait();
        }

        @Override
        public Mutation table(String table, String queryId) {
            this.checkSealed();
            super.query("INSERT INTO " + ClickHouseChecker.nonBlank(table, "table"), queryId);
            return this;
        }

        public Mutation seal() {
            Mutation req = this;
            if (!this.isSealed()) {
                req = new Mutation(this, true);
                req.externalTables.addAll(this.externalTables);
                req.options.putAll(this.options);
                req.settings.putAll(this.settings);
                req.namedParameters.putAll(this.namedParameters);
                req.input = this.input;
                req.queryId = this.queryId;
                req.sql = this.sql;
                req.preparedQuery = this.preparedQuery;
            }
            return req;
        }
    }
}

