/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getsubfolders;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersData;
import org.apache.hop.pipeline.transforms.getsubfolders.GetSubFoldersMeta;

public class GetSubFolders
extends BaseTransform<GetSubFoldersMeta, GetSubFoldersData> {
    private static final Class<?> PKG = GetSubFoldersMeta.class;

    public GetSubFolders(TransformMeta transformMeta, GetSubFoldersMeta meta, GetSubFoldersData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)((GetSubFoldersData)this.data).outputRowMeta.size());
        return rowData;
    }

    public boolean processRow() throws HopException {
        block21: {
            if (((GetSubFoldersMeta)this.meta).isFoldernameDynamic() && ((GetSubFoldersData)this.data).filenr >= ((GetSubFoldersData)this.data).filessize) {
                ((GetSubFoldersData)this.data).readrow = this.getRow();
            }
            if (this.first) {
                this.first = false;
                if (((GetSubFoldersMeta)this.meta).isFoldernameDynamic()) {
                    ((GetSubFoldersData)this.data).inputRowMeta = this.getInputRowMeta();
                    ((GetSubFoldersData)this.data).outputRowMeta = ((GetSubFoldersData)this.data).inputRowMeta.clone();
                    ((GetSubFoldersMeta)this.meta).getFields(((GetSubFoldersData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((GetSubFoldersData)this.data).totalpreviousfields = ((GetSubFoldersData)this.data).inputRowMeta.size();
                    if (Utils.isEmpty((CharSequence)((GetSubFoldersMeta)this.meta).getDynamicFoldernameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NoField", (String[])new String[0]));
                    }
                    if (((GetSubFoldersData)this.data).indexOfFoldernameField < 0) {
                        String realDynamicFoldername = this.resolve(((GetSubFoldersMeta)this.meta).getDynamicFoldernameField());
                        ((GetSubFoldersData)this.data).indexOfFoldernameField = ((GetSubFoldersData)this.data).inputRowMeta.indexOfValue(realDynamicFoldername);
                        if (((GetSubFoldersData)this.data).indexOfFoldernameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.ErrorFindingField", (String[])new String[0]) + "[" + realDynamicFoldername + "]");
                            throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.CouldnotFindField", (String[])new String[]{realDynamicFoldername}));
                        }
                    }
                } else {
                    ((GetSubFoldersData)this.data).outputRowMeta = new RowMeta();
                    ((GetSubFoldersMeta)this.meta).getFields(((GetSubFoldersData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                    ((GetSubFoldersData)this.data).files = ((GetSubFoldersMeta)this.meta).getFolderList((IVariables)this);
                    ((GetSubFoldersData)this.data).filessize = ((GetSubFoldersData)this.data).files.nrOfFiles();
                    this.handleMissingFiles();
                }
                ((GetSubFoldersData)this.data).nrTransformFields = ((GetSubFoldersData)this.data).outputRowMeta.size();
            }
            if (((GetSubFoldersMeta)this.meta).isFoldernameDynamic()) {
                if (((GetSubFoldersData)this.data).readrow == null) {
                    this.setOutputDone();
                    return false;
                }
            } else if (((GetSubFoldersData)this.data).filenr >= ((GetSubFoldersData)this.data).filessize) {
                this.setOutputDone();
                return false;
            }
            try {
                Object[] outputRow = this.buildEmptyRow();
                int outputIndex = 0;
                Object[] extraData = new Object[((GetSubFoldersData)this.data).nrTransformFields];
                if (((GetSubFoldersMeta)this.meta).isFoldernameDynamic()) {
                    if (((GetSubFoldersData)this.data).filenr >= ((GetSubFoldersData)this.data).filessize) {
                        String filename = this.getInputRowMeta().getString(((GetSubFoldersData)this.data).readrow, ((GetSubFoldersData)this.data).indexOfFoldernameField);
                        String[] filesname = new String[]{filename};
                        String[] filesrequired = new String[]{"N"};
                        ((GetSubFoldersData)this.data).files = ((GetSubFoldersMeta)this.meta).getDynamicFolderList((IVariables)this, filesname, filesrequired);
                        ((GetSubFoldersData)this.data).filessize = ((GetSubFoldersData)this.data).files.nrOfFiles();
                        ((GetSubFoldersData)this.data).filenr = 0;
                    }
                    outputRow = (Object[])((GetSubFoldersData)this.data).readrow.clone();
                }
                if (((GetSubFoldersData)this.data).filessize <= 0) break block21;
                ((GetSubFoldersData)this.data).file = ((GetSubFoldersData)this.data).files.getFile(((GetSubFoldersData)this.data).filenr);
                extraData[outputIndex++] = HopVfs.getFilename((FileObject)((GetSubFoldersData)this.data).file);
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.getName().getBaseName();
                try {
                    extraData[outputIndex++] = HopVfs.getFilename((FileObject)((GetSubFoldersData)this.data).file.getParent());
                    extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.isHidden();
                    extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.isReadable();
                    extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.isWriteable();
                    extraData[outputIndex++] = new Date(((GetSubFoldersData)this.data).file.getContent().getLastModifiedTime());
                }
                catch (IOException e) {
                    throw new HopException((Throwable)e);
                }
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.getName().getURI();
                extraData[outputIndex++] = ((GetSubFoldersData)this.data).file.getName().getRootURI();
                extraData[outputIndex++] = (long)((GetSubFoldersData)this.data).file.getChildren().length;
                if (((GetSubFoldersMeta)this.meta).includeRowNumber() && !Utils.isEmpty((CharSequence)((GetSubFoldersMeta)this.meta).getRowNumberField())) {
                    extraData[outputIndex++] = ((GetSubFoldersData)this.data).rownr;
                }
                ++((GetSubFoldersData)this.data).rownr;
                outputRow = RowDataUtil.addRowData((Object[])outputRow, (int)((GetSubFoldersData)this.data).totalpreviousfields, (Object[])extraData);
                this.putRow(((GetSubFoldersData)this.data).outputRowMeta, outputRow);
                if (((GetSubFoldersData)this.data).filenr < ((GetSubFoldersData)this.data).filessize) {
                    return this.processRow();
                }
                if (((GetSubFoldersMeta)this.meta).getRowLimit() > 0L && ((GetSubFoldersData)this.data).rownr >= ((GetSubFoldersMeta)this.meta).getRowLimit()) {
                    this.setOutputDone();
                    return false;
                }
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        ++((GetSubFoldersData)this.data).filenr;
        if (this.checkFeedback(this.getLinesInput()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"GetSubFolders.Log.NrLine", (String[])new String[]{"" + this.getLinesInput()}));
        }
        return true;
    }

    private void handleMissingFiles() throws HopException {
        List nonExistantFiles = ((GetSubFoldersData)this.data).files.getNonExistantFiles();
        if (nonExistantFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Error.MissingFiles", (String[])new String[]{message}));
            throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.MissingFiles", (String[])new String[]{message}));
        }
        List nonAccessibleFiles = ((GetSubFoldersData)this.data).files.getNonAccessibleFiles();
        if (nonAccessibleFiles.size() != 0) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            this.logError(BaseMessages.getString(PKG, (String)"GetSubFolders.Error.NoAccessibleFiles", (String[])new String[]{message}));
            throw new HopException(BaseMessages.getString(PKG, (String)"GetSubFolders.Exception.NoAccessibleFiles", (String[])new String[]{message}));
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                ((GetSubFoldersData)this.data).filessize = 0;
                ((GetSubFoldersData)this.data).rownr = 1L;
                ((GetSubFoldersData)this.data).filenr = 0;
                ((GetSubFoldersData)this.data).totalpreviousfields = 0;
            }
            catch (Exception e) {
                this.logError("Error initializing transform: " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        if (((GetSubFoldersData)this.data).file != null) {
            try {
                ((GetSubFoldersData)this.data).file.close();
                ((GetSubFoldersData)this.data).file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }
}

