/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.testing;

import java.util.Collections;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestDatabaseReplacement;
import org.apache.hop.testing.VariableValue;
import org.apache.hop.testing.util.DataSetConst;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class PipelineUnitTestEditor
extends MetadataEditor<PipelineUnitTest> {
    private static final Class<?> PKG = PipelineUnitTestEditor.class;
    private Text wName;
    private Text wDescription;
    private Combo wTestType;
    private Text wPipelineFilename;
    private TextVar wFilename;
    private TextVar wBasePath;
    private Button wAutoOpen;
    private TableView wDbReplacements;
    private TableView wVariableValues;
    private final PropsUi props;
    protected IHopMetadataProvider metadataProvider;

    public PipelineUnitTestEditor(HopGui hopGui, MetadataManager<PipelineUnitTest> manager, PipelineUnitTest metadata) {
        super(hopGui, manager, (IHopMetadata)metadata);
        this.metadataProvider = manager.getMetadataProvider();
        this.props = PropsUi.getInstance();
    }

    public void createControl(Composite parent) {
        List<String> dbNames;
        PipelineUnitTest pipelineUnitTest = (PipelineUnitTest)this.getMetadata();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label(parent, 131072);
        this.props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        this.props.setLook((Control)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Text lastControl = this.wName;
        Label wlDescription = new Label(parent, 131072);
        this.props.setLook((Control)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.Description.Label", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)lastControl, margin);
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, -margin);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(parent, 18436);
        this.props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, 0, 0x1000000);
        fdDescription.left = new FormAttachment(middle, 0);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        lastControl = this.wDescription;
        Label wlTestType = new Label(parent, 131072);
        this.props.setLook((Control)wlTestType);
        wlTestType.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.TestType.Label", (String[])new String[0]));
        FormData fdlTestType = new FormData();
        fdlTestType.top = new FormAttachment((Control)lastControl, margin);
        fdlTestType.left = new FormAttachment(0, 0);
        fdlTestType.right = new FormAttachment(middle, -margin);
        wlTestType.setLayoutData((Object)fdlTestType);
        this.wTestType = new Combo(parent, 18436);
        FormData fdTestType = new FormData();
        fdTestType.top = new FormAttachment((Control)wlTestType, 0, 0x1000000);
        fdTestType.left = new FormAttachment(middle, 0);
        fdTestType.right = new FormAttachment(100, 0);
        this.wTestType.setLayoutData((Object)fdTestType);
        this.wTestType.setItems(DataSetConst.getTestTypeDescriptions());
        lastControl = this.wTestType;
        Label wlPipelineFilename = new Label(parent, 131072);
        this.props.setLook((Control)wlPipelineFilename);
        wlPipelineFilename.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.PipelineFilename.Label", (String[])new String[0]));
        FormData fdlPipelineFilename = new FormData();
        fdlPipelineFilename.top = new FormAttachment((Control)lastControl, margin);
        fdlPipelineFilename.left = new FormAttachment(0, 0);
        fdlPipelineFilename.right = new FormAttachment(middle, -margin);
        wlPipelineFilename.setLayoutData((Object)fdlPipelineFilename);
        this.wPipelineFilename = new Text(parent, 18436);
        this.props.setLook((Control)this.wPipelineFilename);
        FormData fdPipelineFilename = new FormData();
        fdPipelineFilename.top = new FormAttachment((Control)wlPipelineFilename, 0, 0x1000000);
        fdPipelineFilename.left = new FormAttachment(middle, 0);
        fdPipelineFilename.right = new FormAttachment(100, 0);
        this.wPipelineFilename.setLayoutData((Object)fdPipelineFilename);
        lastControl = this.wPipelineFilename;
        Label wlFilename = new Label(parent, 131072);
        this.props.setLook((Control)wlFilename);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.Filename.Label", (String[])new String[0]));
        FormData fdlFilename = new FormData();
        fdlFilename.top = new FormAttachment((Control)lastControl, margin);
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new TextVar(this.manager.getVariables(), parent, 18436);
        this.props.setLook((Control)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment(100, 0);
        this.wFilename.setLayoutData((Object)fdFilename);
        lastControl = this.wFilename;
        Label wlBasePath = new Label(parent, 131072);
        this.props.setLook((Control)wlBasePath);
        wlBasePath.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.BasePath.Label", (String[])new String[0]));
        FormData fdlBasePath = new FormData();
        fdlBasePath.top = new FormAttachment((Control)lastControl, margin);
        fdlBasePath.left = new FormAttachment(0, 0);
        fdlBasePath.right = new FormAttachment(middle, -margin);
        wlBasePath.setLayoutData((Object)fdlBasePath);
        this.wBasePath = new TextVar(this.manager.getVariables(), parent, 18436);
        this.props.setLook((Control)this.wBasePath);
        FormData fdBasePath = new FormData();
        fdBasePath.top = new FormAttachment((Control)wlBasePath, 0, 0x1000000);
        fdBasePath.left = new FormAttachment(middle, 0);
        fdBasePath.right = new FormAttachment(100, 0);
        this.wBasePath.setLayoutData((Object)fdBasePath);
        lastControl = this.wBasePath;
        Label wlAutoOpen = new Label(parent, 131072);
        this.props.setLook((Control)wlAutoOpen);
        wlAutoOpen.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.AutoOpen.Label", (String[])new String[0]));
        FormData fdlAutoOpen = new FormData();
        fdlAutoOpen.top = new FormAttachment((Control)lastControl, margin);
        fdlAutoOpen.left = new FormAttachment(0, 0);
        fdlAutoOpen.right = new FormAttachment(middle, -margin);
        wlAutoOpen.setLayoutData((Object)fdlAutoOpen);
        this.wAutoOpen = new Button(parent, 32);
        this.props.setLook((Control)this.wAutoOpen);
        FormData fdAutoOpen = new FormData();
        fdAutoOpen.top = new FormAttachment((Control)wlAutoOpen, 0, 0x1000000);
        fdAutoOpen.left = new FormAttachment(middle, 0);
        fdAutoOpen.right = new FormAttachment(100, 0);
        this.wAutoOpen.setLayoutData((Object)fdAutoOpen);
        lastControl = this.wAutoOpen;
        Label wlFieldMapping = new Label(parent, 0);
        wlFieldMapping.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.DbReplacements.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFieldMapping);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment((Control)lastControl, 3 * margin);
        wlFieldMapping.setLayoutData((Object)fdlUpIns);
        lastControl = wlFieldMapping;
        try {
            dbNames = this.metadataProvider.getSerializer(DatabaseMeta.class).listObjectNames();
            Collections.sort(dbNames);
        }
        catch (HopException e2) {
            LogChannel.UI.logError("Error getting list of databases", (Throwable)e2);
            dbNames = Collections.emptyList();
        }
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.DbReplacement.ColumnInfo.OriginalDb", (String[])new String[0]), 2, dbNames.toArray(new String[0]), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.DbReplacement.ColumnInfo.ReplacementDb", (String[])new String[0]), 2, dbNames.toArray(new String[0]), false)};
        columns[0].setUsingVariables(true);
        columns[1].setUsingVariables(true);
        this.wDbReplacements = new TableView((IVariables)new Variables(), parent, 68354, columns, pipelineUnitTest.getTweaks().size(), null, this.props);
        FormData fdDbReplacements = new FormData();
        fdDbReplacements.left = new FormAttachment(0, 0);
        fdDbReplacements.top = new FormAttachment((Control)lastControl, margin);
        fdDbReplacements.right = new FormAttachment(100, 0);
        fdDbReplacements.bottom = new FormAttachment((Control)lastControl, 250);
        this.wDbReplacements.setLayoutData((Object)fdDbReplacements);
        lastControl = this.wDbReplacements;
        Label wlVariableValues = new Label(parent, 0);
        wlVariableValues.setText(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.VariableValues.Label", (String[])new String[0]));
        this.props.setLook((Control)wlVariableValues);
        FormData fdlVariableValues = new FormData();
        fdlVariableValues.left = new FormAttachment(0, 0);
        fdlVariableValues.top = new FormAttachment((Control)lastControl, margin);
        wlVariableValues.setLayoutData((Object)fdlVariableValues);
        lastControl = wlVariableValues;
        ColumnInfo[] varValColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.VariableValues.ColumnInfo.VariableName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PipelineUnitTestDialog.VariableValues.ColumnInfo.VariableValue", (String[])new String[0]), 1, false)};
        varValColumns[0].setUsingVariables(true);
        varValColumns[1].setUsingVariables(true);
        this.wVariableValues = new TableView((IVariables)new Variables(), parent, 68354, varValColumns, pipelineUnitTest.getVariableValues().size(), null, this.props);
        FormData fdVariableValues = new FormData();
        fdVariableValues.left = new FormAttachment(0, 0);
        fdVariableValues.top = new FormAttachment((Control)lastControl, margin);
        fdVariableValues.right = new FormAttachment(100, 0);
        fdVariableValues.bottom = new FormAttachment(100, -2 * margin);
        this.wVariableValues.setLayoutData((Object)fdVariableValues);
        this.setWidgetsContent();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wDescription.addListener(24, modifyListener);
        this.wTestType.addListener(24, modifyListener);
        this.wPipelineFilename.addListener(24, modifyListener);
        this.wFilename.addListener(24, modifyListener);
        this.wBasePath.addListener(24, modifyListener);
        this.wAutoOpen.addListener(13, modifyListener);
    }

    public void setWidgetsContent() {
        int i;
        PipelineUnitTest pipelineUnitTest = (PipelineUnitTest)this.getMetadata();
        this.wName.setText(Const.NVL((String)pipelineUnitTest.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)pipelineUnitTest.getDescription(), (String)""));
        this.wTestType.setText(Const.NVL((String)DataSetConst.getTestTypeDescription(pipelineUnitTest.getType()), (String)""));
        this.wPipelineFilename.setText(Const.NVL((String)pipelineUnitTest.getPipelineFilename(), (String)""));
        this.wFilename.setText(Const.NVL((String)pipelineUnitTest.getFilename(), (String)""));
        this.wBasePath.setText(Const.NVL((String)pipelineUnitTest.getBasePath(), (String)""));
        this.wAutoOpen.setSelection(pipelineUnitTest.isAutoOpening());
        for (i = 0; i < pipelineUnitTest.getDatabaseReplacements().size(); ++i) {
            PipelineUnitTestDatabaseReplacement dbReplacement = pipelineUnitTest.getDatabaseReplacements().get(i);
            this.wDbReplacements.setText(Const.NVL((String)dbReplacement.getOriginalDatabaseName(), (String)""), 1, i);
            this.wDbReplacements.setText(Const.NVL((String)dbReplacement.getReplacementDatabaseName(), (String)""), 2, i);
        }
        for (i = 0; i < pipelineUnitTest.getVariableValues().size(); ++i) {
            VariableValue variableValue = pipelineUnitTest.getVariableValues().get(i);
            this.wVariableValues.setText(Const.NVL((String)variableValue.getKey(), (String)""), 1, i);
            this.wVariableValues.setText(Const.NVL((String)variableValue.getValue(), (String)""), 2, i);
        }
        this.wDbReplacements.removeEmptyRows();
        this.wDbReplacements.setRowNums();
    }

    public void getWidgetsContent(PipelineUnitTest test) {
        test.setName(this.wName.getText());
        test.setDescription(this.wDescription.getText());
        test.setType(DataSetConst.getTestTypeForDescription(this.wTestType.getText()));
        test.setPipelineFilename(this.wPipelineFilename.getText());
        test.setFilename(this.wFilename.getText());
        test.setBasePath(this.wBasePath.getText());
        test.setAutoOpening(this.wAutoOpen.getSelection());
        test.getDatabaseReplacements().clear();
        int nrFields = this.wDbReplacements.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wDbReplacements.getNonEmpty(i);
            String sourceDb = item.getText(1);
            String replaceDb = item.getText(2);
            PipelineUnitTestDatabaseReplacement dbReplacement = new PipelineUnitTestDatabaseReplacement(sourceDb, replaceDb);
            test.getDatabaseReplacements().add(dbReplacement);
        }
        test.getVariableValues().clear();
        int nrVars = this.wVariableValues.nrNonEmpty();
        for (int i = 0; i < nrVars; ++i) {
            TableItem item = this.wVariableValues.getNonEmpty(i);
            String key = item.getText(1);
            String value = item.getText(2);
            VariableValue variableValue = new VariableValue(key, value);
            test.getVariableValues().add(variableValue);
        }
    }
}

