/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.CoderHelpers;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderFactory;
import org.apache.beam.sdk.coders.Coder;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.ObjectType;

public class EncoderHelpers {
    private static final DataType OBJECT_TYPE = new ObjectType(Object.class);

    public static <T> Encoder<T> fromBeamCoder(Coder<T> coder) {
        Class clazz = coder.getEncodedTypeDescriptor().getRawType();
        return EncoderFactory.create(EncoderHelpers.beamSerializer(EncoderHelpers.rootRef(OBJECT_TYPE, true), coder), EncoderHelpers.beamDeserializer(EncoderHelpers.rootCol(DataTypes.BinaryType), coder), clazz);
    }

    private static <T> Expression beamSerializer(Expression obj, Coder<T> coder) {
        Expression[] args = new Expression[]{obj, EncoderHelpers.lit(coder, Coder.class)};
        return EncoderFactory.invokeIfNotNull(CoderHelpers.class, "toByteArray", DataTypes.BinaryType, args);
    }

    private static <T> Expression beamDeserializer(Expression bytes, Coder<T> coder) {
        Expression[] args = new Expression[]{bytes, EncoderHelpers.lit(coder, Coder.class)};
        return EncoderFactory.invokeIfNotNull(CoderHelpers.class, "fromByteArray", OBJECT_TYPE, args);
    }

    private static Expression rootRef(DataType dt, boolean nullable) {
        return new BoundReference(0, dt, nullable);
    }

    private static Expression rootCol(DataType dt) {
        return new GetColumnByOrdinal(0, dt);
    }

    private static <T> Literal lit(T obj, Class<? extends T> cls) {
        return Literal.fromObject(obj, (DataType)new ObjectType(cls));
    }
}

