/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Splitter;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.net.UrlEscapers;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.xds.AbstractXdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.AutoValue_XdsClient_CdsUpdate;
import com.google.bigtable.repackaged.io.grpc.xds.AutoValue_XdsClient_LdsUpdate;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.Endpoints;
import com.google.bigtable.repackaged.io.grpc.xds.EnvoyServerProtoData;
import com.google.bigtable.repackaged.io.grpc.xds.HttpConnectionManager;
import com.google.bigtable.repackaged.io.grpc.xds.LoadStatsManager2;
import com.google.bigtable.repackaged.io.grpc.xds.Locality;
import com.google.bigtable.repackaged.io.grpc.xds.TlsContextManager;
import com.google.bigtable.repackaged.io.grpc.xds.VirtualHost;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class XdsClient {
    XdsClient() {
    }

    static boolean isResourceNameValid(String resourceName, String typeUrl) {
        URI uri;
        Preconditions.checkNotNull(resourceName, "resourceName");
        if (!resourceName.startsWith("xdstp:")) {
            return true;
        }
        try {
            uri = new URI(resourceName);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String path = uri.getPath();
        Splitter slashSplitter = Splitter.on('/').omitEmptyStrings();
        if (path == null) {
            return false;
        }
        List<String> pathSegs = slashSplitter.splitToList(path);
        if (pathSegs.size() < 2) {
            return false;
        }
        String type = pathSegs.get(0);
        return type.equals(slashSplitter.splitToList(typeUrl).get(1));
    }

    static String canonifyResourceName(String resourceName) {
        Preconditions.checkNotNull(resourceName, "resourceName");
        if (!resourceName.startsWith("xdstp:")) {
            return resourceName;
        }
        URI uri = URI.create(resourceName);
        String rawQuery = uri.getRawQuery();
        Splitter ampSplitter = Splitter.on('&').omitEmptyStrings();
        if (rawQuery == null) {
            return resourceName;
        }
        List<String> queries = ampSplitter.splitToList(rawQuery);
        if (queries.size() < 2) {
            return resourceName;
        }
        ArrayList<String> canonicalContextParams = new ArrayList<String>(queries.size());
        for (String query : queries) {
            canonicalContextParams.add(query);
        }
        Collections.sort(canonicalContextParams);
        String canonifiedQuery = Joiner.on('&').join(canonicalContextParams);
        return resourceName.replace(rawQuery, canonifiedQuery);
    }

    static String percentEncodePath(String input) {
        Iterable<String> pathSegs = Splitter.on('/').split(input);
        ArrayList<String> encodedSegs = new ArrayList<String>();
        for (String pathSeg : pathSegs) {
            encodedSegs.add(UrlEscapers.urlPathSegmentEscaper().escape(pathSeg));
        }
        return Joiner.on('/').join(encodedSegs);
    }

    void shutdown() {
        throw new UnsupportedOperationException();
    }

    boolean isShutDown() {
        throw new UnsupportedOperationException();
    }

    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        throw new UnsupportedOperationException();
    }

    TlsContextManager getTlsContextManager() {
        throw new UnsupportedOperationException();
    }

    ListenableFuture<Map<AbstractXdsClient.ResourceType, Map<String, ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        throw new UnsupportedOperationException();
    }

    void watchLdsResource(String resourceName, LdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelLdsResourceWatch(String resourceName, LdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchRdsResource(String resourceName, RdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelRdsResourceWatch(String resourceName, RdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchCdsResource(String resourceName, CdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelCdsResourceWatch(String resourceName, CdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchEdsResource(String resourceName, EdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelEdsResourceWatch(String resourceName, EdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterDropStats addClusterDropStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        throw new UnsupportedOperationException();
    }

    static interface ResourceStore {
        @Nullable
        public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo var1, AbstractXdsClient.ResourceType var2);
    }

    static interface XdsResponseHandler {
        public void handleLdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleRdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleCdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleEdsResponse(Bootstrapper.ServerInfo var1, String var2, List<Any> var3, String var4);

        public void handleStreamClosed(Status var1);

        public void handleStreamRestarted(Bootstrapper.ServerInfo var1);
    }

    static final class ResourceMetadata {
        private final String version;
        private final ResourceMetadataStatus status;
        private final long updateTimeNanos;
        @Nullable
        private final Any rawResource;
        @Nullable
        private final UpdateFailureState errorState;

        private ResourceMetadata(ResourceMetadataStatus status, String version, long updateTimeNanos, @Nullable Any rawResource, @Nullable UpdateFailureState errorState) {
            this.status = Preconditions.checkNotNull(status, "status");
            this.version = Preconditions.checkNotNull(version, "version");
            this.updateTimeNanos = updateTimeNanos;
            this.rawResource = rawResource;
            this.errorState = errorState;
        }

        static ResourceMetadata newResourceMetadataUnknown() {
            return new ResourceMetadata(ResourceMetadataStatus.UNKNOWN, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataRequested() {
            return new ResourceMetadata(ResourceMetadataStatus.REQUESTED, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataDoesNotExist() {
            return new ResourceMetadata(ResourceMetadataStatus.DOES_NOT_EXIST, "", 0L, null, null);
        }

        static ResourceMetadata newResourceMetadataAcked(Any rawResource, String version, long updateTimeNanos) {
            Preconditions.checkNotNull(rawResource, "rawResource");
            return new ResourceMetadata(ResourceMetadataStatus.ACKED, version, updateTimeNanos, rawResource, null);
        }

        static ResourceMetadata newResourceMetadataNacked(ResourceMetadata metadata, String failedVersion, long failedUpdateTime, String failedDetails) {
            Preconditions.checkNotNull(metadata, "metadata");
            return new ResourceMetadata(ResourceMetadataStatus.NACKED, metadata.getVersion(), metadata.getUpdateTimeNanos(), metadata.getRawResource(), new UpdateFailureState(failedVersion, failedUpdateTime, failedDetails));
        }

        String getVersion() {
            return this.version;
        }

        ResourceMetadataStatus getStatus() {
            return this.status;
        }

        long getUpdateTimeNanos() {
            return this.updateTimeNanos;
        }

        @Nullable
        Any getRawResource() {
            return this.rawResource;
        }

        @Nullable
        UpdateFailureState getErrorState() {
            return this.errorState;
        }

        static final class UpdateFailureState {
            private final String failedVersion;
            private final long failedUpdateTimeNanos;
            private final String failedDetails;

            private UpdateFailureState(String failedVersion, long failedUpdateTimeNanos, String failedDetails) {
                this.failedVersion = Preconditions.checkNotNull(failedVersion, "failedVersion");
                this.failedUpdateTimeNanos = failedUpdateTimeNanos;
                this.failedDetails = Preconditions.checkNotNull(failedDetails, "failedDetails");
            }

            String getFailedVersion() {
                return this.failedVersion;
            }

            long getFailedUpdateTimeNanos() {
                return this.failedUpdateTimeNanos;
            }

            String getFailedDetails() {
                return this.failedDetails;
            }
        }

        static enum ResourceMetadataStatus {
            UNKNOWN,
            REQUESTED,
            DOES_NOT_EXIST,
            ACKED,
            NACKED;

        }
    }

    static interface EdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(EdsUpdate var1);
    }

    static interface CdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(CdsUpdate var1);
    }

    static interface RdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(RdsUpdate var1);
    }

    static interface LdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(LdsUpdate var1);
    }

    static interface ResourceWatcher {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);
    }

    static interface ResourceUpdate {
    }

    static final class EdsUpdate
    implements ResourceUpdate {
        final String clusterName;
        final Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap;
        final List<Endpoints.DropOverload> dropPolicies;

        EdsUpdate(String clusterName, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints, List<Endpoints.DropOverload> dropPolicies) {
            this.clusterName = Preconditions.checkNotNull(clusterName, "clusterName");
            this.localityLbEndpointsMap = Collections.unmodifiableMap(new LinkedHashMap<Locality, Endpoints.LocalityLbEndpoints>(Preconditions.checkNotNull(localityLbEndpoints, "localityLbEndpoints")));
            this.dropPolicies = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(dropPolicies, "dropPolicies")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("clusterName", this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }
    }

    @AutoValue
    static abstract class CdsUpdate
    implements ResourceUpdate {
        CdsUpdate() {
        }

        abstract String clusterName();

        abstract ClusterType clusterType();

        abstract ImmutableMap<String, ?> lbPolicyConfig();

        abstract long minRingSize();

        abstract long maxRingSize();

        abstract int choiceCount();

        @Nullable
        abstract String edsServiceName();

        @Nullable
        abstract String dnsHostName();

        @Nullable
        abstract Bootstrapper.ServerInfo lrsServerInfo();

        @Nullable
        abstract Long maxConcurrentRequests();

        @Nullable
        abstract EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext();

        @Nullable
        abstract ImmutableList<String> prioritizedClusterNames();

        static Builder forAggregate(String clusterName, List<String> prioritizedClusterNames) {
            Preconditions.checkNotNull(prioritizedClusterNames, "prioritizedClusterNames");
            return new AutoValue_XdsClient_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.AGGREGATE).minRingSize(0L).maxRingSize(0L).choiceCount(0).prioritizedClusterNames(ImmutableList.copyOf(prioritizedClusterNames));
        }

        static Builder forEds(String clusterName, @Nullable String edsServiceName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            return new AutoValue_XdsClient_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.EDS).minRingSize(0L).maxRingSize(0L).choiceCount(0).edsServiceName(edsServiceName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext);
        }

        static Builder forLogicalDns(String clusterName, String dnsHostName, @Nullable Bootstrapper.ServerInfo lrsServerInfo, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
            return new AutoValue_XdsClient_CdsUpdate.Builder().clusterName(clusterName).clusterType(ClusterType.LOGICAL_DNS).minRingSize(0L).maxRingSize(0L).choiceCount(0).dnsHostName(dnsHostName).lrsServerInfo(lrsServerInfo).maxConcurrentRequests(maxConcurrentRequests).upstreamTlsContext(upstreamTlsContext);
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).add("clusterName", this.clusterName()).add("clusterType", (Object)this.clusterType()).add("lbPolicyConfig", this.lbPolicyConfig()).add("minRingSize", this.minRingSize()).add("maxRingSize", this.maxRingSize()).add("choiceCount", this.choiceCount()).add("edsServiceName", this.edsServiceName()).add("dnsHostName", this.dnsHostName()).add("lrsServerInfo", this.lrsServerInfo()).add("maxConcurrentRequests", this.maxConcurrentRequests()).add("prioritizedClusterNames", this.prioritizedClusterNames()).toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            protected abstract Builder clusterName(String var1);

            protected abstract Builder clusterType(ClusterType var1);

            protected abstract Builder lbPolicyConfig(ImmutableMap<String, ?> var1);

            Builder roundRobinLbPolicy() {
                return this.lbPolicyConfig(ImmutableMap.of("round_robin", ImmutableMap.of()));
            }

            Builder ringHashLbPolicy(Long minRingSize, Long maxRingSize) {
                return this.lbPolicyConfig(ImmutableMap.of("ring_hash_experimental", ImmutableMap.of("minRingSize", minRingSize.doubleValue(), "maxRingSize", maxRingSize.doubleValue())));
            }

            Builder leastRequestLbPolicy(Integer choiceCount) {
                return this.lbPolicyConfig(ImmutableMap.of("least_request_experimental", ImmutableMap.of("choiceCount", choiceCount.doubleValue())));
            }

            protected abstract Builder choiceCount(int var1);

            protected abstract Builder minRingSize(long var1);

            protected abstract Builder maxRingSize(long var1);

            protected abstract Builder edsServiceName(String var1);

            protected abstract Builder dnsHostName(String var1);

            protected abstract Builder lrsServerInfo(Bootstrapper.ServerInfo var1);

            protected abstract Builder maxConcurrentRequests(Long var1);

            protected abstract Builder upstreamTlsContext(EnvoyServerProtoData.UpstreamTlsContext var1);

            protected abstract Builder prioritizedClusterNames(List<String> var1);

            abstract CdsUpdate build();
        }

        static enum LbPolicy {
            ROUND_ROBIN,
            RING_HASH,
            LEAST_REQUEST;

        }

        static enum ClusterType {
            EDS,
            LOGICAL_DNS,
            AGGREGATE;

        }
    }

    static final class RdsUpdate
    implements ResourceUpdate {
        final List<VirtualHost> virtualHosts;

        RdsUpdate(List<VirtualHost> virtualHosts) {
            this.virtualHosts = Collections.unmodifiableList(new ArrayList(Preconditions.checkNotNull(virtualHosts, "virtualHosts")));
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("virtualHosts", this.virtualHosts).toString();
        }

        public int hashCode() {
            return Objects.hash(this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsUpdate that = (RdsUpdate)o;
            return Objects.equals(this.virtualHosts, that.virtualHosts);
        }
    }

    @AutoValue
    static abstract class LdsUpdate
    implements ResourceUpdate {
        LdsUpdate() {
        }

        @Nullable
        abstract HttpConnectionManager httpConnectionManager();

        @Nullable
        abstract EnvoyServerProtoData.Listener listener();

        static LdsUpdate forApiListener(HttpConnectionManager httpConnectionManager) {
            Preconditions.checkNotNull(httpConnectionManager, "httpConnectionManager");
            return new AutoValue_XdsClient_LdsUpdate(httpConnectionManager, null);
        }

        static LdsUpdate forTcpListener(EnvoyServerProtoData.Listener listener) {
            Preconditions.checkNotNull(listener, "listener");
            return new AutoValue_XdsClient_LdsUpdate(null, listener);
        }
    }
}

