/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.NameResolverProvider;
import com.google.bigtable.repackaged.io.grpc.internal.ObjectPool;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.XdsInitializationException;
import com.google.bigtable.repackaged.io.grpc.xds.XdsNameResolver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

@Internal
public final class XdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "xds";
    private final String scheme;
    private final Map<String, ?> bootstrapOverride;

    public XdsNameResolverProvider() {
        this(SCHEME, null);
    }

    private XdsNameResolverProvider(String scheme, @Nullable Map<String, ?> bootstrapOverride) {
        this.scheme = Preconditions.checkNotNull(scheme, "scheme");
        this.bootstrapOverride = bootstrapOverride;
    }

    public static XdsNameResolverProvider createForTest(String scheme, @Nullable Map<String, ?> bootstrapOverride) {
        return new XdsNameResolverProvider(scheme, bootstrapOverride);
    }

    @Override
    public XdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (this.scheme.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new XdsNameResolver(targetUri.getAuthority(), name, args.getServiceConfigParser(), args.getSynchronizationContext(), args.getScheduledExecutorService(), this.bootstrapOverride);
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return this.scheme;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 4;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    static interface CallCounterProvider {
        public AtomicLong getOrCreate(String var1, @Nullable String var2);
    }

    static interface XdsClientPoolFactory {
        public void setBootstrapOverride(Map<String, ?> var1);

        @Nullable
        public ObjectPool<XdsClient> get();

        public ObjectPool<XdsClient> getOrCreate() throws XdsInitializationException;
    }
}

